/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.util;

import java.util.HashSet;

public class UUIDTool {
    private static HashSet<Long> hashSet = new HashSet();

    public static String cutUuidToLong(Object uuid, int cutnum) {
        return UUIDTool.getLong16(String.valueOf(uuid), cutnum);
    }

    private static String getLong16(String uuid, int cutnum) {
        String s = UUIDTool.cutUuidToLong(uuid, cutnum);
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.length() <= 16) {
            return s;
        }
        return s.substring(0, 16);
    }

    public static String cutUuidToLong(Object uuid, int cutnum, Integer subStart, Integer subEnd) {
        if (uuid == null) {
            return null;
        }
        String s = String.valueOf(uuid);
        if (s.length() >= subEnd) {
            s = s.substring(subStart, subEnd);
        }
        return UUIDTool.getLong16(s, cutnum);
    }

    public static String cutUuidToLong(String uuid, int cutnum) {
        if (uuid.length() > 16) {
            uuid = uuid.substring(uuid.length() - 16);
        }
        if (cutnum <= 0 || uuid.length() == 0) {
            return null;
        }
        String longId = UUIDTool.uuidToNumString(uuid);
        return longId.length() >= 16 ? longId.substring(0, 16) : longId;
    }

    public static String cutUuidToNumString(String uuidCut, int cutnum) {
        return UUIDTool.uuidToNumString(uuidCut);
    }

    public static void resetLongNumSet() {
        hashSet = new HashSet();
    }

    private static String uuidToNumString(String uuid) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        for (char charitem : chars = uuid.toCharArray()) {
            if (Character.isDigit(charitem)) {
                sb.append(charitem);
                continue;
            }
            sb.append(UUIDTool.getAsciiCode(charitem) - 30);
        }
        return sb.toString();
    }

    private static int getAsciiCode(char ch) {
        return ch;
    }
}

