/**
 * @Description: 角色新增脚本文件
 * @Author: QiuYuanLong
 * @Date: 2019/12/31.
 */

layui.use(['jquery', 'layer', 'Hussar', 'jstree', 'HussarAjax', 'form', 'element', 'table'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var jstree = layui.jstree;
    var form = layui.form;
    var RoleAddManage = {};
    var element = layui.element;
    var table = layui.table;

    /*初始化页面*/
    RoleAddManage.initPage = function () {
        this.initResTree();
        this.initUserTree();
        this.initButtonEvent();
        this.validator();
        RoleAddManage.initFrameHeight();
    }

    /**
     *  加载角色关联用户树
     */
    RoleAddManage.initUserTree = function () {
        var $userTree = $("#userTree");//用户树
        $userTree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/casAppRoles/lazyRoleUserTreeView",
                    "data": function (node) {
                        return {
                            "nodeId": node.id,
                            roleId: $("#roleId").val(),
                            "applicationId": $("#applicationId").val()
                        };
                    }
                }
            },
            plugins: ['types', 'search'],
            types: {
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"},
                "USER": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/user.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            search: RoleAddManage.searchUser(),
            checkbox: {
                keep_selected_style: false,//是否默认选中
                three_state: true,//是否父子级别关联
                tie_selection: false
            }
        });
    };

    /**
     *  角色关联用户树查询
     */
    RoleAddManage.searchUser = function () {
        var to = false;
        $("#searchUser").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#searchUser").val();
                var temp = $("#userTree").is(":hidden");
                if (temp == true) {
                    $("#userTree").show();
                }
                $("#userTree").jstree(true).search(v);
                //添加索引
                if (v != '') {
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#userTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                } else {
                    $(".search-results").html("");
                }
            }, 250);
        });
    };

    /**
     * 加载资源树
     */
    RoleAddManage.initResTree = function () {
        var $retree = $("#resourceTree");//资源树
        $retree.jstree({
            core: {
                check_callback: true,
                data: function (obj, callback) {
                    var data;
                    var ajax = new $ax(Hussar.ctxPath + "/casAppResource/resTree", function (result) {
                        data = result;
                    }, function (data) {
                        Hussar.error(LOAD_RESOURCES_TREE_FAIL);
                    });
                    ajax.set("applicationId", $("#applicationId").val());
                    ajax.start();
                    callback.call(this, data);
                }
            },
            plugins: ['checkbox', 'types', 'search'],
            types: {
                "isModule": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/module.png"},
                "isFun": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/function.png"},
                "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_menu.png"}, //菜单资源
                "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/resource_btn.png"}  //按钮资源
            },
            checkbox: {
                keep_selected_style: false,
                three_state: true,
                tie_selection: false
            },
            search: RoleAddManage.searchResource()
        });
    };

    /**
     * 资源树查询
     */
    RoleAddManage.searchResource = function () {
        var to = false;
        $("#searchResource").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#searchResource").val();
                var temp = $("#resourceTree").is(":hidden");
                if (temp == true) {
                    $("#resourceTree").show();
                }
                $("#resourceTree").jstree(true).search(v);
                //添加索引
                if (v != '') {
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#resourceTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                } else {
                    $(".search-results").html("");
                }
            }, 250);
        });
    }

    /**
     * 获取选中资源id
     */
    RoleAddManage.getCheckedId = function () {
        var ref = $("#resourceTree").jstree(true);
        var nodes = ref.get_checked(true);  //使用get_checked方法
        var nds = '';
        $.each(nodes, function (i, nd) {
            var type = nd.original.isRes;
            if (type == 1) {
                nds += "," + nd.id;
            }
        });
        $("#nds").val("");//选择之前重置nds
        $("#nds").val(nds.substring(1));
    }

    /**
     * 初始化按钮事件
     */
    RoleAddManage.initButtonEvent = function () {
        /* 保存操作 */
        form.on('submit(verify)', function () {
            var data = $("#nodeId").val();//选中角色树的节点
            var roleName = $("#roleName").val();//角色名称
            var roleYw = $("#roleAlias").val();//角色业务含义
            var applicationId = $("#applicationId").val();// 业务系统id
            var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/addRole", function (data) {
                //刷新父页面
                window.parent.CasRoleManage.refreshRoleTree();
                $("#roleId").val(data.roleId);
                Hussar.success(BASIC_INFO_SAVE_SUCCESS);
                $("#saveRole").css("display", "none");
                $("#reset").css("display", "none");
                $("#resourceMsg").removeAttr("style");
                $("#resourceMsg").click();
            }, function () {
                Hussar.error(SAVE_FAIL);
            });
            ajax.set("groupId", data);
            ajax.set("roleName", roleName);
            ajax.set("roleAlias", roleYw);
            ajax.set("applicationId", applicationId);
            ajax.start();
        });

        /**
         * 保存选择资源
         */
        $("#saveResource").click(function () {
            RoleAddManage.getCheckedId();
            var ids = $("#nds").val();//选中资源树的节点
            var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/saveResource", function (data) {
                Hussar.success(data.message);
                $("#userMsg").removeAttr("style");
                $("#userMsg").click();
            }, function (data) {
                Hussar.error(SAVE_FAIL);
            });
            ajax.set("ids", ids);
            ajax.set("roId", $("#roleId").val());
            ajax.set("applicationId", $("#applicationId").val());
            ajax.start();
        });

        /**
         * 初始化左侧的懒加载的组织机构树
         */
        RoleAddManage.initLeftUserTree = function () {
            $userTree = $("#leftOrgTree");
            $userTree.jstree({
                core: {
                    check_callback: true,
                    data: {
                        "url": Hussar.ctxPath + "/orgMain/orgTree",
                        "data": function (node) {
                            return {
                                "parentId": node.id,
                                "isEmployee": ""
                            };
                        }
                    }
                },
                plugins: ['types'],
                types: {
                    "1": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                    "2": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/dept.png"},
                    "3": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                    "9": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/empl.png"}
                }
            });

            // 节点单击事件
            $userTree.bind("activate_node.jstree", function (obj, e) {
                // 记录下当前节点的id
                RoleAddManage.orgNode = e.node.original.id;
                // 刷新列表
                table.reload("checkedTable", {
                    where: {
                        roleId: $("#roleId").val(),
                        orgId: RoleAddManage.orgNode
                    },
                    page: {
                        curr: 1
                    }
                })
            });
        };

        /**
         * 初始化右侧表格
         */
        RoleAddManage.initRightTable = function () {
            // 修改的角色id
            var roleId = $("#roleId").val();
            // 当前组织机构节点的id
            var orgId = RoleAddManage.orgNode;

            // 渲染表格，以复选框标识当前部门下，用户是否拥有该角色
            // 数据表格根据字段值默认选中checkbox
            table = $.extend(table, {config: {checkName: 'hasRole'}});
            table.render({
                elem: '#checkedTable'
                , url: Hussar.ctxPath + "/casAppRoles/getRoleOrgUser"
                , where: {
                    roleId: roleId,
                    orgId: orgId,
                    applicationId: $("#applicationId").val()
                }
                , page: true
                , limit: 10
                , cols: [[ //表头
                    {type: 'checkbox'},
                    {title: '序号', type: 'numbers'},
                    {title: '用户名', field: 'text', align: 'center'},
                    {title: '用户登录账号', field: 'account', align: 'center'},
                    {title: '主键', field: 'id', hide: true}
                ]]
                , even: true
                , height: $("body").height() - 128
            });
        };

        /**
         * 修改关联用户
         */
        $("#saveUser").click(function () {
            // 初始化展示左边树
            RoleAddManage.initLeftUserTree();
            // 初始化右边的表格
            RoleAddManage.initRightTable();

            layer.open({
                type: 1,
                title: '修改角色关联用户',
                area: ['95%', '95%'], //宽高
                fix: false, //不固定
                maxmin: false,
                closeBtn: 1,
                content: $("#userTrans"),
                end: function () {
                    // 刷新树
                    var $userTree = $("#userTree");//用户树
                    $userTree.jstree(true).refresh();
                }
            });
        });

        /**
         * 查询按钮
         */
        $("#queryTable").click(function () {
            // 修改的角色id
            var roleId = $("#roleId").val();
            // 当前组织机构节点的id
            var orgId = RoleAddManage.orgNode;
            var name = $("#name").val();
            var account = $("#account").val();
            table.reload("checkedTable", {
                where: {
                    roleId: roleId,
                    orgId: orgId,
                    name: name,
                    account: account,
                    application: $("#applicationId").val()
                },
                page: {
                    curr: 1
                }
            })
        });

        /**
         * 重置按钮
         */
        $("#resetTable").click(function () {
            // 修改的角色id
            var roleId = $("#roleId").val();
            // 当前组织机构节点的id
            var orgId = RoleAddManage.orgNode;
            $("#name").val("");
            $("#account").val("");
            table.reload("checkedTable", {
                where: {
                    roleId: roleId,
                    orgId: orgId,
                    name: "",
                    account: "",
                    application: $("#applicationId").val()
                },
                page: {
                    curr: 1
                }
            })
        });

        /**
         * 提交按钮
         */
        $("#commitTable").click(function () {
            // 表格缓存的数据
            var tableCache = layui.table.cache.checkedTable;
            // 处理数据
            var addList = [];
            var delList = [];
            if (tableCache.length > 0) {
                for (var i = 0; i < tableCache.length; i++) {
                    var cacheObj = tableCache[i];
                    if (cacheObj.hasRole) {
                        addList.push(cacheObj);
                    } else {
                        delList.push(cacheObj)
                    }
                }
                if (addList.length > 0 || delList.length > 0) {
                    var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/addOrDelUserRole", function (data) {
                        if (data.code === 200) {
                            Hussar.success("提交成功")
                        } else {
                            Hussar.error("提交失败")
                        }
                        // 刷新表格
                        // 修改的角色id
                        var roleId = $("#roleId").val();
                        // 当前组织机构节点的id
                        var orgId = RoleAddManage.orgNode;
                        var name = $("#name").val();
                        var account = $("#account").val();
                        table.reload("checkedTable", {
                            where: {
                                roleId: roleId,
                                orgId: orgId,
                                name: name,
                                account: account,
                                applicationId: $("#applicationId").val()
                            }
                        })
                    }, function (err) {
                        Hussar.error("提交失败")
                    });
                    ajax.set("adds", JSON.stringify(addList));
                    ajax.set("dels", JSON.stringify(delList));
                    ajax.set("roleId", $("#roleId").val());
                    ajax.set("applicationId", $("#applicationId").val());
                    ajax.start();
                } else {
                    Hussar.info("请修改数据后进行提交操作！")
                }
            } else {
                Hussar.info("请修改数据后进行提交操作！")
            }
        })
    };

    /**
     * 验证表单
     */
    RoleAddManage.validator = function () {
        //自定义校验
        form.verify({
            required: function (value, item) {
                if (value.trim() == "") {
                    $("#roleMsg").click();
                    return '必填项不能为空！';
                }
            },
            roleName: function (value, item) {
                if (!new RegExp("^[a-zA-Z0-9_\u4e00-\u9fa5\\s·]+$").test(value)) {
                    return '输入项不能有特殊字符！';
                }
            },
            sameRoleName: function (value, item) {
                var oldRoleName = $("#oldRoleName").val().trim();
                var applicationId = $("#applicationId").val();
                if (oldRoleName != value) {
                    var msg = "";
                    var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/sameRoleName", function (data) {
                        if (data.length != 0) {
                            msg = '角色名称已存在！';
                        }
                    }, function (data) {
                        Hussar.error(SELECT_ROLE_NAME_ISHAVE_FAIL);
                    });
                    ajax.set("sameRoleName", value);
                    ajax.set("applicationId", applicationId);
                    ajax.start();
                    return msg;
                }
            }
        })
    };

    RoleAddManage.initFrameHeight = function () {
        var h3 = $(window).height() - 181;
        var h2 = $(window).height() - 160;
        $("#contentInfo").css("height", h3 + "px");
        $("#userInfo").css("height", h3 + "px");
        $("#userTrans").css("height", h2 + "px");
    };

    /**
     * 初始化
     */
    $(function () {
        RoleAddManage.initPage();
        $(window).resize(function () {
            RoleAddManage.initFrameHeight();
        });
    });
});