/**
 * @Description: 统一权限管理脚本文件
 * @Author: QiuYuanLong
 * @Date: 2019/12/20.
 */
var CasManage = {
    layIndex: null,
    currentNode: null
};
layui.use(['jquery', 'table', 'layer', 'Hussar', 'jstree', 'HussarAjax', 'form', 'element'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var jstree = layui.jstree;
    var element = layui.element;
    var table = layui.table;


    CasManage.initTree = function () {
        var $tree = $("#casTree");//统一权限树
        $tree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/casApplication/lazyCasTree",
                    "data": function (node) {
                        return {"nodeId": node.id};
                    }
                }
            },
            contextmenu: {
                select_node: true,
                show_at_node: true,
                'items': CasManage.contextmenu
            },
            plugins: ['contextmenu', 'types', 'search'],
            types: {
                "GROUP": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/com.png"},
                "Cas": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/station.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            search: CasManage.search()
        });
        $tree.bind('activate_node.jstree', function (obj, e) {
            var currentNode = e.node || {};
            var dat = currentNode.original || {};
            if (currentNode.original.code == 'GROUP') {
                CasManage.renderTable(dat.id);
            } else {
                $("#tableDiv").css("display", "none");
                $("#iframeDiv").css("display", "block");
                $("#casIframe").attr("src", Hussar.ctxPath + "/casApplication/casViewPage?id=" + dat.id);
            }
        })
    };

    /**
     * 树查询
     */
    CasManage.search = function () {
        var to = false;
        $("#txtIndustryArea").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#txtIndustryArea").val();
                var temp = $("#casTree").is(":hidden");
                if (temp == true) {
                    $("#casTree").show();
                }
                $("#casTree").jstree(true).search(v);
                //添加索引
                if (v != '') {
                    var n = $(".jstree-search").length, con_html;
                    if (n > 0) {
                        con_html = "<em>" + n + "</em>个匹配项";
                    } else {
                        con_html = "无匹配项";
                    }
                    $(".search-results").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#casTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                } else {
                    $(".search-results").html("");
                }
            }, 250);
        });
    };

    /**
     * 右键菜单
     */
    CasManage.contextmenu = function (node) {
        //不同节点菜单不一样
        var items = {
            'item1': {
                'label': '新增业务系统分组',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5011.png",
                'action': function () {
                    $("#tableDiv").css("display", "none");
                    $("#iframeDiv").css("display", "block");
                    $("#casIframe").attr("src", Hussar.ctxPath + "/casApplication/casGroupPage?type=add");
                }
            },
            'item2': {
                'label': '新增业务系统',
                'action': function () { /* 写点击处理函数 */
                    $("#tableDiv").css("display", "none");
                    $("#iframeDiv").css("display", "block");
                    $("#casIframe").attr("src", Hussar.ctxPath + "/casApplication/casAddPage?id=" + node.id);
                },
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5011.png"
            },
            'item3': {
                'label': '修改',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                'action': function () {
                    $("#tableDiv").css("display", "none");
                    $("#iframeDiv").css("display", "block");
                    $("#casIframe").attr("src", Hussar.ctxPath + "/casApplication/casEditPage?id=" + node.id);
                }
            },
            'item4': {
                'label': '删除',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                'action': function () {
                    var operation = function () {
                        var ajax = new $ax(Hussar.ctxPath + "/casApplication/delCas",
                            function (data) {
                                if (data.code == "200") {
                                    Hussar.success(data.message);
                                    CasManage.refreshPage();
                                } else if (data.code == "409") {
                                    Hussar.error("删除失败！(" + data.message + ")");
                                } else {
                                    Hussar.error(data.message);
                                }
                            },
                            function (data) {
                                Hussar.error(DELETE_FAIL);
                            });
                        ajax.set("id", node.id);
                        ajax.start();
                    };
                    Hussar.confirm(DELETE_SURE, operation);
                }
            },
            'item5': {
                'label': '修改',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                'action': function () {
                    $("#tableDiv").css("display", "none");
                    $("#iframeDiv").css("display", "block");
                    $("#casIframe").attr("src", Hussar.ctxPath + "/casApplication/casGroupPage?type=edit&id=" + node.id);
                }
            },
            'item6': {
                'label': '删除',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                'action': function () {
                    var operation = function () {
                        var ajax = new $ax(Hussar.ctxPath + "/casApplication/searchCasGroup",
                            function (data) {
                                if (data.length != 0) {
                                    Hussar.info("请先删除业务系统！");
                                } else {
                                    var ajax = new $ax(Hussar.ctxPath + "/casApplication/delGroup",
                                        function (data) {
                                            if (data.code == "200") {
                                                Hussar.success(data.message);
                                                CasManage.refreshPage();
                                            } else {
                                                Hussar.error(data.message);
                                            }
                                        },
                                        function (data) {
                                            Hussar.error(DELETE_FAIL);
                                        });
                                    ajax.set("id", node.id);
                                    ajax.start();
                                }
                            },
                            function (data) {
                                Hussar.error("查询业务系统分组下是否存在业务系统失败！");
                            });
                        ajax.set("id", node.id);
                        ajax.start();
                    };
                    Hussar.confirm(DELETE_SURE, operation);

                }
            },
            'item7': {
                'label': '下级排序',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5111.png",
                'action': function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    if (clickedNode.children == undefined || clickedNode.children.length < 2) {
                        Hussar.error("下级节点数量小于2，无需排序!");
                        return
                    }
                    CasManage.groupOrder(node);
                }
            },
            'item8': {
                'label': '下级排序',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5111.png",
                'action': function (obj) {
                    //获取点击的节点信息
                    var inst = $.jstree.reference(obj.reference);
                    var clickedNode = inst.get_node(obj.reference);
                    if (clickedNode.children == undefined || clickedNode.children.length < 2) {
                        Hussar.error("下级节点数量小于2，无需排序!");
                        return
                    }
                    CasManage.casOrder(node);
                }
            }
        };
        if (node != undefined) {
            if (node.original.code == 'GROUP' && node.original.parent != '#') {
                //业务系统分组拥有的右键菜单
                var addCas = $("#shiroAddCas").val();
                var saveGroup = $("#shiroSaveGroup").val();
                var delGroup = $("#shiroDelGroup").val();
                var order = $("#shiroCasOrder").val();
                if (addCas != "add") {
                    delete items.item2;
                }
                if (saveGroup != "saveGroup") {
                    delete items.item5;
                }
                if (delGroup != "delGroup") {
                    delete items.item6;
                }
                if (order != "order") {
                    delete items.item8;
                }
                delete items.item1;
                delete items.item3;
                delete items.item4;
                delete items.item7;

            } else if (node.original.parent == '#') {
                //根节点右键菜单
                var saveGroup = $("#shiroSaveGroup").val();
                var groupOrder = $("#shiroCasGroupOrder").val();
                if (saveGroup != "saveGroup") {
                    delete items.item3;
                }
                if (groupOrder != "groupOrder") {
                    delete items.item4;
                }
                delete items.item2;
                delete items.item3;
                delete items.item4;
                delete items.item5;
                delete items.item6;
                delete items.item8;
            } else {
                //业务系统排序
                var edit = $("#shiroEditCas").val();
                var del = $("#shiroDelCas").val();
                if (edit != "edit") {
                    delete items.item1;
                }
                if (del != "del") {
                    delete items.item7;
                }
                delete items.item1;  //删除节点 items
                delete items.item2;
                delete items.item5;
                delete items.item6;
                delete items.item7;
                delete items.item8;
                delete items.item9;
            }
            return items;
        }
    };

    CasManage.initFrameHeight = function () {
        var h = $(window).height() - 60;
        var h2 = $(window).height() - 10;
        $("#casIframe").css("height", h2 + "px");
        $("#casInfo").css("height", h + "px");
    };

    /**
     *  刷新页面，供子页面调用
     */
    CasManage.refreshPage = function () {
        $("#casTree").jstree(true).refresh();
        $("#casIframe").attr("src", "");
        $("#tableDiv").css("display", "none");
    };

    /**
     * 初始化排序树
     */
    CasManage.initOrderTree = function () {
        var $orderTree = $("#orderTree"); //排序树
        $orderTree.jstree({
            core: {
                check_callback: function (operation, node, node_parent, node_position, more) {
                    if (operation == 'move_node') {
                        if (node.parent == node_parent.parent || node_parent.parent == null) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return true;
                    }
                },
                data: null
            },
            plugins: ['types', "dnd"],
            types: {
                "GROUP": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/roleGroup.png"},
                "CAS": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/role.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            sort: function (a, b) {
                return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
            }
        });

        //移动树事件
        var resultDom = $("#output");   //隐藏结果集dom
        $orderTree.bind('move_node.jstree', function (e, data) {
            //移动的组织ID
            var id = data.node.id;
            //移动之前的位置
            var oldPosition = data.old_position;
            //移动后的位置
            var position = data.position;
            //原地未动
            if (oldPosition == position) {
                return;
            }
            var oldResult = JSON.parse(resultDom.val());
            //向上移动
            if (position - oldPosition < 0) {
                for (var i = 0; i < oldResult.length; i++) {
                    if (i < position) {
                        oldResult[i].seq = i + 1;
                    } else {
                        if (oldResult[i].id == id) {
                            oldResult[i].seq = position + 1;
                        } else {
                            if (i <= oldPosition) {
                                oldResult[i].seq = i + 2;
                            } else {
                                oldResult[i].seq = i + 1;
                            }
                        }
                    }
                }
            } else {//向下移动
                for (var i = 0; i < oldResult.length; i++) {
                    if (i < oldPosition) {
                        oldResult[i].seq = i + 1;
                    } else {
                        if (oldResult[i].id == id) {
                            oldResult[i].seq = position + 1;
                        } else {
                            if (i <= position) {
                                oldResult[i].seq = i;
                            } else {
                                oldResult[i].seq = i + 1;
                            }
                        }
                    }
                }
            }
            oldResult.sort(CasManage.up);
            resultDom.val(window.JSON.stringify(oldResult));
        });

    };

    /**
     * 业务系统排序
     */
    CasManage.up = function (x, y) {
        return x.seq - y.seq;
    };

    /**
     * 分组排序
     * @param node
     */
    CasManage.groupOrder = function (node) {
        CasManage.layIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            area: ['350px', '500px'],
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            shade: 0.4,
            title: "分组排序",
            content: $('#casOrder'),
            btn2: function (index, layero) {
                //保存业务系统分组排序
                var operation = function () {
                    var info = $("#output").val();
                    var ajax = new $ax(Hussar.ctxPath + "/casApplication/saveGroupOrder", function (data) {
                        if (data.code == "200") {
                            Hussar.success(SAVE_SUCCESS);
                            layer.close(CasManage.layIndex);
                            $("#casTree").jstree(true).refresh();
                        } else if (data.code) {
                            Hussar.error(data.message);
                        } else {
                            Hussar.error(SAVE_FAIL);
                        }
                    }, function (data) {
                        Hussar.error("业务系统分组排序保存失败");
                    });
                    ajax.set("info", info);
                    ajax.start();
                };
                Hussar.confirm(SAVE_SORT_SURE, operation);
                return false;
            },
            success: function () {
                //添加按钮图标
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                //加载排序树数据
                var ajax = new $ax(Hussar.ctxPath + "/casApplication/groupOrderTree", function (result) {
                    //排序树数据
                    $("#orderTree").jstree(true).settings.core.data = result;
                    $("#orderTree").jstree(true).refresh();
                    //除根节点数据保存到隐藏域里
                    var newResult = [];
                    for (var i = 0; i < result.length; i++) {
                        if (result[i].parent != "#") {
                            newResult.push(result[i]);
                        }
                    }
                    $("#output").val(window.JSON.stringify(newResult));
                }, function (data) {
                    Hussar.error("加载业务系统分组树失败");
                });
                ajax.start();
            }
        });
    };

    /**
     * 业务系统排序
     * @param node
     */
    CasManage.casOrder = function (node) {
        CasManage.layIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            area: ['350px', '500px'],
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            shade: 0.4,
            title: "业务系统排序",
            content: $('#casOrder'),
            btn2: function (index, layero) {
                var operation = function () {
                    //保存业务系统排序
                    var info = $("#output").val();
                    var ajax = new $ax(Hussar.ctxPath + "/casApplication/saveCasOrder", function (data) {
                        if (data.code == "200") {
                            Hussar.success(SAVE_SUCCESS);
                            layer.close(CasManage.layIndex);
                            $("#casTree").jstree(true).refresh();
                        } else if (data.code) {
                            Hussar.error(data.message);
                        } else {
                            Hussar.error(SAVE_FAIL);
                        }
                    }, function (data) {
                        Hussar.error("业务系统排序保存失败");
                    });
                    ajax.set("info", info);
                    ajax.start();
                };
                Hussar.confirm(SAVE_SORT_SURE, operation);
                return false;
            },
            success: function () {
                //添加按钮图标
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                //加载排序树数据
                var ajax = new $ax(Hussar.ctxPath + "/casApplication/casOrderTree", function (result) {
                    //排序树数据
                    $("#orderTree").jstree(true).settings.core.data = result;
                    $("#orderTree").jstree(true).refresh();
                    //除根节点数据保存到隐藏域里
                    var newResult = [];
                    for (var i = 0; i < result.length; i++) {
                        if (result[i].parent != "#") {
                            newResult.push(result[i]);
                        }
                    }
                    $("#output").val(window.JSON.stringify(newResult));
                }, function (data) {
                    Hussar.error("加载业务系统树失败");
                });
                var parent = node.id;
                ajax.set("parent", parent);
                ajax.start();
            }
        });

    };

    /**
     * 刷新业务系统列表信息表格
     * @param
     */
    CasManage.renderTable = function (id) {
        $("#tableDiv").css("display", "block");
        $("#iframeDiv").css("display", "none");
        table.render({
            elem: '#CasTable'
            , url: Hussar.ctxPath + '/casApplication/list_single?id=' + id //数据接口
            , limit: 20
            , page: true //开启分页
            , request: {
                pageName: 'curr', //页码的参数名称，默认：page
                limitName: 'nums' //每页数据量的参数名，默认：limit
            }
            , cols: [[ //表头
                {title: '序号', type: 'numbers'},
                {title: '名称', field: 'applicationName', minWidth: 100, align: "center"},
                {title: '访问地址', field: 'applicationUrl', minWidth: 60, align: "center"},
                {title: '分组', field: 'groupName', minWidth: 100, align: "center"},
                {title: '接入TOKEN', field: 'applicationToken', minWidth: 120, align: "center"},
                {
                    title: '是否HussarV8系统', field: 'isHussar', align: "center", minWidth: 160, templet: function (res) {
                        if (res.isHussar == "1") {
                            return "是"
                        } else {
                            return "否"
                        }
                    }
                },
                {
                    title: '在线状态', field: 'applicationStatus', minWidth: 60, align: "center", templet: function (res) {
                        if (res.applicationStatus == "1") {
                            return "是"
                        } else {
                            return "否"
                        }
                    }
                },
                {title: '测试', toolbar: '#barDemo', minWidth: 80, align: "center"}
            ]]
            , even: true
            , height: $("body").height() - $(".layui-form").outerHeight(true) - 26
        });
    };

    //监听工具条
    table.on('tool(CasTable)', function (obj) {
        var data = obj.data;
        if (obj.event === 'test') {
            var ajax = new $ax(Hussar.ctxPath + "/casApplication/testOnline", function (data) {
                if (data) {
                    Hussar.info("在线");
                } else {
                    Hussar.info("不在线");
                }
                // 执行重载
                table.reload('CasTable', {
                    page: {
                        curr: 1
                        // 重新从第 1 页开始
                    }
                });
            }, function (data) {
                Hussar.error("失败");
            });
            ajax.set("applicationId", data.applicationId);
            ajax.start();
        }
    })

    /**
     * 初始化
     */
    $(function () {
        CasManage.initTree();
        CasManage.initOrderTree();
        CasManage.contextmenu();
        CasManage.initFrameHeight();
        $(window).resize(function () {
            CasManage.initFrameHeight();
        });
    });
});


