/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.cassync.frontcontroller;

import com.jxdinfo.hussar.bsp.menu.model.MenuInfo;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.cas.ShiroCasConfiguration;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/casSyncMessageFront"})
public class CasSyncMessageFrontController
extends BaseController {
    @Autowired
    private ICasSyncMessageService casSyncMessageService;
    @Autowired
    private ShiroCasConfiguration casConf;
    @Resource
    private ISysMenuManageService iSysMenuManageService;
    @Value(value="${server.port}")
    private String port;
    @Value(value="${spring.profiles.active}")
    private String profiles;
    private static final String SYNC_PREFIX_PATH = "views/cassync/index";

    @RequestMapping(value={"/list"})
    @BussinessLog(key="/casSyncMessageFront/list", type="04", value="\u67e5\u8be2\u5217\u8868")
    public ApiResponse<Map<String, Object>> list(@RequestBody Map<String, Object> map) {
        String limit;
        String applicationName = map.get("applicationName") == null ? "" : map.get("applicationName").toString();
        String page = map.get("current") == null ? "1" : map.get("current").toString();
        String string = limit = map.get("size") == null ? "10" : map.get("size").toString();
        if (!StringUtils.isEmpty((CharSequence)applicationName)) {
            applicationName = applicationName.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        String userId = ShiroKit.getUser().getId();
        Map<String, Object> result = this.casSyncMessageService.getCasSyncList(page, limit, userId, applicationName);
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/getPushCount"})
    @BussinessLog(key="/casSyncMessageFront/getPushCount", type="04", value="\u83b7\u53d6\u5f85\u63a8\u9001\u6761\u6570")
    public ApiResponse<List<Map<String, Object>>> getPushCount() {
        String userId = ShiroKit.getUser().getId();
        List<Map<String, Object>> count = this.casSyncMessageService.getPushCount(userId);
        return ApiResponse.data(count);
    }

    @RequestMapping(value={"/websocketData"})
    @BussinessLog(key="/casSyncMessageFront/websocketData", type="04", value="\u83b7\u53d6websocket\u8fde\u63a5\u6240\u9700\u4fe1\u606f")
    public ApiResponse<Map<String, Object>> websocketData() {
        String userId = "";
        String syncRoute = "";
        String address = HttpKit.getLocalHost();
        String socketPort = address + ":" + this.port;
        String openType = this.casConf.getActiveType();
        ShiroUser shiroUser = ShiroKit.getUser();
        if (shiroUser != null) {
            userId = ShiroKit.getUser().getId();
            if ("CASServer".equals(openType) && shiroUser.getRolesList() != null && shiroUser.getRolesList().size() > 0) {
                List menus = this.iSysMenuManageService.getMenuByRoles(shiroUser.getId(), shiroUser.getRolesList(), this.profiles, null);
                syncRoute = this.getSyncRoute(menus);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("userId", userId);
        result.put("openType", openType);
        result.put("port", socketPort);
        result.put("syncRoute", syncRoute);
        return ApiResponse.data(result);
    }

    private String getSyncRoute(List<MenuInfo> menus) {
        String syncRoute = "";
        for (MenuInfo menuInfo : menus) {
            String component = menuInfo.getComponent();
            if (ToolUtil.isNotEmpty((Object)component) && component.contains(SYNC_PREFIX_PATH)) {
                syncRoute = menuInfo.getPath();
                break;
            }
            List children = menuInfo.getChildMenus();
            if (children.size() <= 0 || !ToolUtil.isNotEmpty((Object)(syncRoute = this.getSyncRoute(children)))) continue;
            break;
        }
        return syncRoute;
    }
}

