/**
 * @Description: 业务系统 角色管理脚本文件
 * @Author: QiuYuanLong
 * @Date: 2019/12/30.
 */

/**
 * 用户管理初始化
 */
layui.use(['jquery', 'layer', 'Hussar', 'HussarAjax', 'form', 'element'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var RoleAddGroup = {};
    var element = layui.element;

    /*初始化页面*/
    RoleAddGroup.initPage = function () {
        this.initButtonEvent();
        this.validator();
        RoleAddGroup.initFrameHeight();
    }

    /**
     * 初始化按钮事件
     */
    RoleAddGroup.initButtonEvent = function () {
        /**
         * 保存角色分组
         */
        $("#saveGroup").click(function () {
            form.on('submit(saveGroup)', function (data) {
                var saveType = $('#saveType').val();//操作类型
                var url;
                if (saveType == "add") {
                    url = "/casAppRoles/saveGroup";
                } else {
                    url = "/casAppRoles/editGroup";
                }
                var ajax = new $ax(Hussar.ctxPath + url, function (data) {
                    if (data.code == "" || data.code == null) {
                        window.parent.CasRoleManage.refreshRole();
                        // 查看新增加的节点分组信息
                        window.parent.layui.Hussar.success("保存成功");
                        window.location.href = Hussar.ctxPath + "/casAppRoles/roleGroupViewPage?id=" + data + "&applicationId="+ $('#applicationId').val();
                    } else {
                        Hussar.error(data.message);
                    }
                }, function (data) {
                    Hussar.error(SAVE_FAIL);
                });
                ajax.set("applicationId", $('#applicationId').val());
                ajax.set("groupName", $('#groupName').val());
                ajax.set("groupAlias", $('#groupAlias').val());
                ajax.set("checkId", $("#nodeId").val());
                ajax.start();
            });
        });
    }

    /**
     * 验证表单
     */
    RoleAddGroup.validator = function () {
        //自定义校验
        form.verify({
            required: function (value, item) {
                if (value.trim() == "") {
                    return '必填项不能为空！';
                }
            },
            roleName: function (value, item) {
                if (!new RegExp("^[a-zA-Z0-9_\u4e00-\u9fa5\\s·]+$").test(value)) {
                    return '输入项不能有特殊字符！';
                }
            },
            sameGroupName: function (value, item) {
                var oldGroupName = $("#oldGroupName").val().trim();
                if (oldGroupName != value) {
                    var msg = "";
                    var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/sameGroupName", function (data) {
                        if (data.length != 0) {
                            msg = '分组名称已存在！';
                        }
                    }, function (data) {
                        Hussar.error(SELECT_GROUP_NAME_ISHAVE_FAIL);
                    });
                    ajax.set("sameGroupName", value);
                    ajax.set("applicationId", $("#applicationId").val());
                    ajax.start();
                    return msg;
                }
            }
        })
    };

    RoleAddGroup.initFrameHeight = function () {
        var h = $(window).height() - 60;
        var h2 = $(window).height() - 10;
        $("#roleIframe").css("height", h2 + "px");
        $("#roleInfo").css("height", h + "px");
    };

    /**
     * 初始化
     */
    $(function () {
        RoleAddGroup.initPage();
        $(window).resize(function () {
            RoleAddGroup.initFrameHeight();
        });
    });
});