/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.cas.system.dao.CasAppUserRoleMapper;
import com.jxdinfo.hussar.cas.system.model.CasAppUserRole;
import com.jxdinfo.hussar.cas.system.service.ICasAppUserRoleService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.MessageTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CasAppUserRoleServiceImpl
extends ServiceImpl<CasAppUserRoleMapper, CasAppUserRole>
implements ICasAppUserRoleService {
    @Resource
    private CasAppUserRoleMapper casAppUserRoleMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @Override
    public void saveRoleUserAdd(List<String> userIds, String roleId, String applicationId) {
        String currentUser = ShiroKit.getUser().getId();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        ArrayList<CasAppUserRole> userRoleList = new ArrayList<CasAppUserRole>();
        for (String userId : userIds) {
            CasAppUserRole casAppUserRole = new CasAppUserRole();
            casAppUserRole.setUserId(userId);
            casAppUserRole.setGrantedRole(roleId);
            casAppUserRole.setApplicationId(applicationId);
            casAppUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            casAppUserRole.setCreateTime(currentDate);
            casAppUserRole.setLastTime(currentDate);
            casAppUserRole.setCreator(currentUser);
            casAppUserRole.setLastEditor(currentUser);
            userRoleList.add(casAppUserRole);
        }
        if (ToolUtil.isNotEmpty(userRoleList)) {
            this.saveBatch(userRoleList, userRoleList.size());
            this.abstractPushMsgMatcher.insertOperation("userRole", "add", userRoleList, ((CasAppUserRole)((Object)userRoleList.get(0))).getApplicationId());
        }
    }

    @Override
    public void saveRoleUserEdit(List<String> userIds, String roleId, String applicationId) {
        boolean exist;
        List casRoleList = this.casAppUserRoleMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GRANTED_ROLE", (Object)roleId)).eq((Object)"ADMIN_OPTION", (Object)Whether.YES.getValue())).eq((Object)"APPLICATION_ID", (Object)applicationId));
        ArrayList<String> addList = new ArrayList<String>();
        ArrayList<String> delList = new ArrayList<String>();
        for (CasAppUserRole casAppUserRole : casRoleList) {
            exist = false;
            for (String userId : userIds) {
                if (ToolUtil.isEmpty((Object)userId) || !userId.equals(casAppUserRole.getUserId())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            delList.add(casAppUserRole.getUserId());
        }
        for (String userId : userIds) {
            if (ToolUtil.isEmpty((Object)userId)) continue;
            exist = false;
            for (CasAppUserRole casAppUserRole : casRoleList) {
                if (!casAppUserRole.getUserId().equals(userId)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            addList.add(userId);
        }
        String currentUser = ShiroKit.getUser().getId();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        if (ToolUtil.isNotEmpty(delList)) {
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"GRANTED_ROLE", (Object)roleId)).in((Object)"USER_ID", delList)).eq((Object)"APPLICATION_ID", (Object)applicationId);
            this.casAppUserRoleMapper.delete((Wrapper)wrapper);
            JSONObject object = new JSONObject();
            object.put("GRANTED_ROLE", (Object)roleId);
            object.put("USER_ID", delList);
            this.abstractPushMsgMatcher.insertOperation("userRole", "delete", (Object)object, applicationId);
        }
        ArrayList<CasAppUserRole> userRoleList2 = new ArrayList<CasAppUserRole>();
        for (String userId : addList) {
            CasAppUserRole casAppUserRole = new CasAppUserRole();
            casAppUserRole.setUserId(userId);
            casAppUserRole.setGrantedRole(roleId);
            casAppUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            casAppUserRole.setCreateTime(currentDate);
            casAppUserRole.setLastTime(currentDate);
            casAppUserRole.setCreator(currentUser);
            casAppUserRole.setLastEditor(currentUser);
            casAppUserRole.setApplicationId(applicationId);
            userRoleList2.add(casAppUserRole);
        }
        if (ToolUtil.isNotEmpty(userRoleList2)) {
            this.saveBatch(userRoleList2, userRoleList2.size());
            this.abstractPushMsgMatcher.insertOperation("userRole", "add", userRoleList2, applicationId);
        }
    }

    @Override
    public List<JSTreeModel> getLazyUserTreeByRole(String roleId, String applicationId) {
        return this.casAppUserRoleMapper.getLazyUserTreeByRole(roleId, applicationId);
    }

    @Override
    public List<JSTreeModel> getCasUserTreeByRole(String roleId, String applicationId) {
        return this.casAppUserRoleMapper.getCasUserTreeByRole(roleId, applicationId);
    }

    @Override
    public int isDelete(String id, String applicationId) {
        return this.casAppUserRoleMapper.isDelete(id, applicationId);
    }

    @Override
    public Tip addOrDelUserRole(List<RoleOrgUserVo> adds, List<RoleOrgUserVo> dels, String roleId, String applicationId) {
        if (ToolUtil.isEmpty((Object)roleId)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "");
        }
        ArrayList hasAdd = adds.size() > 0 ? this.handleAdd(adds, roleId, applicationId) : new ArrayList();
        ArrayList<CasAppUserRole> sysUserRoles = new ArrayList<CasAppUserRole>();
        for (Object id : hasAdd) {
            CasAppUserRole casAppUserRole = new CasAppUserRole();
            casAppUserRole.setUserId((String)id);
            casAppUserRole.setApplicationId(applicationId);
            casAppUserRole.setGrantedRole(roleId);
            casAppUserRole.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            casAppUserRole.setCreator(ShiroKit.getUser().getId());
            casAppUserRole.setAdminOption("1");
            sysUserRoles.add(casAppUserRole);
        }
        ArrayList<String> hasDel = new ArrayList<String>();
        for (RoleOrgUserVo roleOrgUserVo : dels) {
            hasDel.add(roleOrgUserVo.getId());
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.in((Object)"USER_ID", hasDel)).eq((Object)"GRANTED_ROLE", (Object)roleId)).eq((Object)"APPLICATION_ID", (Object)applicationId);
        boolean addFlag = true;
        boolean delFlag = true;
        if (sysUserRoles.size() > 0) {
            addFlag = this.saveBatch(sysUserRoles);
            this.abstractPushMsgMatcher.insertOperation("userRole", "add", sysUserRoles, applicationId);
        }
        if (hasDel.size() > 0) {
            delFlag = this.remove((Wrapper)wrapper);
            JSONObject object = new JSONObject();
            object.put("GRANTED_ROLE", (Object)roleId);
            object.put("USER_ID", hasDel);
            this.abstractPushMsgMatcher.insertOperation("userRole", "delete", (Object)object, applicationId);
        }
        if (addFlag && delFlag) {
            return new MessageTip("");
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "");
    }

    private List<String> handleAdd(List<RoleOrgUserVo> list, String roleId, String applicationId) {
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> idsTemp = new ArrayList<String>();
        for (RoleOrgUserVo roleOrgUserVo : list) {
            ids.add(roleOrgUserVo.getId());
            idsTemp.add(roleOrgUserVo.getId());
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.in((Object)"USER_ID", ids)).eq((Object)"GRANTED_ROLE", (Object)roleId);
        List se = this.list((Wrapper)wrapper);
        for (CasAppUserRole casAppUserRole : se) {
            for (int i = 0; i < idsTemp.size(); ++i) {
                if (!((String)idsTemp.get(i)).equals(casAppUserRole.getUserId())) continue;
                ids.remove(idsTemp.get(i));
            }
        }
        return ids;
    }

    @Override
    public List<Object> getRoleOrgUser(Page<Object> page, String roleId, String orgId, String name, String account, String applicationId) {
        return this.casAppUserRoleMapper.getRoleOrgUser(page, roleId, orgId, name, account, applicationId);
    }
}

