/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.cas.system.dao.CasAppRoleGroupMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppRoleResourceMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppRolesMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppUserRoleMapper;
import com.jxdinfo.hussar.cas.system.model.CasAppRoleGroup;
import com.jxdinfo.hussar.cas.system.model.CasAppRoles;
import com.jxdinfo.hussar.cas.system.service.ICasAppRoleGroupService;
import com.jxdinfo.hussar.cas.system.service.ICasAppRolesService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CasAppRolesServiceImpl
extends ServiceImpl<CasAppRolesMapper, CasAppRoles>
implements ICasAppRolesService {
    @Resource
    private CasAppRolesMapper casAppRolesMapper;
    @Resource
    private CasAppRoleGroupMapper casAppRoleGroupMapper;
    @Resource
    private CasAppRoleResourceMapper casAppRoleResourceMapper;
    @Resource
    private ICasAppRoleGroupService casAppRoleGroupService;
    @Resource
    private CasAppUserRoleMapper casAppUserRoleMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @Override
    public List<JSTreeModel> getLazyRolesByCas(String nodeId, String applicationId) {
        ArrayList<JSTreeModel> jsTreeModels = new ArrayList();
        if (nodeId.equals("#")) {
            jsTreeModels = this.casAppRoleGroupMapper.getFirstCasRolesTree(applicationId == null ? "" : applicationId);
            JSTreeModel jsTreeModel = new JSTreeModel();
            jsTreeModel.setParent("#");
            jsTreeModel.setCode("GROUP");
            jsTreeModel.setText("\u89d2\u8272\u5217\u8868");
            jsTreeModel.setId("1");
            jsTreeModel.setType("isRoot");
            jsTreeModels.add(jsTreeModel);
        } else {
            jsTreeModels = this.casAppRoleGroupMapper.getLazyCasRolesTree(nodeId, applicationId);
        }
        return jsTreeModels;
    }

    @Override
    public Object saveGroup(String applicationId, String groupName, String checkId, String groupAlias) {
        CasAppRoleGroup casAppRoleGroup = new CasAppRoleGroup();
        casAppRoleGroup.setApplicationId(applicationId);
        casAppRoleGroup.setGroupId(null);
        casAppRoleGroup.setGroupName(groupName);
        casAppRoleGroup.setParentId(checkId);
        casAppRoleGroup.setGroupAlias(groupAlias);
        casAppRoleGroup.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        casAppRoleGroup.setCreator(ShiroKit.getUser().getId());
        Integer count = this.casAppRoleGroupMapper.insert((Object)casAppRoleGroup);
        if (count == 1) {
            this.abstractPushMsgMatcher.insertOperation("roleGroup", "add", (Object)casAppRoleGroup, applicationId);
            return casAppRoleGroup.getGroupId();
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65b0\u589e\u5931\u8d25\uff01");
    }

    @Override
    public Object editGroup(String applicationId, String groupName, String checkId, String groupAlias) {
        CasAppRoleGroup casAppRoleGroup = new CasAppRoleGroup();
        casAppRoleGroup.setGroupId(checkId);
        casAppRoleGroup.setGroupName(groupName);
        casAppRoleGroup.setGroupAlias(groupAlias);
        casAppRoleGroup.setLastEditor(ShiroKit.getUser().getAccount());
        casAppRoleGroup.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        casAppRoleGroup.setApplicationId(applicationId);
        Integer count = this.casAppRoleGroupMapper.update((Object)casAppRoleGroup, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"GROUP_ID", (Object)checkId));
        if (count == 1) {
            this.abstractPushMsgMatcher.insertOperation("roleGroup", "update", (Object)casAppRoleGroup, applicationId);
            return checkId;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01");
    }

    @Override
    public String addRole(Map<String, String> map) {
        String roleName = map.get("roleName");
        String roleYw = map.get("roleYw");
        String checkNodeId = map.get("checkNodeId");
        String applicationId = map.get("applicationId");
        CasAppRoles casAppRoles = new CasAppRoles();
        casAppRoles.setRoleId(null);
        casAppRoles.setRoleName(roleName);
        casAppRoles.setRoleAlias(roleYw);
        casAppRoles.setApplicationId(applicationId);
        casAppRoles.setGroupId(checkNodeId);
        casAppRoles.setIsSys("0");
        casAppRoles.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        casAppRoles.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        casAppRoles.setCreator(ShiroKit.getUser().getId());
        casAppRoles.setCorporationId("1");
        Integer count = this.casAppRolesMapper.insert((Object)casAppRoles);
        if (count == 1) {
            this.abstractPushMsgMatcher.insertOperation("role", "add", (Object)casAppRoles, applicationId);
            return casAppRoles.getRoleId();
        }
        return null;
    }

    @Override
    public List<Object> getRoleView(String id, String applicationId) {
        ArrayList<Object> list = new ArrayList<Object>();
        List roleList = this.casAppRolesMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)id)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        List resourceList = this.casAppRoleResourceMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)id)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        List group = this.casAppRoleGroupMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)((CasAppRoles)((Object)roleList.get(0))).getGroupId())).eq((Object)"APPLICATION_ID", (Object)applicationId));
        list.add(roleList);
        list.add(resourceList);
        list.add(group);
        return list;
    }

    @Override
    public List<JSTreeModel> getGroupOrderTree(String applicationId) {
        List<JSTreeModel> result = this.casAppRoleGroupMapper.getGroupOrderTree(applicationId);
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent("#");
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u89d2\u8272\u5217\u8868");
        jsTreeModel.setId("1");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        return result;
    }

    @Override
    public List<JSTreeModel> getRoleOrderTree(String parent, String applicationId) {
        List<JSTreeModel> result = this.casAppRoleGroupMapper.getRoleOrderTree(parent, applicationId);
        JSTreeModel root = new JSTreeModel();
        CasAppRoleGroup selectGroup = new CasAppRoleGroup();
        selectGroup.setGroupId(parent);
        selectGroup.setApplicationId(applicationId);
        QueryWrapper wrapper = new QueryWrapper((Object)selectGroup);
        CasAppRoleGroup group = (CasAppRoleGroup)((Object)this.casAppRoleGroupMapper.selectOne((Wrapper)wrapper));
        if (ToolUtil.isNotEmpty((Object)((Object)group))) {
            root.setParent("#");
            root.setCode("GROUP");
            root.setText(group.getGroupName());
            root.setId(group.getGroupId());
            root.setType("GROUP");
        } else {
            root.setParent("#");
            root.setCode("GROUP");
            root.setText("\u89d2\u8272\u5217\u8868");
            root.setId("1");
            root.setType("isRoot");
        }
        result.add(root);
        return result;
    }

    @Override
    public void saveGroupOrder(JSONArray treeArr, String applicationId) {
        ArrayList<CasAppRoleGroup> list = new ArrayList<CasAppRoleGroup>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasAppRoleGroup group = new CasAppRoleGroup();
            group.setGroupId(id);
            group.setApplicationId(applicationId);
            if (ToolUtil.isNotEmpty((Object)order)) {
                group.setGroupOrder(Integer.parseInt(order));
            } else {
                group.setGroupOrder(1);
            }
            list.add(group);
            this.casAppRoleGroupService.update((Object)group, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"GROUP_ID", (Object)id));
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.abstractPushMsgMatcher.insertOperation("roleGroup", "update", list, applicationId);
        }
    }

    @Override
    public void saveRoleOrder(JSONArray treeArr, String applicationId) {
        ArrayList<CasAppRoles> list = new ArrayList<CasAppRoles>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasAppRoles role = new CasAppRoles();
            role.setRoleId(id);
            role.setApplicationId(applicationId);
            if (ToolUtil.isNotEmpty((Object)order)) {
                role.setRoleOrder(Integer.parseInt(order));
            } else {
                role.setRoleOrder(1);
            }
            list.add(role);
            super.update((Object)role, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"ROLE_ID", (Object)id));
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.abstractPushMsgMatcher.insertOperation("role", "update", list, applicationId);
        }
    }

    @Override
    public boolean editRole(Map<String, String> map, String applicationId) {
        String roleId = map.get("roleId");
        String roleName = map.get("roleName");
        String roleYw = map.get("roleYw");
        CasAppRoles casAppRoles = new CasAppRoles();
        casAppRoles.setRoleId(roleId);
        casAppRoles.setRoleName(roleName);
        casAppRoles.setRoleAlias(roleYw);
        casAppRoles.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        casAppRoles.setLastEditor(ShiroKit.getUser().getId());
        casAppRoles.setApplicationId(applicationId);
        Integer num = this.casAppRolesMapper.update((Object)casAppRoles, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"ROLE_ID", (Object)roleId)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        if (num == 0) {
            return false;
        }
        this.abstractPushMsgMatcher.insertOperation("role", "update", (Object)casAppRoles, applicationId);
        return true;
    }

    @Override
    public List<String> delCacheAuthInfo(String roleId, String applicationId) {
        return this.casAppUserRoleMapper.getUserIdByRoleId(roleId, applicationId);
    }

    @Override
    public boolean delRole(String id, String applicationId) {
        Integer num;
        Integer delNum = this.casAppRoleResourceMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)id)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        if (delNum != 0) {
            this.abstractPushMsgMatcher.insertOperation("roleResource", "delete", (Object)id, applicationId);
        }
        if ((num = Integer.valueOf(this.casAppRolesMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)id)).eq((Object)"APPLICATION_ID", (Object)applicationId)))) == 0) {
            return false;
        }
        this.abstractPushMsgMatcher.insertOperation("role", "delete", (Object)id, applicationId);
        return true;
    }

    @Override
    public List<JSTreeModel> getRoleTree(String applicationId) {
        return this.casAppRoleGroupMapper.getRoleTree(applicationId);
    }

    @Override
    public List<JSTreeModel> selfRoleTree(String[] roleIds, String applicationId) {
        return this.casAppRolesMapper.selfRoleTree(roleIds, applicationId);
    }
}

