/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.cas.system.dao.CasAppRoleResourceMapper;
import com.jxdinfo.hussar.cas.system.model.CasAppRoleResource;
import com.jxdinfo.hussar.cas.system.service.ICasAppRoleResourceService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CasAppRoleResourceServiceImpl
extends ServiceImpl<CasAppRoleResourceMapper, CasAppRoleResource>
implements ICasAppRoleResourceService {
    @Resource
    private CasAppRoleResourceMapper casAppRoleResourceMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveResource(String ids, String roId, String applicationId) {
        List deleteList = this.casAppRoleResourceMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)roId)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casAppRoleResourceMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)roId)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        if (deleteList.size() != 0) {
            this.abstractPushMsgMatcher.insertOperation("roleResource", "delete", (Object)deleteList, applicationId);
        }
        String[] id = ids.split(",");
        ArrayList<CasAppRoleResource> casAppRoleResourceList = new ArrayList<CasAppRoleResource>();
        for (String reId : id) {
            if (ToolUtil.isEmpty((Object)reId)) continue;
            CasAppRoleResource casAppRoleResource = new CasAppRoleResource();
            casAppRoleResource.setRoleId(roId);
            casAppRoleResource.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            casAppRoleResource.setCreator(ShiroKit.getUser().getId());
            casAppRoleResource.setLastEditor(ShiroKit.getUser().getId());
            casAppRoleResource.setApplicationId(applicationId);
            casAppRoleResource.setLastTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            casAppRoleResource.setResourceId(reId);
            casAppRoleResourceList.add(casAppRoleResource);
        }
        if (ToolUtil.isNotEmpty(casAppRoleResourceList)) {
            super.saveBatch(casAppRoleResourceList, casAppRoleResourceList.size());
            this.abstractPushMsgMatcher.insertOperation("roleResource", "add", casAppRoleResourceList, applicationId);
        }
    }

    @Override
    public void reclaimPerm(String id, String applicationId) {
        List<CasAppRoleResource> casAppRoleResourceList = this.casAppRoleResourceMapper.getRoleResourceByRoleId(id, applicationId);
        this.casAppRoleResourceMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)id)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.abstractPushMsgMatcher.insertOperation("roleResource", "delete", casAppRoleResourceList, applicationId);
    }

    @Override
    public List<CasAppRoleResource> queryPerm(String id, String applicationId) {
        List list = this.casAppRoleResourceMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)id)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        return list;
    }

    @Override
    @Transactional(rollbackFor={SQLException.class})
    public boolean resourceEditSaveRole(String resourceId, String[] roleIds, String applicationId) {
        boolean flag = false;
        List deleteList = this.casAppRoleResourceMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RESOURCE_ID", (Object)resourceId)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casAppRoleResourceMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RESOURCE_ID", (Object)resourceId)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        if (deleteList.size() != 0) {
            this.abstractPushMsgMatcher.insertOperation("roleResource", "delete", (Object)deleteList, applicationId);
        }
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        String currentUser = ShiroKit.getUser().getAccount();
        ArrayList<CasAppRoleResource> sysRoleResourceList = new ArrayList<CasAppRoleResource>();
        for (String roleId : roleIds) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            CasAppRoleResource casAppRoleResource = new CasAppRoleResource();
            casAppRoleResource.setRoleId(roleId);
            casAppRoleResource.setResourceId(resourceId);
            casAppRoleResource.setCreateTime(currentDate);
            casAppRoleResource.setCreator(currentUser);
            casAppRoleResource.setLastEditor(currentUser);
            casAppRoleResource.setLastTime(currentDate);
            casAppRoleResource.setApplicationId(applicationId);
            sysRoleResourceList.add(casAppRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            flag = this.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
            this.abstractPushMsgMatcher.insertOperation("roleResource", "add", sysRoleResourceList, applicationId);
        }
        return flag;
    }
}

