/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.cas.system.controller.CasUserUtil;
import com.jxdinfo.hussar.cas.system.dao.CasAppRoleGroupMapper;
import com.jxdinfo.hussar.cas.system.model.CasAppRoleGroup;
import com.jxdinfo.hussar.cas.system.model.CasAppRoles;
import com.jxdinfo.hussar.cas.system.service.ICasAppRoleResourceService;
import com.jxdinfo.hussar.cas.system.service.ICasAppRolesService;
import com.jxdinfo.hussar.cas.system.service.ICasAppUserRoleService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/casAppRoles"})
public class CasAppRolesController
extends BaseController {
    private String PREFIX = "/system/casApplication/roleManage/";
    @Resource
    private ICasAppRolesService casAppRolesService;
    @Resource
    private ICasAppUserRoleService casAppUserRoleService;
    @Resource
    private CasAppRoleGroupMapper casAppRoleGroupMapper;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ICasAppRoleResourceService casAppRoleResourceService;
    @Resource
    private CasUserUtil casUserUtil;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @RequestMapping(value={"/getLazyRolesByCas"})
    @RequiresPermissions(value={"casAppRoles:getLazyRolesByCas"})
    @BussinessLog(key="/casAppRoles/getLazyRolesByCas", type="04", value="\u53ea\u52a0\u8f7d\u5f53\u524d\u4e1a\u52a1\u7cfb\u7edf\u7684\u89d2\u8272\u6811")
    @ResponseBody
    public List<JSTreeModel> getLazyRolesByCas() {
        String nodeId = super.getPara("nodeId");
        String applicationId = super.getPara("applicationId");
        return this.casAppRolesService.getLazyRolesByCas(nodeId, applicationId);
    }

    @RequestMapping(value={"/roleAddGroupPage"})
    @RequiresPermissions(value={"casAppRoles:roleAddGroupPage"})
    @BussinessLog(key="/casAppRoles/roleAddGroupPage", type="04", value="\u65b0\u589e\u3001\u4fee\u6539\u89d2\u8272\u5206\u7ec4\u9875\u9762")
    public String roleAddGroupPage(HttpServletRequest request) {
        String applicationId = super.getPara("applicationId");
        String nodeId = super.getPara("id");
        String type = super.getPara("type");
        String groupName = "";
        String groupAlias = "";
        if (ToolUtil.equals((Object)"edit", (Object)type)) {
            CasAppRoleGroup selectGroup = new CasAppRoleGroup();
            selectGroup.setApplicationId(applicationId);
            selectGroup.setGroupId(nodeId);
            QueryWrapper entityWrapper = new QueryWrapper((Object)selectGroup);
            CasAppRoleGroup group = (CasAppRoleGroup)((Object)this.casAppRoleGroupMapper.selectOne((Wrapper)entityWrapper));
            groupName = group.getGroupName();
            groupAlias = group.getGroupAlias();
        }
        request.setAttribute("groupName", (Object)groupName);
        request.setAttribute("applicationId", (Object)applicationId);
        request.setAttribute("groupAlias", (Object)groupAlias);
        request.setAttribute("nodeId", (Object)nodeId);
        request.setAttribute("type", (Object)type);
        return this.PREFIX + "casRoleGroup.html";
    }

    @RequestMapping(value={"/editGroup"})
    @BussinessLog(key="/casAppRoles/editGroup", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:editGroup"})
    @ResponseBody
    public Object editGroup() {
        String groupName = super.getPara("groupName");
        String groupAlias = super.getPara("groupAlias");
        String checkId = super.getPara("checkId");
        String applicationId = super.getPara("applicationId");
        return this.casAppRolesService.editGroup(applicationId, groupName, checkId, groupAlias);
    }

    @RequestMapping(value={"/saveGroup"})
    @BussinessLog(key="/casAppRoles/saveGroup", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:saveGroup"})
    @ResponseBody
    public Object saveGroup() {
        String applicationId = super.getPara("applicationId");
        String groupName = super.getPara("groupName");
        String groupAlias = super.getPara("groupAlias");
        String checkId = super.getPara("checkId");
        return this.casAppRolesService.saveGroup(applicationId, groupName, checkId, groupAlias);
    }

    @RequestMapping(value={"/delGroup"})
    @BussinessLog(key="/casAppRoles/delGroup", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:delGroup"})
    @ResponseBody
    public Tip delGroup() {
        String id = super.getPara("id");
        String applicationId = super.getPara("applicationId");
        Integer count = this.casAppRoleGroupMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)id)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        if (count == 1) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            this.abstractPushMsgMatcher.insertOperation("roleGroup", "delete", (Object)id, applicationId);
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/roleAddPage"})
    @RequiresPermissions(value={"casAppRoles:roleAddPage"})
    @BussinessLog(key="/casAppRoles/roleAddGroupPage", type="04", value="\u89d2\u8272\u65b0\u589e\u9875\u9762")
    public String roleAddPage(HttpServletRequest request) {
        String nodeId = super.getPara("id");
        String applicationId = super.getPara("applicationId");
        CasAppRoleGroup selectGroup = new CasAppRoleGroup();
        selectGroup.setGroupId(nodeId);
        selectGroup.setApplicationId(applicationId);
        QueryWrapper entityWrapper = new QueryWrapper((Object)selectGroup);
        CasAppRoleGroup group = (CasAppRoleGroup)((Object)this.casAppRoleGroupMapper.selectOne((Wrapper)entityWrapper));
        if (group != null) {
            request.setAttribute("group", (Object)group.getGroupName());
        } else {
            request.setAttribute("group", (Object)"");
        }
        request.setAttribute("nodeId", (Object)nodeId);
        request.setAttribute("applicationId", (Object)applicationId);
        return this.PREFIX + "casRoleAdd.html";
    }

    @RequestMapping(value={"/addRole"})
    @BussinessLog(key="/casAppRoles/addRole", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:addRole"})
    @ResponseBody
    public Object addRole() {
        String roleName = super.getPara("roleName").trim();
        String roleYw = super.getPara("roleAlias") == null ? "" : super.getPara("roleAlias").trim();
        String checkNodeId = super.getPara("groupId").trim();
        String applicationId = super.getPara("applicationId");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("roleName", roleName);
        map.put("roleYw", roleYw);
        map.put("checkNodeId", checkNodeId);
        map.put("applicationId", applicationId);
        String roleId = this.casAppRolesService.addRole(map);
        if (StringUtils.isEmpty((CharSequence)roleId)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65b0\u589e\u5931\u8d25\uff01");
        }
        JSONObject result = new JSONObject();
        result.put("roleId", (Object)roleId);
        return result;
    }

    @RequestMapping(value={"/roleEditPage"})
    @RequiresPermissions(value={"casAppRoles:roleEditPage"})
    @BussinessLog(key="/casAppRoles/roleEditPage", type="04", value="\u89d2\u8272\u4fee\u6539\u9875\u9762")
    public String roleEditPage(HttpServletRequest request) {
        String nodeId = super.getPara("id");
        String applicationId = super.getPara("applicationId");
        QueryWrapper entityWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)nodeId)).eq((Object)"APPLICATION_ID", (Object)applicationId);
        List roleList = this.casAppRolesService.list((Wrapper)entityWrapper);
        Wrapper groupWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)((CasAppRoles)((Object)roleList.get(0))).getGroupId())).eq((Object)"APPLICATION_ID", (Object)applicationId);
        String group = "";
        List groupList = this.casAppRoleGroupMapper.selectList(groupWrapper);
        if (ToolUtil.isNotEmpty((Object)groupList)) {
            group = ((CasAppRoleGroup)((Object)groupList.get(0))).getGroupName();
        }
        request.setAttribute("group", (Object)group);
        request.setAttribute("nodeId", (Object)nodeId);
        request.setAttribute("roleList", (Object)roleList);
        request.setAttribute("applicationId", (Object)applicationId);
        return this.PREFIX + "casRoleEdit.html";
    }

    @RequestMapping(value={"/editRole"})
    @BussinessLog(key="/casAppRoles/editRole", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:editRole"})
    @ResponseBody
    public Tip editRole() {
        String roleId = super.getPara("roleId").trim();
        String roleName = super.getPara("roleName").trim();
        String applicationId = super.getPara("applicationId");
        String roleYw = super.getPara("roleAlias") == null ? "" : super.getPara("roleAlias").trim();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("roleId", roleId);
        map.put("roleName", roleName);
        map.put("roleYw", roleYw);
        boolean flag = this.casAppRolesService.editRole(map, applicationId);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/getRoleOrgUser"})
    @RequiresPermissions(value={"casAppRoles:getRoleOrgUser"})
    @BussinessLog(key="/casAppRoles/getRoleOrgUser", type="04", value="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u89d2\u8272\u7684\u4fe1\u606f")
    @ResponseBody
    public JSONObject getRoleOrgUser(String roleId, String orgId, String applicationId, @RequestParam(value="page", defaultValue="1") int pageNo, @RequestParam(value="limit", defaultValue="20") int limit) {
        String name = super.getPara("name");
        String account = super.getPara("account");
        Page page = new Page((long)pageNo, (long)limit);
        List<Object> list = ToolUtil.isEmpty((Object)roleId) ? new ArrayList() : this.casAppUserRoleService.getRoleOrgUser((Page<Object>)page, roleId, orgId, name, account, applicationId);
        JSONObject json = new JSONObject();
        json.put("data", list);
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return json;
    }

    @RequestMapping(value={"/addOrDelUserRole"})
    @RequiresPermissions(value={"casAppRoles:addOrDelUserRole"})
    @BussinessLog(key="/casAppRoles/addOrDelUserRole", type="01", value="\u6dfb\u52a0\u5220\u9664\u7528\u6237\u89d2\u8272")
    @ResponseBody
    public Tip addOrDelUserRole(String adds, String dels, String roleId, String applicationId) {
        List addList = JSONObject.parseArray((String)adds, RoleOrgUserVo.class);
        List delList = JSONObject.parseArray((String)dels, RoleOrgUserVo.class);
        return this.casAppUserRoleService.addOrDelUserRole(addList, delList, roleId, applicationId);
    }

    @RequestMapping(value={"/delRole"})
    @RequiresPermissions(value={"casAppRoles:delRole"})
    @BussinessLog(key="/casAppRoles/delRole", type="02", value="\u5220\u9664\u89d2\u8272")
    @ResponseBody
    public Tip delRole() {
        String applicationId;
        String id = super.getPara("id").trim();
        int num = this.casAppUserRoleService.isDelete(id, applicationId = super.getPara("applicationId"));
        if (num > 0) {
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u7528\u6237\uff01\uff09");
        }
        boolean flag = this.casAppRolesService.delRole(id, applicationId);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/sameRoleName"})
    @RequiresPermissions(value={"casAppRoles:sameRoleName"})
    @BussinessLog(key="/casAppRoles/sameRoleName", type="04", value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272")
    @ResponseBody
    public List<CasAppRoles> sameRoleName() {
        String name = super.getPara("sameRoleName");
        String applicationId = super.getPara("applicationId");
        return this.casAppRolesService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_NAME", (Object)name)).eq((Object)"APPLICATION_ID", (Object)applicationId));
    }

    @RequestMapping(value={"/sameGroupName"})
    @RequiresPermissions(value={"casAppRoles:sameGroupName"})
    @BussinessLog(key="/casAppRoles/sameGroupName", type="04", value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u5206\u7ec4")
    @ResponseBody
    public List<CasAppRoleGroup> sameGroupName() {
        String name = super.getPara("sameGroupName");
        String applicationId = super.getPara("applicationId");
        List list = this.casAppRoleGroupMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_NAME", (Object)name)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        return list;
    }

    @RequestMapping(value={"/searchRoleToGroup"})
    @RequiresPermissions(value={"casAppRoles:searchRoleToGroup"})
    @BussinessLog(key="/casAppRoles/searchRoleToGroup", type="04", value="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272")
    @ResponseBody
    public List<CasAppRoles> searchRoleToGroup() {
        String id = super.getPara("id");
        String applicationId = super.getPara("applicationId");
        return this.casAppRolesService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)id)).eq((Object)"APPLICATION_ID", (Object)applicationId));
    }

    @RequestMapping(value={"/roleView"})
    @BussinessLog(key="/casAppRoles/roleView", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:roleView"})
    @ResponseBody
    public List<Object> roleView() {
        String id = super.getPara("id");
        String applicationId = super.getPara("applicationId");
        List<Object> list = this.casAppRolesService.getRoleView(id, applicationId);
        return list;
    }

    @RequestMapping(value={"/reclaimPerm"})
    @RequiresPermissions(value={"casAppRoles:reclaimPerm"})
    @BussinessLog(key="/casAppRoles/reclaimPerm", type="03", value="\u89d2\u8272\u56de\u6536\u6743\u9650")
    @ResponseBody
    public Tip reclaimPerm() {
        String id = super.getPara("id").trim();
        String applicationId = super.getPara("applicationId");
        this.casAppRoleResourceService.reclaimPerm(id, applicationId);
        return BaseController.SUCCESS_TIP;
    }

    @RequestMapping(value={"/roleViewPage"})
    @RequiresPermissions(value={"casAppRoles:roleViewPage"})
    @BussinessLog(key="/casAppRoles/roleViewPage", type="04", value="\u89d2\u8272\u67e5\u770b\u9875\u9762")
    public String roleViewPage(HttpServletRequest request) {
        String nodeId = super.getPara("id");
        String applicationId = super.getPara("applicationId");
        QueryWrapper entityWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)nodeId)).eq((Object)"APPLICATION_ID", (Object)applicationId);
        List roleList = this.casAppRolesService.list((Wrapper)entityWrapper);
        Wrapper groupWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)((CasAppRoles)((Object)roleList.get(0))).getGroupId())).eq((Object)"APPLICATION_ID", (Object)applicationId);
        List roleGroupList = this.casAppRoleGroupMapper.selectList(groupWrapper);
        String groupName = "";
        if (ToolUtil.isNotEmpty((Object)roleGroupList)) {
            groupName = ((CasAppRoleGroup)((Object)this.casAppRoleGroupMapper.selectList(groupWrapper).get(0))).getGroupName();
        }
        request.setAttribute("applicationId", (Object)applicationId);
        request.setAttribute("groupName", (Object)groupName);
        request.setAttribute("list", (Object)roleList);
        request.setAttribute("nodeId", (Object)nodeId);
        return this.PREFIX + "casRoleView.html";
    }

    @RequestMapping(value={"/roleGroupViewPage"})
    @RequiresPermissions(value={"casAppRoles:roleGroupViewPage"})
    @BussinessLog(key="/casAppRoles/roleGroupViewPage", type="04", value="\u89d2\u8272\u5206\u7ec4\u67e5\u770b\u9875\u9762")
    public String roleGroupViewPage(HttpServletRequest request) {
        String nodeId = super.getPara("id");
        String applicationId = super.getPara("applicationId");
        CasAppRoleGroup selectInfo = new CasAppRoleGroup();
        selectInfo.setGroupId(nodeId);
        selectInfo.setApplicationId(applicationId);
        QueryWrapper entityWrapper = new QueryWrapper((Object)selectInfo);
        CasAppRoleGroup group = (CasAppRoleGroup)((Object)this.casAppRoleGroupMapper.selectOne((Wrapper)entityWrapper));
        request.setAttribute("group", (Object)group);
        return this.PREFIX + "casRoleGroupView.html";
    }

    @RequestMapping(value={"/groupOrderTree"})
    @RequiresPermissions(value={"casAppRoles:groupOrderTree"})
    @BussinessLog(key="/casAppRoles/groupOrderTree", type="04", value="\u52a0\u8f7d\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811")
    @ResponseBody
    public List<JSTreeModel> groupOrderTree() {
        String applicationId = super.getPara("applicationId");
        return this.casAppRolesService.getGroupOrderTree(applicationId);
    }

    @RequestMapping(value={"/saveGroupOrder"})
    @BussinessLog(key="/casAppRoles/saveGroupOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u5206\u7ec4\u6392\u5e8f")
    @RequiresPermissions(value={"casAppRoles:saveGroupOrder"})
    @ResponseBody
    public Tip saveGroupOrder() {
        String info = super.getPara("info");
        String applicationId = super.getPara("applicationId");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.casAppRolesService.saveGroupOrder(treeArr, applicationId);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/roleOrderTree"})
    @RequiresPermissions(value={"casAppRoles:roleOrderTree"})
    @BussinessLog(key="/casAppRoles/roleOrderTree", type="04", value="\u52a0\u8f7d\u89d2\u8272\u6392\u5e8f\u6811")
    @ResponseBody
    public List<JSTreeModel> roleOrderTree() {
        String parent = super.getPara("parent");
        String applicationId = super.getPara("applicationId");
        return this.casAppRolesService.getRoleOrderTree(parent, applicationId);
    }

    @RequestMapping(value={"/saveRoleOrder"})
    @BussinessLog(key="/casAppRoles/saveRoleOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u6392\u5e8f")
    @RequiresPermissions(value={"casAppRoles:saveRoleOrder"})
    @ResponseBody
    public Tip saveRoleOrder() {
        String info = super.getPara("info");
        String applicationId = super.getPara("applicationId");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.casAppRolesService.saveRoleOrder(treeArr, applicationId);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/lazyRoleUserTreeView"})
    @RequiresPermissions(value={"casAppRoles:lazyRoleUserTreeView"})
    @BussinessLog(key="/casAppRoles/lazyRoleUserTreeView", type="04", value="\u61d2\u52a0\u8f7d\u83b7\u53d6\u89d2\u8272\u7528\u6237\u6811")
    @ResponseBody
    public List<JSTreeModel> getLazyRoleUserTreeView() {
        String roleId = super.getPara("roleId");
        String nodeId = super.getPara("nodeId");
        String applicationId = super.getPara("applicationId");
        return this.casUserUtil.getLazyUserByRole(roleId, nodeId, applicationId);
    }

    @RequestMapping(value={"/roleUserTreeAdd"})
    @RequiresPermissions(value={"casAppRoles:roleUserTreeAdd"})
    @BussinessLog(key="/casAppRoles/roleUserTreeAdd", type="01", value="\u89d2\u8272\u5173\u8054\u7528\u6237\u65b0\u589e\u6811")
    @ResponseBody
    public List<JSTreeModel> getRoleUserTreeAdd() {
        List result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId("11");
        jsTreeModel.setCode("11");
        jsTreeModel.setText("\u5173\u8054\u7528\u6237");
        jsTreeModel.setParent("#");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (!"USER".equals(model.getType()) || !"11".equals(model.getParent())) continue;
            model.setState(((Boolean)model.getState().get("selected")).booleanValue(), ((Boolean)model.getState().get("checked")).booleanValue(), true);
        }
        return result;
    }

    @RequestMapping(value={"/saveRoleUserAdd"})
    @BussinessLog(key="/casAppRoles/saveRoleUserAdd", type="01", value="\u4e1a\u52a1\u7cfb\u7edf-\u65b0\u589e\u89d2\u8272\u5173\u8054\u7528\u6237")
    @RequiresPermissions(value={"casAppRoles:saveRoleUserAdd"})
    @ResponseBody
    public Tip saveRoleUsersAdd() {
        String roleId = super.getPara("roleId");
        String userIds = super.getPara("userIds");
        String applicationId = super.getPara("applicationId");
        List<String> ids = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        this.casAppUserRoleService.saveRoleUserAdd(ids, roleId, applicationId);
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
        return tip;
    }

    @RequestMapping(value={"/saveRoleUserEdit"})
    @BussinessLog(key="/casAppRoles/saveRoleUserEdit", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u4fee\u6539\u89d2\u8272\u5173\u8054\u7528\u6237")
    @RequiresPermissions(value={"casAppRoles:saveRoleUserEdit"})
    @ResponseBody
    public Tip saveRoleUsersEdit() {
        String roleId = super.getPara("roleId");
        String userIds = super.getPara("userIds");
        String applicationId = super.getPara("applicationId");
        List<String> ids = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        this.casAppUserRoleService.saveRoleUserEdit(ids, roleId, applicationId);
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
        return tip;
    }

    @RequestMapping(value={"/queryPerm"})
    @RequiresPermissions(value={"casAppRoles:queryPerm"})
    @BussinessLog(key="/casAppRoles/queryPerm", type="04", value="\u89d2\u8272\u662f\u5426\u6709\u6743\u9650")
    @ResponseBody
    public List queryPerm() {
        String id = super.getPara("id").trim();
        String applicationId = super.getPara("applicationId");
        return this.casAppRoleResourceService.queryPerm(id, applicationId);
    }

    @RequestMapping(value={"/saveResource"})
    @BussinessLog(key="/casAppRoles/saveResource", type="01", value="\u4e1a\u52a1\u7cfb\u7edf-\u65b0\u589e\u89d2\u8272\u5173\u8054\u8d44\u6e90")
    @RequiresPermissions(value={"casAppRoles:saveResource"})
    @ResponseBody
    public Tip saveResource() {
        String ids = super.getPara("ids");
        String roId = super.getPara("roId");
        String applicationId = super.getPara("applicationId");
        this.casAppRoleResourceService.saveResource(ids, roId, applicationId);
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u89d2\u8272\u5173\u8054\u8d44\u6e90\u4fdd\u5b58\u6210\u529f\uff01");
        return tip;
    }

    @RequestMapping(value={"/roleTree"})
    @RequiresPermissions(value={"casAppRoles:roleTree"})
    @BussinessLog(key="/casAppRoles/roleTree", type="04", value="\u52a0\u8f7d\u89d2\u8272\u6811\u7ed3\u679c")
    @ResponseBody
    public List<JSTreeModel> roleTree(String applicationId) {
        List<JSTreeModel> result = this.casAppRolesService.getRoleTree(applicationId);
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent("#");
        jsTreeModel.setCode("group");
        jsTreeModel.setText("\u89d2\u8272\u5217\u8868");
        jsTreeModel.setId("1");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        return result;
    }
}

