/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.messagepush.config;

import com.jxdinfo.hussar.bpm.messagepush.BpmListenerAck;
import com.jxdinfo.hussar.bpm.messagepush.config.BpmDirectRabbitConfig;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="bpm", name={"send-message"}, havingValue="true", matchIfMissing=false)
public class BpmPushListenerConfig {
    @Autowired
    private CachingConnectionFactory connectionFactory;
    @Autowired
    private BpmListenerAck bpmListenerAck;
    @Autowired
    BpmDirectRabbitConfig directRabbitConfig;

    @Bean
    public SimpleMessageListenerContainer simpleMessageListenerContainer() {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer((ConnectionFactory)this.connectionFactory);
        container.setConcurrentConsumers(1);
        container.setMaxConcurrentConsumers(1);
        container.setQueues(new Queue[]{this.directRabbitConfig.directQueueAck()});
        container.setMessageListener((MessageListener)this.bpmListenerAck);
        return container;
    }
}

