/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.messagepush;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.sync.model.BpmSyncMessageFail;
import com.jxdinfo.hussar.bpm.sync.service.IBpmSyncMessageFailService;
import com.rabbitmq.client.Channel;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="bpm", name={"send-message"}, havingValue="true", matchIfMissing=false)
public class BpmListenerAck
implements ChannelAwareMessageListener {
    @Autowired
    private IBpmSyncMessageFailService bpmSyncMessageFailService;

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="${bpm.queue}Bpm"), key={"${bpm.route-key}Bpm"}, exchange=@Exchange(value="${bpm.exchange}Bpm"))})
    public void onMessage(Message message, Channel channel) throws Exception {
        String msg = message.toString();
        String[] msgArray = msg.split("'");
        JSONObject object = JSONObject.parseObject((String)msgArray[1].trim());
        BpmSyncMessageFail bpmSyncMessageFail = new BpmSyncMessageFail();
        bpmSyncMessageFail.setCreateTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        bpmSyncMessageFail.setMessageContent(object.getString("data").getBytes());
        bpmSyncMessageFail.setFailReason(object.getString("failReason") == null ? null : object.getString("failReason").getBytes());
        bpmSyncMessageFail.setMessageStatus("0");
        bpmSyncMessageFail.setMessageOrder(this.bpmSyncMessageFailService.getMaxOrder());
        this.bpmSyncMessageFailService.save((Object)bpmSyncMessageFail);
    }
}

