/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.online.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.cas.ShiroCasConfiguration;
import com.jxdinfo.hussar.encrypt.util.SM3Util;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnProperty(prefix="cas", name={"active-type"}, havingValue="CASClient", matchIfMissing=false)
@RestController
public class OnlineCheckController {
    @Autowired
    private ShiroCasConfiguration shiroCasConfiguration;

    @RequestMapping(value={"/casonline/check"}, method={RequestMethod.POST}, produces={"application/json; charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @BussinessLog(key="/casonline/check", type="04", value="\u5ba2\u6237\u7aef\u68c0\u67e5")
    public ResponseEntity<JSONObject> obtainId(@RequestHeader(name="token", required=true) String token, @RequestBody JSONObject json) {
        String clientToken = this.shiroCasConfiguration.getClientToken();
        String nonce = json.getString("nonce");
        String timestamp = json.getString("timestamp");
        String signature = json.getString("signature");
        JSONObject result = new JSONObject();
        result.put("code", (Object)HttpStatus.BAD_REQUEST.value());
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{nonce, timestamp, signature})) {
            result.put("message", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        boolean signCheck = signature.equals(SM3Util.digest((String)timestamp));
        boolean tokenCheck = clientToken.equals(token);
        if (!tokenCheck) {
            result.put("message", (Object)"token error");
        } else if (!signCheck) {
            result.put("message", (Object)"sign error");
        } else {
            result.put("code", (Object)HttpStatus.OK.value());
            result.put("message", (Object)nonce);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }
}

