/**
 * @Description: 业务系统分组管理脚本文件
 * @Author: QiuYuanLong
 * @Date: 2019/12/20.
 */
layui.use(['form', 'Hussar', 'HussarAjax'], function () {
    var Hussar = layui.Hussar
        , $ = layui.jquery
        , form = layui.form
        , $ax = layui.HussarAjax;

    var CasGroupPage = {};

    /**
     * 按钮操作
     */
    CasGroupPage.initButton = function () {

        /**
         * 提交保存
         */
        $("#form").submit(function () {
            var type = $("#type").val();
            //提交信息
            var ajax = new $ax(Hussar.ctxPath + "/casApplication/saveGroup",
                function (data) {
                    // 判断操作是否成功
                    if (data.code == 500) {
                        Hussar.error(data.message);
                    } else {
                        window.parent.layui.Hussar.success(SAVE_SUCCESS);
                        //刷新父页面
                        window.parent.CasManage.refreshPage();

                        window.parent.CasManage.renderTable(data)
                    }
                }, function (data) {
                    Hussar.error(SAVE_FAIL);
                });

            ajax.set("groupName", $("#groupName").val());
            ajax.set("groupId", $("#groupId").val());
            ajax.set("type", type);

            ajax.start();
            return false;
        });
    }

    $(function () {
        CasGroupPage.initButton();   // 初始化按钮操作
    });
});