/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.websocket.server;

import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageService;
import com.jxdinfo.hussar.cas.websocket.ServerEncoder;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/websocket", encoders={ServerEncoder.class})
@Component
public class WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);
    private static CopyOnWriteArraySet<WebSocketServer> webSocketSet = new CopyOnWriteArraySet();
    private Session session;
    @Autowired
    private ICasSyncMessageService casSyncMessageService = (ICasSyncMessageService)SpringContextHolder.getBean(ICasSyncMessageService.class);
    private String sid = "";

    public String getSid() {
        return this.sid;
    }

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        String userId = session.getQueryString().replaceFirst("cid=", "");
        webSocketSet.add(this);
        this.sid = userId;
    }

    @OnClose
    public void onClose() {
        webSocketSet.remove(this);
    }

    @OnMessage
    public void onMessage(String userId) {
        List<Map<String, Object>> count = this.casSyncMessageService.getPushCount(userId);
        for (WebSocketServer item : webSocketSet) {
            try {
                if (!item.getSid().equals(userId)) continue;
                item.sendMessage(count);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @OnError
    public void onError(Throwable error) {
        log.warn("onError......" + error.getMessage());
    }

    public void sendMessage(List<Map<String, Object>> message) throws IOException {
        try {
            this.session.getBasicRemote().sendObject(message);
        }
        catch (EncodeException e) {
            e.printStackTrace();
        }
    }
}

