/**
 * @Description: 业务系统查看脚本文件
 * @Author: QiuYuanLong
 * @Date: 2019/12/20.
 */
var CasRoleManage = {
    layIndex: null,
    currentNode: null
};
layui.use(['jquery', 'layer', 'Hussar', 'jstree', 'HussarAjax', 'form', 'element'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var jstree = layui.jstree;
    var element = layui.element;
    var form = layui.form;

    /*初始化页面*/
    CasRoleManage.initPage = function () {
        this.initRoleTree();
        this.initFrameHeight()
    }

    /**
     *  加载当前业务系统的关联角色树
     */
    CasRoleManage.initRoleTree = function () {
        var nodeId = $("#nodeId").val();
        var $userTree = $("#roleTree"); //角色树
        $userTree.jstree({
            core: {
                check_callback: true,
                data: {
                    "url": Hussar.ctxPath + "/casAppRoles/getLazyRolesByCas",
                    "data": function (node) {
                        return {"nodeId": node.id, "applicationId": $("#applicationId").val()};
                    }
                }
            },
            contextmenu: {
                select_node: true,
                show_at_node: true,
                'items': CasRoleManage.roleContextmenu
            },
            plugins: ['contextmenu', 'types', 'search'],
            types: {
                "GROUP": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/roleGroup.png"},
                "ROLE": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/role.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            search: CasRoleManage.searchRole()
        }).on('hover_node.jstree', function (event, data) { //鼠标移上事件
            this.title = data.node.text;
        })
        $userTree.bind('activate_node.jstree', function (obj, e) {
            var currentNode = e.node || {};
            var dat = currentNode.original || {};
            if (e.node.original.code == 'ROLE') {
                $("#roleIframe").attr("src", Hussar.ctxPath + "/casAppRoles/roleViewPage?id=" + e.node.id + "&applicationId=" + $("#applicationId").val());
            } else if (e.node.original.code == 'GROUP' && e.node.original.parent != '#') {
                $("#roleIframe").attr("src", Hussar.ctxPath + "/casAppRoles/roleGroupViewPage?id=" + e.node.id + "&applicationId=" + $("#applicationId").val())
            } else {
                $("#roleIframe").attr("src", "")
            }
        })
    };

    /**
     *  角色树右键菜单
     */
    CasRoleManage.roleContextmenu = function (node) {
        //不同节点菜单不一样
        var items = {
            'item1': {
                'label': '新增角色分组',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5011.png",
                'action': function () {
                    $("#roleIframe").attr("src", Hussar.ctxPath + "/casAppRoles/roleAddGroupPage?type=add&id=" + node.id + "&applicationId=" + $("#applicationId").val());
                }
            },
            'item2': {
                'label': '新增角色',
                'action': function () { /* 写点击处理函数 */
                    $("#roleIframe").attr("src", Hussar.ctxPath + "/casAppRoles/roleAddPage?id=" + node.id + "&applicationId=" + $("#applicationId").val());
                },
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5011.png"
            },
            'item3': {
                'label': '修改',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                'action': function () {
                    $("#roleIframe").attr("src", Hussar.ctxPath + "/casAppRoles/roleEditPage?id=" + node.id + "&applicationId=" + $("#applicationId").val());
                }
            },
            'item4': {
                'label': '回收权限',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5411.png",
                'action': function () {
                    var operation = function () {
                        var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/reclaimPerm",
                            function () {
                                Hussar.success(RECOVERY_PERMISSION_SUCCESS);
                                $("#roleIframe").attr("src", Hussar.ctxPath + "/casAppRoles/roleViewPage?id=" + node.id + "&applicationId=" + $("#applicationId").val())
                            },
                            function (data) {
                                Hussar.error(RECOVERY_PERMISSION_FAIL);
                            });
                        ajax.set("id", node.id);
                        ajax.set("applicationId", $("#applicationId").val());
                        ajax.start();
                    };
                    Hussar.confirm(RECOVERY_PERMISSION_SURE, operation);
                }
            },
            'item5': {
                'label': '删除',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                'action': function () {
                    var operation = function () {
                        var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/delRole",
                            function (data) {
                                if (data.code == "200") {
                                    Hussar.success(data.message);
                                    CasRoleManage.refreshRole();
                                } else if (data.code == "409") {
                                    Hussar.error("删除失败！(" + data.message + ")");
                                } else {
                                    Hussar.error(data.message);
                                }
                            },
                            function (data) {
                                Hussar.error(DELETE_FAIL);
                            });
                        ajax.set("id", node.id);
                        ajax.set("applicationId", $("#applicationId").val());
                        ajax.start();
                    };
                    Hussar.confirm(DELETE_SURE, operation);
                }
            },
            'item6': {
                'label': '修改',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/53.png",
                'action': function () {
                    $("#roleIframe").attr("src", Hussar.ctxPath + "/casAppRoles/roleAddGroupPage?type=edit&id=" + node.id + "&applicationId=" + $("#applicationId").val());
                }
            },
            'item7': {
                'label': '删除',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/57.png",
                'action': function () {
                    var operation = function () {
                        var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/searchRoleToGroup",
                            function (data) {
                                if (data.length != 0) {
                                    Hussar.info("请先删除角色！");
                                } else {
                                    var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/delGroup",
                                        function (data) {
                                            if (data.code == "200") {
                                                Hussar.success(data.message);
                                                CasRoleManage.refreshRole();
                                            } else {
                                                Hussar.error(data.message);
                                            }
                                        },
                                        function (data) {
                                            Hussar.error(DELETE_FAIL);
                                        });
                                    ajax.set("id", node.id);
                                    ajax.set("applicationId", $("#applicationId").val());
                                    ajax.start();
                                }
                            },
                            function (data) {
                                Hussar.error("查询角色分组下是否存在角色失败！");
                            });
                        ajax.set("id", node.id);
                        ajax.set("applicationId",$("#applicationId").val());
                        ajax.start();
                    };
                    Hussar.confirm(DELETE_SURE, operation);
                }
            },
            'item8': {
                'label': '分组排序',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5111.png",
                'action': function () {
                    CasRoleManage.groupOrder(node);

                }
            },
            'item9': {
                'label': '角色排序',
                'icon': Hussar.ctxPath + "/static/assets/img/treeContext/5111.png",
                'action': function () {
                    CasRoleManage.roleOrder(node);
                }
            }
        };
        if (node != undefined) {
            if (node.original.code == 'ROLE') {
                var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/queryPerm", function (json) {//角色是否有权限
                    if (json.length == 0) {//角色下无权限删除回收权限菜单
                        delete items.item4;
                    }
                }, function (data) {
                    Hussar.error(GET_ROLE_PERMISSION_FAIL);
                });
                ajax.set("id", node.id);
                ajax.set("applicationId", $("#applicationId").val());
                ajax.start();
            }
            // 系统角色和审计角色不能删除和回收权限
            if (node.original.id == "systemadmin_role" || node.original.id == "auditadmin_role") {
                delete items.item4;
                delete items.item5;
            }

            if (node.original.code == 'GROUP' && node.original.parent != '#') {
                // 角色分组拥有的右键菜单
                var shiroAdd = $("#shiroAddRole").val();
                var editGroup = $("#shiroEditGroup").val();
                var delGroup = $("#shiroDelGroup").val();
                if (shiroAdd != "add") {
                    delete items.item2;
                }
                if (editGroup != "editGroup") {
                    delete items.item6;
                }
                if (delGroup != "delGroup") {
                    delete items.item7;
                }
                delete items.item1;
                delete items.item3;
                delete items.item4;
                delete items.item5;
                delete items.item8;
            } else if (node.original.parent == '#') {
                //根节点右键菜单
                var saveGroup = $("#shiroSaveGroup").val();
                if (saveGroup != "saveGroup") {
                    delete items.item1;
                }
                var shiroAdd = $("#shiroAddRole").val();
                if (shiroAdd != "add") {
                    delete items.item2;
                }
                delete items.item3;
                delete items.item4;
                delete items.item5;
                delete items.item6;
                delete items.item7;
            } else {
                //角色排序
                var shiroEdit = $("#shiroEditRole").val();
                var shiroDel = $("#shiroDelRole").val();
                var shiroRec = $("#shiroReclaimPerm").val();
                if (shiroEdit != "edit") {
                    delete items.item3;
                }
                if (shiroRec != "rec") {
                    delete items.item4;
                }
                if (shiroDel != "del") {
                    delete items.item5;
                }
                delete items.item1;  //删除节点 items
                delete items.item2;
                delete items.item6;
                delete items.item7;
                delete items.item8;
                delete items.item9;
            }
            return items;
        }
    };

    /**
     *  业务系统关联角色树查询
     */
    CasRoleManage.searchRole = function () {
        var to = false;
        $("#searchRole").keyup(function () {
            if (to) {
                clearTimeout(to);
            }
            to = setTimeout(function () {
                var v = $("#searchRole").val();
                var temp = $("#roleTree").is(":hidden");
                if (temp == true) {
                    $("#roleTree").show();
                }
                $("#roleTree").jstree(true).search(v);
                //添加索引
                if (v != '') {
                    var n = $("#roleTree .jstree-search").length, con_html;
                    if (n > 0) {
                        con_html = "<em>" + n + "</em>个匹配项";
                    } else {
                        con_html = "无匹配项";
                    }
                    $("#roleSearch").html(con_html);
                    //定位到符合查询结果的树节点上
                    var searchResult = $("#roleTree").jstree('search', v);
                    $(searchResult).find('.jstree-search').focus();
                } else {
                    $("#roleSearch").html("");
                }
            }, 250);
        });
    }

    /**
     *  刷新页面，供子页面调用
     */
    CasRoleManage.refreshRole = function () {
        $("#roleTree").jstree(true).refresh();
        $("#roleIframe").attr("src", "");
    };

    // 刷新树
    CasRoleManage.refreshRoleTree = function () {
        $("#roleTree").jstree(true).refresh();
    };

    /**
     * 初始化排序树
     */
    CasRoleManage.initOrderTree = function () {
        var $orderTree = $("#orderTree"); //排序树
        $orderTree.jstree({
            core: {
                check_callback: function (operation, node, node_parent, node_position, more) {
                    if (operation == 'move_node') {
                        if (node.parent == node_parent.parent || node_parent.parent == null) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return true;
                    }
                },
                data: null
            },
            plugins: ['types', "dnd"],
            types: {
                "GROUP": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/roleGroup.png"},
                "ROLE": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/role.png"},
                "isRoot": {'icon': Hussar.ctxPath + "/static/assets/img/treeContext/" + theme + "/root.png"}
            },
            sort: function (a, b) {
                return this.get_node(a).original.seq > this.get_node(b).original.seq ? 1 : -1;
            }
        });

        //移动树事件
        var resultDom = $("#output1");   //隐藏结果集dom
        $orderTree.bind('move_node.jstree', function (e, data) {
            //移动的组织ID
            var id = data.node.id;
            //移动之前的位置
            var oldPosition = data.old_position;
            //移动后的位置
            var position = data.position;
            //原地未动
            if (oldPosition == position) {
                return;
            }
            var oldResult = JSON.parse(resultDom.val());
            //向上移动
            if (position - oldPosition < 0) {
                for (var i = 0; i < oldResult.length; i++) {
                    if (i < position) {
                        oldResult[i].seq = i + 1;
                    } else {
                        if (oldResult[i].id == id) {
                            oldResult[i].seq = position + 1;
                        } else {
                            if (i <= oldPosition) {
                                oldResult[i].seq = i + 2;
                            } else {
                                oldResult[i].seq = i + 1;
                            }
                        }
                    }
                }
            } else {//向下移动
                for (var i = 0; i < oldResult.length; i++) {
                    if (i < oldPosition) {
                        oldResult[i].seq = i + 1;
                    } else {
                        if (oldResult[i].id == id) {
                            oldResult[i].seq = position + 1;
                        } else {
                            if (i <= position) {
                                oldResult[i].seq = i;
                            } else {
                                oldResult[i].seq = i + 1;
                            }
                        }
                    }
                }
            }
            oldResult.sort(CasRoleManage.up);
            resultDom.val(window.JSON.stringify(oldResult));
        });
    };

    /**
     * 角色排序
     */
    CasRoleManage.up = function (x, y) {
        return x.seq - y.seq;
    };

    /**
     * 分组排序
     * @param node
     */
    CasRoleManage.groupOrder = function (node) {
        var applicationId = $("#applicationId").val();
        CasRoleManage.layIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            area: ['350px', '500px'],
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            shade: 0.4,
            title: "分组排序",
            content: $('#order'),
            btn2: function (index, layero) {
                //保存角色分组排序
                var operation = function () {
                    var info = $("#output1").val();
                    var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/saveGroupOrder", function (data) {
                        if (data.code == "200") {
                            Hussar.success(SAVE_SUCCESS);
                            layer.close(CasRoleManage.layIndex);
                            $("#roleTree").jstree(true).refresh();
                        } else if (data.code) {
                            Hussar.error(data.message);
                        } else {
                            Hussar.error(SAVE_FAIL);
                        }
                    }, function (data) {
                        Hussar.error(SAVE_ROLE_GROUP_SORT_FAIL);
                    });
                    ajax.set("info", info);
                    ajax.set("applicationId", applicationId);
                    ajax.start();
                };
                Hussar.confirm(SAVE_SORT_SURE, operation);
                return false;
            },
            success: function () {
                //添加按钮图标
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                //加载排序树数据
                var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/groupOrderTree", function (result) {
                    //排序树数据
                    $("#orderTree").jstree(true).settings.core.data = result;
                    $("#orderTree").jstree(true).refresh();
                    //除根节点数据保存到隐藏域里
                    var newResult = [];
                    for (var i = 0; i < result.length; i++) {
                        if (result[i].parent != "#") {
                            newResult.push(result[i]);
                        }
                    }
                    $("#output1").val(window.JSON.stringify(newResult));
                }, function (data) {
                    Hussar.error(LOAD_ROLE_GROUP_TREE_FAIL);
                });
                ajax.set("applicationId", applicationId);
                ajax.start();
            }
        });
    };

    /**
     * 角色排序
     * @param node
     */
    CasRoleManage.roleOrder = function (node) {
        var applicationId = $("#applicationId").val();
        CasRoleManage.layIndex = layer.open({
            type: 1,
            btn: ['取消', '保存'],
            skin: 'confirm-class',
            area: ['350px', '500px'],
            fix: false, //不固定
            maxmin: false,
            shadeClose: false,
            shade: 0.4,
            title: "角色排序",
            content: $('#order'),
            btn2: function (index, layero) {
                var operation = function () {
                    //保存角色分组排序
                    var info = $("#output1").val();
                    var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/saveRoleOrder", function (data) {
                        if (data.code == "200") {
                            Hussar.success(SAVE_SUCCESS);
                            layer.close(CasRoleManage.layIndex);
                            $("#roleTree").jstree(true).refresh();
                        } else if (data.code) {
                            Hussar.error(data.message);
                        } else {
                            Hussar.error(SAVE_FAIL);
                        }
                    }, function (data) {
                        Hussar.error(SAVE_ROLE_GROUP_SORT_FAIL);
                    });
                    ajax.set("info", info);
                    ajax.set("applicationId", applicationId);
                    ajax.start();
                };
                Hussar.confirm(SAVE_SORT_SURE, operation);
                return false;
            },
            success: function () {
                //添加按钮图标
                $(".layui-layer-btn0").prepend("<i class='iconfont'>&#x1006</i>");
                $(".layui-layer-btn1").prepend("<i class='iconfont'>&#xe009</i>");
                //加载排序树数据
                var ajax = new $ax(Hussar.ctxPath + "/casAppRoles/roleOrderTree", function (result) {
                    //排序树数据
                    $("#orderTree").jstree(true).settings.core.data = result;
                    $("#orderTree").jstree(true).refresh();
                    //除根节点数据保存到隐藏域里
                    var newResult = [];
                    for (var i = 0; i < result.length; i++) {
                        if (result[i].parent != "#") {
                            newResult.push(result[i]);
                        }
                    }
                    $("#output1").val(window.JSON.stringify(newResult));
                }, function (data) {
                    Hussar.error(LOAD_ROLE_GROUP_TREE_FAIL);
                });
                var parent = node.id;
                ajax.set("parent", parent);
                ajax.set("applicationId", applicationId)
                ajax.start();
            }
        });
    };

    CasRoleManage.initFrameHeight = function () {
        var h2 = $(window).height() - 110;
        var h3 = $(window).height() - 160;
        $("#roleIframe").css("height", h2 + "px");
        $("#roleInfo").css("height", h3 + "px");
    };

    /**
     * 初始化
     */
    $(function () {
        CasRoleManage.initPage();
        CasRoleManage.initOrderTree();
        $(window).resize(function () {
            CasRoleManage.initFrameHeight();
        });
    });
});