/**
 * @Description: 工作流同步失败信息
 * @Author: QiuYuanLong
 * @Date: 2020/08/07.
 */
layui.use(['jquery','layer','Hussar','HussarAjax','form','table'], function(){
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var table = layui.table;

    /**
     * 组织机构规则的单例
     */
    var BpmSyncFail = {
        id: "syncFail",	//表格id
        seItem: null,		//选中的条目
        table: null,
        layerIndex: -1
    };

    /**
     * 搜索组织机构规则
     */
    BpmSyncFail.search = function () {
        table.reload('failTable');
    }

    /**
     * 检查是否选中多条记录
     */
    BpmSyncFail.checkIds = function() {
        debugger;
        var selected = table.checkStatus('failTable').data;
        var ids = [];
        if (selected.length == 0) {
            Hussar.info(PLEASE_SELECT_AT_LEAST_ONE);
            return false;
        } else {
            for (var i = 0, l = selected.length; i < l; i++) {
                var r = selected[i];
                ids.push(r.id);
            }
            var eId = ids.join(',');
            BpmSyncFail.seItem = eId;
            return true;
        }
    };

    /**
     * 推送失败信息
     */
    BpmSyncFail.sendFail = function() {
        if (this.checkIds()) {
            var ajax = new $ax(Hussar.ctxPath + "/bpmSync/sendFailInfo",
                function(data) {
                    if (data) {
                        Hussar.success("推送消息成功");
                        BpmSyncFail.search();
                    }else {
                        Hussar.error("推送消息失败");
                    }
                }, function(data) {
                    Hussar.error("推送消息失败");
                });
            ajax.set("failId",this.seItem);
            ajax.start();
        }
    };

    /**
     * 初始化按钮事件
     */
    BpmSyncFail.initButtonEvent = function () {
        $("#btnSearch").click(function(){
            BpmSyncFail.search();
        });
        $("#sendFail").click(function(){
            BpmSyncFail.sendFail();
        });
    }

    /**
     * 初始化表格
     */
    BpmSyncFail.initTableView = function () {
        table.render({
            elem: '#failTable',
            url: Hussar.ctxPath+'/bpmSync/list',
            page: true,
            id: 'failTable',
            even: true,
            height:$("body").height() - $(".layui-form").outerHeight(true)-26,
            request: {
                pageName: 'curr', //页码的参数名称，默认：page
                limitName: 'nums' //每页数据量的参数名，默认：limit
            },
            cols: [[{type: 'checkbox',width:40},
                {type: 'numbers', title: '序号', align: 'center',width:50},
                {field: 'type', title: '操作类型', align:'center'},
                {field: 'fail_reason', title: '失败原因', align:'center'},
                {field: 'create_time', title: '创建时间', align:'center'},
                {field: 'contents', title: '消息内容', align:'center'}
            ]]
        });
    }

    $(function () {
        BpmSyncFail.initTableView(); //初始化表格
        BpmSyncFail.initButtonEvent(); //初始化按钮事件
    });

});




