/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.cas.system.dao.CasAppMenuMapper;
import com.jxdinfo.hussar.cas.system.model.CasAppMenu;
import com.jxdinfo.hussar.cas.system.service.ICasAppMenuService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CasAppMenuServiceImpl
extends ServiceImpl<CasAppMenuMapper, CasAppMenu>
implements ICasAppMenuService {
    @Resource
    CasAppMenuMapper casAppMenuMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @Override
    public List<JSTreeModel> getMenuTree(String applicationId) {
        return this.casAppMenuMapper.getMenuTree(applicationId);
    }

    @Override
    public void menuInfoSave(CasAppMenu casAppMenu, String applicationId) {
        if (ToolUtil.isEmpty((Object)casAppMenu.getMenuId())) {
            casAppMenu.setMenuId(null);
            Long max = this.casAppMenuMapper.getMaxOrderByParentId(casAppMenu.getParentId(), applicationId);
            if (ToolUtil.isNotEmpty((Object)max)) {
                int num = 1;
                int order = Integer.parseInt(String.valueOf(max));
                casAppMenu.setSeq(num + order);
            } else {
                casAppMenu.setSeq(1);
            }
            casAppMenu.setApplicationId(applicationId);
            this.casAppMenuMapper.insert((Object)casAppMenu);
            this.abstractPushMsgMatcher.insertOperation("menu", "add", (Object)casAppMenu, applicationId);
        } else {
            this.casAppMenuMapper.update((Object)casAppMenu, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"APPLICATION_ID", (Object)casAppMenu.getApplicationId())).eq((Object)"MENU_ID", (Object)casAppMenu.getMenuId()));
            this.abstractPushMsgMatcher.insertOperation("menu", "update", (Object)casAppMenu, applicationId);
        }
    }

    @Override
    public CasAppMenu getMenuInfo(String menuId, String applicationId) {
        return this.casAppMenuMapper.getMenuInfo(menuId, applicationId);
    }

    @Override
    public CasAppMenu getMenu(String menuId, String applicationId, String isLeaf) {
        return this.casAppMenuMapper.getMenu(menuId, applicationId, isLeaf);
    }

    @Override
    public List<JSTreeModel> menuTreeById(String menuId, String applicationId) {
        return this.casAppMenuMapper.menuTreeById(menuId, applicationId);
    }

    @Override
    public void menuTreeChange(String menuId, String parentId, String applicationId) {
        int order = 1;
        Long max = this.casAppMenuMapper.getMaxOrderByParentId(parentId, applicationId);
        if (ToolUtil.isNotEmpty((Object)max)) {
            order = Integer.parseInt(String.valueOf(max));
            ++order;
        }
        this.casAppMenuMapper.menuTreeChange(menuId, parentId, order, applicationId);
        CasAppMenu casAppMenu = new CasAppMenu();
        casAppMenu.setMenuId(menuId);
        casAppMenu.setSeq(order);
        casAppMenu.setParentId(parentId);
        this.abstractPushMsgMatcher.insertOperation("menu", "update", (Object)casAppMenu, applicationId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMoveNode(String menuId, boolean isUp, String applicationId) {
        CasAppMenu thatMenu;
        CasAppMenu thisMenu = this.casAppMenuMapper.getMenuInfo(menuId, applicationId);
        List<CasAppMenu> thatMenuList = isUp ? this.casAppMenuMapper.seletListLt(thisMenu.getParentId(), thisMenu.getSeq(), applicationId) : this.casAppMenuMapper.seletListGt(thisMenu.getParentId(), thisMenu.getSeq(), applicationId);
        if (thatMenuList.size() > 0 && (thatMenu = thatMenuList.get(0)) != null) {
            int temp = thisMenu.getSeq();
            thisMenu.setSeq(thatMenu.getSeq());
            thatMenu.setSeq(temp);
            thisMenu.setParentId(null);
            thisMenu.setResourceId(null);
            thisMenu.setApplicationId(applicationId);
            thatMenu.setApplicationId(applicationId);
            this.casAppMenuMapper.update((Object)thisMenu, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"MENU_ID", (Object)thisMenu.getMenuId()));
            this.abstractPushMsgMatcher.insertOperation("menu", "update", (Object)thisMenu, thisMenu.getApplicationId());
            this.casAppMenuMapper.update((Object)thatMenu, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"MENU_ID", (Object)thatMenu.getMenuId()));
            this.abstractPushMsgMatcher.insertOperation("menu", "update", (Object)thatMenu, thatMenu.getApplicationId());
        }
    }

    @Override
    public void exportMenu(List<String> idList, String applicationId, HttpServletResponse response) {
        QueryWrapper ew = new QueryWrapper();
        ew.in((Object)"MENU_ID", idList);
        ew.eq((Object)"APPLICATION_ID", (Object)applicationId);
        List menu = this.casAppMenuMapper.selectList((Wrapper)ew);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("menu", menu);
        data.put("export_type", "menu");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "menu_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public Tip importMenu(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"menu".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("menu"));
        }
        List menu = (List)data.get("menu");
        Map<String, Integer> count = this.insertOrUpdateList(menu);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\uff0c\u65b0\u589e\u6570\u636e" + count.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + count.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    public Map<String, Integer> insertOrUpdateList(List<CasAppMenu> menuList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(menuList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = menuList.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                QueryWrapper ew = new QueryWrapper();
                ew.eq((Object)"MENU_ID", (Object)menuList.get(i).getMenuId());
                ew.eq((Object)"APPLICATION_ID", (Object)menuList.get(i).getApplicationId());
                if (super.update((Object)menuList.get(i), (Wrapper)ew)) {
                    this.abstractPushMsgMatcher.insertOperation("menu", "update", (Object)menuList.get(i), menuList.get(i).getApplicationId());
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    this.abstractPushMsgMatcher.insertOperation("menu", "add", (Object)menuList.get(i), menuList.get(i).getApplicationId());
                    super.save((Object)menuList.get(i));
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (RuntimeException e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", (Throwable)e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    @Override
    public void updateBatchByIds(List<CasAppMenu> list) {
        this.casAppMenuMapper.updateBatchByIds(list);
    }
}

