/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.frontcontroller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.cas.system.dao.CasApplicationGroupMapper;
import com.jxdinfo.hussar.cas.system.dao.CasApplicationMapper;
import com.jxdinfo.hussar.cas.system.model.CasApplication;
import com.jxdinfo.hussar.cas.system.model.CasApplicationGroup;
import com.jxdinfo.hussar.cas.system.service.ICasApplicationService;
import com.jxdinfo.hussar.cas.util.ForestNodeMerger;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/casApplicationFront"})
public class CasApplicationFrontController
extends BaseController {
    private String PREFIX = "/system/casApplicationFront/";
    @Resource
    private ICasApplicationService casApplicationService;
    @Resource
    private CasApplicationGroupMapper casApplicationGroupMapper;
    @Resource
    private CasApplicationMapper casApplicationMapper;

    @RequestMapping(value={"/lazyCasTree"})
    @RequiresPermissions(value={"casApplication:lazyCasTree"})
    @BussinessLog(key="/casApplicationFront/lazyCasTree", type="04", value="\u4e1a\u52a1\u7cfb\u7edf\u6811\u61d2\u52a0\u8f7d")
    public ApiResponse<List<JSTreeModel>> lazyCasTree(@RequestBody Map<String, String> map) {
        String nodeId = map.get("nodeId");
        return ApiResponse.data(ForestNodeMerger.merge(this.casApplicationService.getLazyCasTree(nodeId)));
    }

    @RequestMapping(value={"/addCas"})
    @BussinessLog(key="/casApplicationFront/addCas", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf")
    @RequiresPermissions(value={"casApplication:addCas"})
    public ApiResponse<Object> addCas(@RequestBody Map<String, String> param) {
        String applicationName = param.get("applicationName");
        String applicationUrl = param.get("applicationUrl");
        String groupId = param.get("groupId");
        String isHussar = param.get("isHussar");
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("applicationName", applicationName);
        map.put("applicationUrl", applicationUrl);
        map.put("groupId", groupId);
        map.put("isHussar", isHussar);
        String applicationId = this.casApplicationService.addCas(map);
        return ApiResponse.data((Object)applicationId, (String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/editCas"})
    @BussinessLog(key="/casApplicationFront/editCas", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf")
    @RequiresPermissions(value={"casApplication:editCas"})
    public ApiResponse<Tip> editCas(@RequestBody Map<String, String> param) {
        String applicationId = param.get("applicationId") == null ? "" : param.get("applicationId").trim();
        String applicationName = param.get("applicationName") == null ? "" : param.get("applicationName").trim();
        String applicationUrl = param.get("applicationUrl") == null ? "" : param.get("applicationUrl").trim();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("applicationId", applicationId);
        map.put("applicationName", applicationName);
        map.put("applicationUrl", applicationUrl);
        QueryWrapper entityWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId);
        List casList = this.casApplicationService.list((Wrapper)entityWrapper);
        LogObjectHolder.me().set(casList.get(0));
        boolean flag = this.casApplicationService.editCas(map);
        if (flag) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/delCas"})
    @BussinessLog(key="/casApplicationFront/delCas", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf")
    @RequiresPermissions(value={"casApplication:delCas"})
    @ResponseBody
    public ApiResponse<Tip> delCas(@RequestBody Map<String, String> map) {
        String applicationId = map.get("id") == null ? "" : map.get("id");
        boolean flag = this.casApplicationService.delCas(applicationId);
        if (flag) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/casOrderTree"})
    @RequiresPermissions(value={"casApplication:casOrderTree"})
    @BussinessLog(key="/casApplicationFront/casAddPage", type="04", value="\u52a0\u8f7d\u4e1a\u52a1\u7cfb\u7edf\u6392\u5e8f\u6811")
    public ApiResponse<List<JSTreeModel>> casOrderTree(@RequestBody Map<String, String> map) {
        String parent = map.get("parentId");
        return ApiResponse.data(ForestNodeMerger.merge(this.casApplicationService.getCasOrderTree(parent)));
    }

    @RequestMapping(value={"/saveCasOrder"})
    @BussinessLog(key="/casApplicationFront/saveCasOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf\u6392\u5e8f")
    @RequiresPermissions(value={"casApplication:saveCasOrder"})
    public ApiResponse<Tip> saveCasOrder(@RequestBody Map<String, String> map) {
        String info = map.get("info") == null ? "" : map.get("info");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.casApplicationService.saveCasOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveGroup"})
    @RequiresPermissions(value={"casApplication:saveGroup"})
    @BussinessLog(key="/casApplicationFront/saveGroup", type="03", value="\u4fdd\u5b58\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4fe1\u606f")
    public ApiResponse<Object> saveGroup(@RequestBody Map<String, String> param) {
        String groupName = param.get("groupName");
        String type = param.get("type");
        String groupId = param.get("groupId");
        if (ToolUtil.equals((Object)"add", (Object)type)) {
            return ApiResponse.data((Object)this.casApplicationService.addGroup(groupName), (String)"\u65b0\u589e\u6210\u529f\uff01");
        }
        int count = this.casApplicationService.editGroup(groupName, groupId);
        CasApplicationGroup group = (CasApplicationGroup)((Object)this.casApplicationGroupMapper.selectById((Serializable)((Object)groupId)));
        groupName = group.getGroupName();
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("groupName", groupName);
        LogObjectHolder.me().set(map);
        if (count == 1) {
            return ApiResponse.data((Object)groupId);
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/searchCasGroup"})
    @RequiresPermissions(value={"casApplication:searchCasGroup"})
    @BussinessLog(key="/casApplicationFront/searchCasGroup", type="04", value="\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4e0b\u7684\u4e1a\u52a1\u7cfb\u7edf")
    @ResponseBody
    public ApiResponse<List<CasApplication>> searchCasGroup(@RequestBody Map<String, String> map) {
        String id = map.get("id");
        return ApiResponse.data((Object)this.casApplicationService.list((Wrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)id)));
    }

    @RequestMapping(value={"/delGroup"})
    @BussinessLog(key="/casApplicationFront/delGroup", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4")
    @RequiresPermissions(value={"casApplication:delGroup"})
    public ApiResponse<Tip> delGroup(@RequestBody Map<String, String> map) {
        String id = map.get("id");
        int count = this.casApplicationGroupMapper.deleteById((Serializable)((Object)id));
        if (count == 1) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/groupOrderTree"})
    @RequiresPermissions(value={"casApplication:groupOrderTree"})
    @BussinessLog(key="/casApplicationFront/groupOrderTree", type="04", value="\u52a0\u8f7d\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u6392\u5e8f\u6811")
    public ApiResponse<List<JSTreeModel>> groupOrderTree() {
        return ApiResponse.data(ForestNodeMerger.merge(this.casApplicationService.getGroupOrderTree()));
    }

    @RequestMapping(value={"/saveGroupOrder"})
    @BussinessLog(key="/casApplicationFront/saveGroupOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u6392\u5e8f")
    @RequiresPermissions(value={"casApplication:saveGroupOrder"})
    public ApiResponse<Tip> saveGroupOrder(@RequestBody Map<String, String> map) {
        String info = map.get("info") == null ? "" : map.get("info");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.casApplicationService.saveGroupOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/list_single"})
    @BussinessLog(key="/casApplicationFront/list_single", type="04", value="\u4e1a\u52a1\u7cfb\u7edf\u5217\u8868")
    @RequiresPermissions(value={"casApplication:list_single"})
    public ApiResponse<JSONObject> listSingle(@RequestBody Map<String, Object> map) {
        String page = map.get("current") == null ? "1" : map.get("current").toString();
        String limit = map.get("size") == null ? "10" : map.get("size").toString();
        String groupId = map.get("groupId") == null ? null : map.get("groupId").toString();
        JSONObject result = this.casApplicationService.getCasListVue(page, limit, groupId);
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/casGroupPage"})
    @BussinessLog(key="/casApplicationFront/casGroupPage", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4fe1\u606f")
    public ApiResponse<CasApplicationGroup> casAddGroupPage(@RequestBody Map<String, String> map) {
        String nodeId = map.get("id");
        CasApplicationGroup group = (CasApplicationGroup)((Object)this.casApplicationGroupMapper.selectById((Serializable)((Object)nodeId)));
        return ApiResponse.data((Object)((Object)group));
    }

    @RequestMapping(value={"/casSystemPage"})
    @BussinessLog(key="/casApplicationFront/casSystemPage", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f")
    public ApiResponse<CasApplication> casAddSystemPage(@RequestBody Map<String, String> map) {
        String nodeId = map.get("id");
        CasApplication casApplication = (CasApplication)((Object)this.casApplicationMapper.selectById((Serializable)((Object)nodeId)));
        String groupId = casApplication.getGroupId();
        CasApplicationGroup casApplicationGroup = (CasApplicationGroup)((Object)this.casApplicationGroupMapper.selectById((Serializable)((Object)groupId)));
        casApplication.setGroupId(casApplicationGroup.getGroupName());
        return ApiResponse.data((Object)((Object)casApplication));
    }

    @RequestMapping(value={"/testOnline"})
    @RequiresPermissions(value={"casApplication:testOnline"})
    @BussinessLog(key="/casApplicationFront/testOnline", type="04", value="\u6d4b\u8bd5\u662f\u5426\u5728\u7ebf")
    public ApiResponse testOnline(@RequestBody Map<String, String> map) throws Exception {
        String applicationId = map.get("applicationId");
        CasApplication casApplication = (CasApplication)((Object)this.casApplicationService.getById((Serializable)((Object)applicationId)));
        boolean ifOnline = this.casApplicationService.testOnline(casApplication);
        return ApiResponse.data((Object)ifOnline);
    }
}

