/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.messagepush;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.bpm.messagepush.condition.BpmMsgPushCondition;
import com.jxdinfo.hussar.bpm.messagepush.service.IBpmPushService;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.vo.BpmOrganVo;
import com.jxdinfo.hussar.bsp.organ.vo.BpmRolesVo;
import com.jxdinfo.hussar.bsp.organ.vo.BpmUserRoleVo;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Repository;

@Repository
@Conditional(value={BpmMsgPushCondition.class})
public class BpmMsgPushMatcher
extends AbstractBpmPushMsgMatcher {
    @Autowired
    private IBpmPushService bpmPushService;

    public void delete(String type, String id, String processingMode) {
        if (ToolUtil.isNotEmpty((Object)processingMode)) {
            this.bpmPushService.sendSyncInfo(type, processingMode, id);
        } else {
            this.bpmPushService.sendSyncInfo(type, "delete", id);
        }
    }

    public void pushOrgan(SysOrgan sysOrgan, SysStru sysStru, String processingMode) {
        BpmOrganVo bpmOrganVo = new BpmOrganVo();
        bpmOrganVo.setOrganId(sysStru.getStruId());
        if (ToolUtil.isNotEmpty((Object)sysOrgan)) {
            bpmOrganVo.setOrganCode(sysOrgan.getOrganCode());
            bpmOrganVo.setOrganName(sysOrgan.getOrganName());
        }
        bpmOrganVo.setParentId(sysStru.getParentId());
        bpmOrganVo.setSort(sysStru.getStruOrder().toString());
        bpmOrganVo.setState(sysStru.getInUse());
        bpmOrganVo.setType("organ");
        ArrayList<BpmOrganVo> bpmOrganVoList = new ArrayList<BpmOrganVo>();
        bpmOrganVoList.add(bpmOrganVo);
        this.bpmPushService.sendSyncInfo("organ", processingMode, bpmOrganVoList);
    }

    public void pushUser(SysUsers sysUsers, String processingMode, String organCode) {
        BpmOrganVo bpmOrganVo = new BpmOrganVo();
        bpmOrganVo.setOrganId(sysUsers.getUserId());
        bpmOrganVo.setOrganName(sysUsers.getUserName());
        bpmOrganVo.setParentId(sysUsers.getCorporationId());
        bpmOrganVo.setEmail(sysUsers.getEMail());
        bpmOrganVo.setMobile(sysUsers.getMobile());
        bpmOrganVo.setWechat(sysUsers.getWeChat());
        bpmOrganVo.setSort(sysUsers.getUserOrder().toString());
        bpmOrganVo.setOrganCode(organCode);
        bpmOrganVo.setType("user");
        ArrayList<BpmOrganVo> bpmOrganVoList = new ArrayList<BpmOrganVo>();
        bpmOrganVoList.add(bpmOrganVo);
        this.bpmPushService.sendSyncInfo("organ", processingMode, bpmOrganVoList);
    }

    public void pushOrganSort(SysStru thisStru, SysStru thatStru, JSONArray jsonArray) {
        ArrayList<BpmOrganVo> bpmOrganVoList = new ArrayList<BpmOrganVo>();
        if (ToolUtil.isNotEmpty((Object)thatStru)) {
            BpmOrganVo thisBpmOrgan = new BpmOrganVo();
            thisBpmOrgan.setOrganId(thisStru.getStruId());
            thisBpmOrgan.setSort(thisStru.getStruOrder().toString());
            bpmOrganVoList.add(thisBpmOrgan);
            BpmOrganVo thatBpmOrgan = new BpmOrganVo();
            thatBpmOrgan.setOrganId(thatStru.getStruId());
            thatBpmOrgan.setSort(thatStru.getStruOrder().toString());
            bpmOrganVoList.add(thatBpmOrgan);
        }
        if (ToolUtil.isNotEmpty((Object)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject json = jsonArray.getJSONObject(i);
                BpmOrganVo bpmOrganVo = new BpmOrganVo();
                bpmOrganVo.setOrganId(json.getString("id"));
                bpmOrganVo.setSort(json.getString("struOrder"));
                bpmOrganVoList.add(bpmOrganVo);
            }
        }
        this.bpmPushService.sendSyncInfo("organ", "update", bpmOrganVoList);
    }

    public void pushUserRole(List<SysUserRole> sysUserRoleList, String processingMode) {
        ArrayList<BpmUserRoleVo> bpmUserRoleVoList = new ArrayList<BpmUserRoleVo>();
        for (SysUserRole sysUserRole : sysUserRoleList) {
            BpmUserRoleVo bpmUserRoleVo = new BpmUserRoleVo();
            bpmUserRoleVo.setUserId(sysUserRole.getUserId());
            bpmUserRoleVo.setGrantedRole(sysUserRole.getGrantedRole());
            bpmUserRoleVoList.add(bpmUserRoleVo);
        }
        this.bpmPushService.sendSyncInfo("userRole", processingMode, bpmUserRoleVoList);
    }

    public void pushRole(String processingMode, SysRoles sysRoles, SysRoleGroup sysRoleGroup) {
        BpmRolesVo bpmRolesVo = new BpmRolesVo();
        if (ToolUtil.isEmpty((Object)sysRoleGroup)) {
            bpmRolesVo.setRoleId(sysRoles.getRoleId());
            bpmRolesVo.setRoleName(sysRoles.getRoleName());
            bpmRolesVo.setParentId(sysRoles.getGroupId());
            bpmRolesVo.setType("ROLE");
            bpmRolesVo.setSort(ToolUtil.isEmpty((Object)sysRoles.getRoleOrder()) ? null : sysRoles.getRoleOrder().toString());
        } else {
            bpmRolesVo.setRoleId(sysRoleGroup.getGroupId());
            bpmRolesVo.setRoleName(sysRoleGroup.getGroupName());
            bpmRolesVo.setParentId(sysRoleGroup.getParentId());
            bpmRolesVo.setType("GROUP");
            bpmRolesVo.setSort(ToolUtil.isEmpty((Object)sysRoleGroup.getGroupOrder()) ? null : sysRoleGroup.getGroupOrder().toString());
        }
        ArrayList<BpmRolesVo> bpmOrganVoList = new ArrayList<BpmRolesVo>();
        bpmOrganVoList.add(bpmRolesVo);
        this.bpmPushService.sendSyncInfo("role", processingMode, bpmOrganVoList);
    }

    public void pushRoleSort(List<SysRoleGroup> sysRoleGroupsList, List<SysRoles> sysRolesList) {
        ArrayList<BpmRolesVo> rolesList = new ArrayList<BpmRolesVo>();
        if (ToolUtil.isNotEmpty(sysRoleGroupsList)) {
            for (SysRoleGroup sysRoleGroup : sysRoleGroupsList) {
                BpmRolesVo bpmRolesVo = new BpmRolesVo();
                bpmRolesVo.setRoleId(sysRoleGroup.getGroupId());
                bpmRolesVo.setSort(sysRoleGroup.getGroupOrder().toString());
                rolesList.add(bpmRolesVo);
            }
        } else {
            for (SysRoles sysRoles : sysRolesList) {
                BpmRolesVo bpmRolesVo = new BpmRolesVo();
                bpmRolesVo.setRoleId(sysRoles.getRoleId());
                bpmRolesVo.setSort(sysRoles.getRoleOrder().toString());
                rolesList.add(bpmRolesVo);
            }
        }
        this.bpmPushService.sendSyncInfo("role", "update", rolesList);
    }

    public void deleteUserRole(List<String> userIds, List<String> roleIds, String userId, String roleId) {
        ArrayList<BpmUserRoleVo> list = new ArrayList<BpmUserRoleVo>();
        if (ToolUtil.isNotEmpty((Object)roleId)) {
            for (String s : userIds) {
                BpmUserRoleVo bpmUserRoleVo = new BpmUserRoleVo();
                bpmUserRoleVo.setUserId(s);
                bpmUserRoleVo.setGrantedRole(roleId);
                list.add(bpmUserRoleVo);
            }
        } else {
            for (String s : roleIds) {
                BpmUserRoleVo bpmUserRoleVo = new BpmUserRoleVo();
                bpmUserRoleVo.setUserId(s);
                bpmUserRoleVo.setGrantedRole(userId);
                list.add(bpmUserRoleVo);
            }
        }
        this.bpmPushService.sendSyncInfo("userRole", "delete", list);
    }
}

