/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.cas.system.dao.CasAppFunctionsMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppModulesMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppResourcesMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppRoleResourceMapper;
import com.jxdinfo.hussar.cas.system.model.CasAppFunctions;
import com.jxdinfo.hussar.cas.system.model.CasAppMenu;
import com.jxdinfo.hussar.cas.system.model.CasAppModules;
import com.jxdinfo.hussar.cas.system.model.CasAppResources;
import com.jxdinfo.hussar.cas.system.model.CasAppRoleResource;
import com.jxdinfo.hussar.cas.system.service.ICasAppFunctionsService;
import com.jxdinfo.hussar.cas.system.service.ICasAppModulesService;
import com.jxdinfo.hussar.cas.system.service.ICasAppResourcesService;
import com.jxdinfo.hussar.cas.system.service.ICasResManageService;
import com.jxdinfo.hussar.cas.system.service.impl.CasAppMenuServiceImpl;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

@Service
public class CasResManageServiceImpl
implements ICasResManageService {
    @Resource
    private CasAppResourcesMapper casAppResourcesMapper;
    @Resource
    private CasAppModulesMapper casAppModulesMapper;
    @Resource
    private CasAppFunctionsMapper casAppFunctionsMapper;
    @Resource
    private CasAppRoleResourceMapper casAppRoleResourceMapper;
    @Resource
    private ICasAppModulesService casAppModulesService;
    @Resource
    private ICasAppFunctionsService casAppFunctionsService;
    @Resource
    private ICasAppResourcesService casAppResourcesService;
    @Resource
    CasAppMenuServiceImpl casAppMenuService;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @Override
    public List<JSTreeModel> getResTree(String applicationId) {
        return this.casAppModulesMapper.getModulesTree(applicationId);
    }

    @Override
    public CasAppModules getModuleInfoById(String moduleId, String applicationId) {
        CasAppModules result = this.casAppModulesMapper.getModuleInfoById(moduleId, applicationId);
        if (ToolUtil.isNotEmpty((Object)((Object)result)) && ToolUtil.equals((Object)"1", (Object)result.getIsLeaf()) && !ToolUtil.equals((Object)"1", (Object)result.getParentModuleId())) {
            result = this.casAppModulesMapper.getModuleById(moduleId, applicationId);
        }
        return result;
    }

    @Override
    public Integer moduleSave(CasAppModules casAppModules) {
        Date date = new Date();
        String userId = ShiroKit.getUser().getId();
        Integer count = 0;
        if (ToolUtil.isEmpty((Object)casAppModules.getModuleId())) {
            casAppModules.setModuleId(null);
            Long max = this.casAppModulesMapper.getMaxOrderByParentId(casAppModules.getParentModuleId(), casAppModules.getApplicationId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                int num = 1;
                int order = Integer.parseInt(String.valueOf(max));
                casAppModules.setSeq(num + order);
            } else {
                casAppModules.setSeq(1);
            }
            casAppModules.setCreateTime(date);
            casAppModules.setCreator(userId);
            count = this.casAppModulesMapper.insert((Object)casAppModules);
            this.abstractPushMsgMatcher.insertOperation("modules", "add", (Object)casAppModules, casAppModules.getApplicationId());
        } else {
            casAppModules.setLastTime(date);
            casAppModules.setLastEditor(userId);
            count = this.casAppModulesMapper.update((Object)casAppModules, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"APPLICATION_ID", (Object)casAppModules.getApplicationId())).eq((Object)"MODULE_ID", (Object)casAppModules.getModuleId()));
            this.abstractPushMsgMatcher.insertOperation("modules", "update", (Object)casAppModules, casAppModules.getApplicationId());
        }
        return count;
    }

    @Override
    public List<JSTreeModel> moduleTreeById(String moduleId, String applicationId) {
        return this.casAppModulesMapper.moduleTreeById(moduleId, applicationId);
    }

    @Override
    public Integer functionSave(CasAppFunctions casAppFunctions) {
        Date date = new Date();
        String userId = ShiroKit.getUser().getId();
        Integer count = 0;
        if (ToolUtil.isEmpty((Object)casAppFunctions.getFunctionId())) {
            casAppFunctions.setFunctionId(null);
            Long max = this.casAppFunctionsMapper.getMaxOrderByParentId(casAppFunctions.getModuleId(), casAppFunctions.getApplicationId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                int num = 1;
                int order = Integer.parseInt(String.valueOf(max));
                casAppFunctions.setSeq(num + order);
            } else {
                casAppFunctions.setSeq(1);
            }
            casAppFunctions.setCreateTime(date);
            casAppFunctions.setCreator(userId);
            count = this.casAppFunctionsMapper.insert((Object)casAppFunctions);
            this.abstractPushMsgMatcher.insertOperation("functions", "add", (Object)casAppFunctions, casAppFunctions.getApplicationId());
        } else {
            casAppFunctions.setLastTime(date);
            casAppFunctions.setLastEditor(userId);
            count = this.casAppFunctionsMapper.update((Object)casAppFunctions, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"FUNCTION_ID", (Object)casAppFunctions.getFunctionId())).eq((Object)"APPLICATION_ID", (Object)casAppFunctions.getApplicationId()));
            this.abstractPushMsgMatcher.insertOperation("functions", "update", (Object)casAppFunctions, casAppFunctions.getApplicationId());
        }
        return count;
    }

    @Override
    public CasAppFunctions getFunctionInfoById(String functionId, String applicationId) {
        return this.casAppFunctionsMapper.getFunctionInfoById(functionId, applicationId);
    }

    @Override
    public String resourceSave(CasAppResources casAppResources) {
        Date date = new Date();
        String userId = ShiroKit.getUser().getId();
        if (ToolUtil.isEmpty((Object)casAppResources.getResourceId())) {
            casAppResources.setResourceId(null);
            Long max = this.casAppResourcesMapper.getMaxOrderByParentId(casAppResources.getFunctionId(), casAppResources.getApplicationId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                int num = 1;
                int order = Integer.parseInt(String.valueOf(max));
                casAppResources.setSeq(num + order);
            } else {
                casAppResources.setSeq(1);
            }
            casAppResources.setCreateTime(date);
            casAppResources.setCreator(userId);
            this.casAppResourcesMapper.insert((Object)casAppResources);
            this.abstractPushMsgMatcher.insertOperation("resource", "add", (Object)casAppResources, casAppResources.getApplicationId());
        } else {
            casAppResources.setLastTime(date);
            casAppResources.setLastEditor(userId);
            this.casAppResourcesMapper.update((Object)casAppResources, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"APPLICATION_ID", (Object)casAppResources.getApplicationId())).eq((Object)"RESOURCE_ID", (Object)casAppResources.getResourceId()));
            this.abstractPushMsgMatcher.insertOperation("resource", "update", (Object)casAppResources, casAppResources.getApplicationId());
        }
        return casAppResources.getResourceId();
    }

    @Override
    public CasAppResources getResourceInfoById(String resourceId, String applicationId) {
        return this.casAppResourcesMapper.getResourceInfoById(resourceId, applicationId);
    }

    @Override
    public JSONObject delModule(String moduleId, String applicationId) {
        List<CasAppModules> modulesResult = this.casAppModulesMapper.getModulesByParentId(moduleId, applicationId);
        List<CasAppFunctions> functionsResult = this.casAppFunctionsMapper.getFunctionsByModuleId(moduleId, applicationId);
        Boolean isDel = true;
        if (ToolUtil.isNotEmpty(modulesResult) || ToolUtil.isNotEmpty(functionsResult)) {
            isDel = false;
        }
        if (isDel.booleanValue()) {
            this.casAppModulesMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"MODULE_ID", (Object)moduleId)).eq((Object)"APPLICATION_ID", (Object)applicationId));
            this.abstractPushMsgMatcher.insertOperation("modules", "delete", (Object)moduleId, applicationId);
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    @Override
    public JSONObject delFunction(String functionId, String applicationId) {
        List<CasAppResources> resourcesResult = this.casAppResourcesMapper.getResourcesByFunctionId(functionId, applicationId);
        Boolean isDel = true;
        if (ToolUtil.isNotEmpty(resourcesResult)) {
            isDel = false;
        }
        if (isDel.booleanValue()) {
            this.casAppFunctionsMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"FUNCTION_ID", (Object)functionId));
            this.abstractPushMsgMatcher.insertOperation("functions", "delete", (Object)functionId, applicationId);
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    @Override
    public JSONObject delResource(String resourceId, String applicationId) {
        List<CasAppRoleResource> roleResourcesResult = this.casAppRoleResourceMapper.getRoleResourceByResourceId(resourceId, applicationId);
        Boolean isDel = true;
        if (ToolUtil.isNotEmpty(roleResourcesResult)) {
            isDel = false;
        }
        if (isDel.booleanValue()) {
            List menuList = this.casAppMenuService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RESOURCE_ID", (Object)resourceId)).eq((Object)"APPLICATION_ID", (Object)applicationId));
            if (menuList.size() != 0) {
                this.casAppMenuService.removeById((Serializable)((Object)((CasAppMenu)((Object)menuList.get(0))).getMenuId()));
                ArrayList<String> menus = new ArrayList<String>();
                menus.add(0, ((CasAppMenu)((Object)menuList.get(0))).getMenuId());
                this.abstractPushMsgMatcher.insertOperation("menu", "delete", menus, applicationId);
            }
            this.casAppResourcesMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"RESOURCE_ID", (Object)resourceId));
            this.abstractPushMsgMatcher.insertOperation("resource", "delete", (Object)resourceId, applicationId);
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    @Override
    public void saveModuleTreeOrder(JSONArray treeArr, String applicationId) {
        ArrayList<CasAppModules> sysModulesList = new ArrayList<CasAppModules>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = new JSONObject();
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasAppModules casAppModules = new CasAppModules();
            casAppModules.setModuleId(id);
            casAppModules.setSeq(Integer.parseInt(order));
            casAppModules.setApplicationId(applicationId);
            sysModulesList.add(casAppModules);
            this.casAppModulesService.update((Object)casAppModules, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"MODULE_ID", (Object)id));
        }
        if (ToolUtil.isNotEmpty(sysModulesList)) {
            this.abstractPushMsgMatcher.insertOperation("modules", "update", sysModulesList, applicationId);
        }
    }

    @Override
    public List<JSTreeModel> functionTreeByModuleId(String moduleId, String applicationId) {
        return this.casAppFunctionsMapper.functionTreeByModuleId(moduleId, applicationId);
    }

    @Override
    public void saveFunctionTreeOrder(JSONArray treeArr, String applicationId) {
        ArrayList<CasAppFunctions> casAppFunctionsList = new ArrayList<CasAppFunctions>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = new JSONObject();
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasAppFunctions casAppFunctions = new CasAppFunctions();
            casAppFunctions.setFunctionId(id);
            casAppFunctions.setSeq(Integer.parseInt(order));
            casAppFunctions.setApplicationId(applicationId);
            casAppFunctionsList.add(casAppFunctions);
            this.casAppFunctionsService.update((Object)casAppFunctions, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"FUNCTION_ID", (Object)id));
        }
        if (ToolUtil.isNotEmpty(casAppFunctionsList)) {
            this.abstractPushMsgMatcher.insertOperation("functions", "update", casAppFunctionsList, applicationId);
        }
    }

    @Override
    public List<JSTreeModel> resourceTreeByModuleId(String functionId, String applicationId) {
        return this.casAppResourcesMapper.resourceTreeByModuleId(functionId, applicationId);
    }

    @Override
    public boolean saveResourceTreeOrder(JSONArray treeArr, String applicationId) {
        ArrayList<CasAppResources> casAppResourcesList = new ArrayList<CasAppResources>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = new JSONObject();
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasAppResources casAppResources = new CasAppResources();
            casAppResources.setResourceId(id);
            casAppResources.setSeq(Integer.parseInt(order));
            casAppResources.setApplicationId(applicationId);
            casAppResourcesList.add(casAppResources);
            this.casAppResourcesService.update((Object)casAppResources, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"RESOURCE_ID", (Object)id));
        }
        if (ToolUtil.isNotEmpty(casAppResourcesList)) {
            this.abstractPushMsgMatcher.insertOperation("resource", "update", casAppResourcesList, applicationId);
        }
        return true;
    }

    @Override
    public List<JSTreeModel> moduleChangeById(String moduleId, String isLeaf, String applicationId) {
        return this.casAppModulesMapper.moduleChangeTreeById(moduleId, isLeaf, applicationId);
    }

    @Override
    public void functionTreeChange(String functionId, String parentId, String applicationId) {
        Long max = this.casAppFunctionsMapper.getMaxOrderByParentId(parentId, applicationId);
        int order = 1;
        if (ToolUtil.isNotEmpty((Object)max)) {
            int num = 1;
            order = Integer.parseInt(String.valueOf(max)) + num;
        }
        this.casAppFunctionsMapper.functionTreeChange(functionId, parentId, order, applicationId);
        CasAppFunctions functions = (CasAppFunctions)((Object)this.casAppFunctionsMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"FUNCTION_ID", (Object)functionId)).get(0));
        functions.setSeq(order);
        functions.setModuleId(parentId);
        this.abstractPushMsgMatcher.insertOperation("functions", "update", (Object)functions, applicationId);
    }

    @Override
    public List<JSTreeModel> resourceChangeById(String resourceId, String applicationId) {
        return this.casAppFunctionsMapper.resourceChangeById(resourceId, applicationId);
    }

    @Override
    public void resourceTreeChange(String resourceId, String parentId, String applicationId) {
        Long max = this.casAppResourcesMapper.getMaxOrderByParentId(parentId, applicationId);
        int order = 1;
        if (ToolUtil.isNotEmpty((Object)max)) {
            int num = 1;
            order = Integer.parseInt(String.valueOf(max)) + num;
        }
        this.casAppResourcesMapper.resourceTreeChange(resourceId, parentId, order, applicationId);
        CasAppResources resources = (CasAppResources)((Object)this.casAppResourcesMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RESOURCE_ID", (Object)resourceId)).eq((Object)"APPLICATION_ID", (Object)applicationId)).get(0));
        resources.setSeq(order);
        resources.setFunctionId(parentId);
        this.abstractPushMsgMatcher.insertOperation("resource", "update", (Object)resources, applicationId);
    }

    @Override
    public void moduleTreeChange(String moduleId, String parentId, String applicationId) {
        Long max = this.casAppModulesMapper.getMaxOrderByParentId(parentId, applicationId);
        int order = 1;
        if (ToolUtil.isNotEmpty((Object)max)) {
            int num = 1;
            order = Integer.parseInt(String.valueOf(max)) + num;
        }
        this.casAppModulesMapper.moduleTreeChange(moduleId, parentId, order, applicationId);
        CasAppModules modules = (CasAppModules)((Object)this.casAppModulesMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"MODULE_ID", (Object)moduleId)).get(0));
        modules.setSeq(order);
        modules.setModuleId(moduleId);
        this.abstractPushMsgMatcher.insertOperation("modules", "update", (Object)modules, applicationId);
    }

    @Override
    public List<JSTreeModel> selfResourceTree(String[] resourceIds, String applicationId) {
        return this.casAppResourcesMapper.selfResourceTree(resourceIds, applicationId);
    }

    @Override
    public List<JSTreeModel> getMenuResTree(String resType, String applicationId) {
        return this.casAppModulesMapper.getMenuModulesTree(resType, applicationId);
    }

    @Override
    public boolean isAllowEditModule(CasAppModules sysModules, String applicationId) {
        boolean flag = false;
        List<CasAppModules> modulesResult = this.casAppModulesMapper.getModulesByParentId(sysModules.getModuleId(), applicationId);
        List<CasAppFunctions> functionsResult = this.casAppFunctionsMapper.getFunctionsByModuleId(sysModules.getModuleId(), applicationId);
        CasAppModules oldModule = this.casAppModulesMapper.getModuleInfoById(sysModules.getModuleId(), applicationId);
        if (oldModule.getIsLeaf().equals(sysModules.getIsLeaf())) {
            flag = true;
        } else if (ToolUtil.isEmpty(modulesResult) && ToolUtil.isEmpty(functionsResult)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public List<JSTreeModel> getMoudleAndFunctionTree(String parentId, String applicationId) {
        return this.casAppModulesMapper.getLazyLoadModulesTree(parentId, applicationId);
    }

    @Override
    public List<JSTreeModel> getFunctionAndResTree(String nodeId, String applicationId) {
        return this.casAppModulesMapper.getFunctionAndResTree(nodeId, applicationId);
    }

    @Override
    public void exportRes(List<String> idList, String applicationId, HttpServletResponse response) {
        QueryWrapper moduEw = new QueryWrapper();
        moduEw.in((Object)"MODULE_ID", idList);
        moduEw.eq((Object)"APPLICATION_ID", (Object)applicationId);
        List modules = this.casAppModulesService.list((Wrapper)moduEw);
        QueryWrapper funcEw = new QueryWrapper();
        funcEw.in((Object)"FUNCTION_ID", idList);
        funcEw.eq((Object)"APPLICATION_ID", (Object)applicationId);
        List functions = this.casAppFunctionsService.list((Wrapper)funcEw);
        QueryWrapper resEw = new QueryWrapper();
        resEw.in((Object)"RESOURCE_ID", idList);
        resEw.eq((Object)"APPLICATION_ID", (Object)applicationId);
        List resources = this.casAppResourcesService.list((Wrapper)resEw);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("modules", modules);
        data.put("functions", functions);
        data.put("resources", resources);
        data.put("export_type", "resource");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "resource_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public Tip importRes(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"resource".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("resource"));
        }
        List modules = (List)data.get("modules");
        List functions = (List)data.get("functions");
        List resources = (List)data.get("resources");
        Map<String, Integer> moduleCount = this.casAppModulesService.insertOrUpdateList(modules);
        Map<String, Integer> functionCount = this.casAppFunctionsService.insertOrUpdateList(functions);
        Map<String, Integer> resourceCount = this.casAppResourcesService.insertOrUpdateList(resources);
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\u3002\u6a21\u5757\u65b0\u589e\u6570\u636e" + moduleCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + moduleCount.get("update") + "\u6761\uff1b\u529f\u80fd\u65b0\u589e\u6570\u636e" + functionCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + functionCount.get("update") + "\u6761\uff1b\u8d44\u6e90\u65b0\u589e\u6570\u636e" + resourceCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + resourceCount.get("update") + "\u6761\u3002");
        return success;
    }
}

