/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.frontcontroller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.cas.system.controller.CasUserUtil;
import com.jxdinfo.hussar.cas.system.dao.CasAppRoleGroupMapper;
import com.jxdinfo.hussar.cas.system.model.CasAppRoleGroup;
import com.jxdinfo.hussar.cas.system.model.CasAppRoleResource;
import com.jxdinfo.hussar.cas.system.model.CasAppRoles;
import com.jxdinfo.hussar.cas.system.service.ICasAppRoleResourceService;
import com.jxdinfo.hussar.cas.system.service.ICasAppRolesService;
import com.jxdinfo.hussar.cas.system.service.ICasAppUserRoleService;
import com.jxdinfo.hussar.cas.util.ForestNodeMerger;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/casAppRolesFront"})
public class CasAppRolesFrontController
extends BaseController {
    @Resource
    private ICasAppRolesService casAppRolesService;
    @Resource
    private ICasAppUserRoleService casAppUserRoleService;
    @Resource
    private CasAppRoleGroupMapper casAppRoleGroupMapper;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ICasAppRoleResourceService casAppRoleResourceService;
    @Resource
    private CasUserUtil casUserUtil;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @RequestMapping(value={"/getLazyRolesByCas"})
    @RequiresPermissions(value={"casAppRoles:getLazyRolesByCas"})
    @BussinessLog(key="/casAppRolesFront/getLazyRolesByCas", type="04", value="\u53ea\u52a0\u8f7d\u5f53\u524d\u4e1a\u52a1\u7cfb\u7edf\u7684\u89d2\u8272\u6811")
    public ApiResponse<List<JSTreeModel>> getLazyRolesByCas(@RequestBody Map<String, String> map) {
        String nodeId = map.get("nodeId");
        String applicationId = map.get("applicationId");
        List<JSTreeModel> jsTreeModelList = this.casAppRolesService.getLazyRolesByCas(nodeId, applicationId);
        return ApiResponse.data(ForestNodeMerger.merge(jsTreeModelList));
    }

    @RequestMapping(value={"/roleOrderTree"})
    @RequiresPermissions(value={"casAppRoles:roleOrderTree"})
    @BussinessLog(key="/casAppRolesFront/roleOrderTree", type="04", value="\u52a0\u8f7d\u89d2\u8272\u6392\u5e8f\u6811")
    public ApiResponse<List<JSTreeModel>> roleOrderTree(@RequestBody Map<String, String> map) {
        String parent = map.get("parentId");
        String applicationId = map.get("applicationId");
        List<JSTreeModel> jsTreeModelList = this.casAppRolesService.getRoleOrderTree(parent, applicationId);
        return ApiResponse.data(ForestNodeMerger.merge(jsTreeModelList));
    }

    @RequestMapping(value={"/groupOrderTree"})
    @RequiresPermissions(value={"casAppRoles:groupOrderTree"})
    @BussinessLog(key="/casAppRolesFront/groupOrderTree", type="04", value="\u52a0\u8f7d\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811")
    public ApiResponse<List<JSTreeModel>> groupOrderTree(@RequestBody Map<String, String> map) {
        String applicationId = map.get("applicationId");
        List<JSTreeModel> jsTreeModelList = this.casAppRolesService.getGroupOrderTree(applicationId);
        return ApiResponse.data(ForestNodeMerger.merge(jsTreeModelList));
    }

    @RequestMapping(value={"/saveGroupOrder"})
    @BussinessLog(key="/casAppRolesFront/saveGroupOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u5206\u7ec4\u6392\u5e8f")
    @RequiresPermissions(value={"casAppRoles:saveGroupOrder"})
    public ApiResponse<Tip> saveGroupOrder(@RequestBody Map<String, String> map) {
        String info = map.get("info");
        String applicationId = map.get("applicationId");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.casAppRolesService.saveGroupOrder(treeArr, applicationId);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/saveRoleOrder"})
    @BussinessLog(key="/casAppRolesFront/saveRoleOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u6392\u5e8f")
    @RequiresPermissions(value={"casAppRoles:saveRoleOrder"})
    public ApiResponse<Tip> saveRoleOrder(@RequestBody Map<String, String> map) {
        String info = map.get("info");
        String applicationId = map.get("applicationId");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.casAppRolesService.saveRoleOrder(treeArr, applicationId);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/delRole"})
    @RequiresPermissions(value={"casAppRoles:delRole"})
    @BussinessLog(key="/casAppRolesFront/delRole", type="02", value="\u5220\u9664\u89d2\u8272")
    public ApiResponse<Tip> delRole(@RequestBody Map<String, String> map) {
        String applicationId;
        String id = map.get("id").trim();
        int num = this.casAppUserRoleService.isDelete(id, applicationId = map.get("applicationId"));
        if (num > 0) {
            return ApiResponse.data((Object)new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u7528\u6237\uff01\uff09"));
        }
        boolean flag = this.casAppRolesService.delRole(id, applicationId);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            return ApiResponse.data((Object)tip);
        }
        return ApiResponse.data((Object)new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01"));
    }

    @RequestMapping(value={"/delGroup"})
    @BussinessLog(key="/casAppRolesFront/delGroup", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:delGroup"})
    public ApiResponse<Tip> delGroup(@RequestBody Map<String, String> map) {
        String id = map.get("id");
        String applicationId = map.get("applicationId");
        Integer count = this.casAppRoleGroupMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)id)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        if (count == 1) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            this.abstractPushMsgMatcher.insertOperation("roleGroup", "delete", (Object)id, applicationId);
            return ApiResponse.data((Object)tip);
        }
        return ApiResponse.data((Object)new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01"));
    }

    @RequestMapping(value={"/searchRoleToGroup"})
    @RequiresPermissions(value={"casAppRoles:searchRoleToGroup"})
    @BussinessLog(key="/casAppRolesFront/searchRoleToGroup", type="04", value="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272")
    public ApiResponse<List<CasAppRoles>> searchRoleToGroup(@RequestBody Map<String, String> map) {
        String id = map.get("id");
        String applicationId = map.get("applicationId");
        List casAppRolesList = this.casAppRolesService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)id)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        return ApiResponse.data((Object)casAppRolesList);
    }

    @RequestMapping(value={"/addRole"})
    @BussinessLog(key="/casAppRolesFront/addRole", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:addRole"})
    public ApiResponse<Object> addRole(@RequestBody Map<String, String> argsMap) {
        String roleName = argsMap.get("roleName").trim();
        String roleYw = argsMap.get("roleAlias") == null ? "" : argsMap.get("roleAlias").trim();
        String checkNodeId = argsMap.get("groupId").trim();
        String applicationId = argsMap.get("applicationId");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("roleName", roleName);
        map.put("roleYw", roleYw);
        map.put("checkNodeId", checkNodeId);
        map.put("applicationId", applicationId);
        String roleId = this.casAppRolesService.addRole(map);
        if (roleId == null || roleId == "") {
            return ApiResponse.data((Object)new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65b0\u589e\u5931\u8d25\uff01"));
        }
        JSONObject result = new JSONObject();
        result.put("roleId", (Object)roleId);
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/sameRoleName"})
    @RequiresPermissions(value={"casAppRoles:sameRoleName"})
    @BussinessLog(key="/casAppRolesFront/sameRoleName", type="04", value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272")
    public ApiResponse<List<CasAppRoles>> sameRoleName(@RequestBody Map<String, String> map) {
        String name = map.get("sameRoleName");
        String applicationId = map.get("applicationId");
        List casAppRolesList = this.casAppRolesService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_NAME", (Object)name)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        return ApiResponse.data((Object)casAppRolesList);
    }

    @RequestMapping(value={"/roleView"})
    @BussinessLog(key="/casAppRolesFront/roleView", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:roleView"})
    public ApiResponse<Map<String, Object>> roleView(@RequestBody Map<String, String> map) {
        String nodeId = map.get("id");
        String applicationId = map.get("applicationId");
        HashMap<String, Object> result = new HashMap<String, Object>();
        QueryWrapper entityWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)nodeId)).eq((Object)"APPLICATION_ID", (Object)applicationId);
        List roleList = this.casAppRolesService.list((Wrapper)entityWrapper);
        result.put("roleMessage", roleList);
        if (roleList.size() == 1) {
            String groupId = ((CasAppRoles)((Object)roleList.get(0))).getGroupId();
            if (groupId != null) {
                Wrapper groupWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)((CasAppRoles)((Object)roleList.get(0))).getGroupId())).eq((Object)"APPLICATION_ID", (Object)applicationId);
                List roleGroupList = this.casAppRoleGroupMapper.selectList(groupWrapper);
                if (roleGroupList != null) {
                    result.put("roleGroup", roleGroupList);
                } else {
                    result.put("roleGroup", "");
                }
            } else {
                result.put("roleGroup", "");
            }
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/roleResourceView"})
    @BussinessLog(key="/casAppRolesFront/roleResourceView", type="04", value="\u67e5\u770b\u89d2\u8272\u8d44\u6e90\u4fe1\u606f")
    public ApiResponse<List<CasAppRoleResource>> getRoleResourceView(@RequestBody Map<String, String> map) {
        String roleId = map.get("id") == null ? "" : map.get("id").trim();
        String applicationId = map.get("applicationId");
        List<CasAppRoleResource> resourceList = this.casAppRoleResourceService.queryPerm(roleId, applicationId);
        return ApiResponse.data(resourceList);
    }

    @RequestMapping(value={"/reclaimPerm"})
    @RequiresPermissions(value={"casAppRoles:reclaimPerm"})
    @BussinessLog(key="/casAppRolesFront/reclaimPerm", type="03", value="\u89d2\u8272\u56de\u6536\u6743\u9650")
    public ApiResponse<Tip> reclaimPerm(@RequestBody Map<String, String> map) {
        String id = map.get("id").trim();
        String applicationId = map.get("applicationId");
        this.casAppRoleResourceService.reclaimPerm(id, applicationId);
        return ApiResponse.data((Object)BaseController.SUCCESS_TIP);
    }

    @RequestMapping(value={"/editRole"})
    @BussinessLog(key="/casAppRolesFront/editRole", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:editRole"})
    public ApiResponse<Tip> editRole(@RequestBody Map<String, String> argsMap) {
        String roleId = argsMap.get("roleId").trim();
        String roleName = argsMap.get("roleName").trim();
        String applicationId = argsMap.get("applicationId");
        String roleYw = argsMap.get("roleAlias") == null ? "" : argsMap.get("roleAlias").trim();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("roleId", roleId);
        map.put("roleName", roleName);
        map.put("roleYw", roleYw);
        boolean flag = this.casAppRolesService.editRole(map, applicationId);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
            return ApiResponse.data((Object)tip);
        }
        return ApiResponse.data((Object)new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01"));
    }

    @RequestMapping(value={"/saveResource"})
    @BussinessLog(key="/casAppRolesFront/saveResource", type="01", value="\u4e1a\u52a1\u7cfb\u7edf-\u65b0\u589e\u89d2\u8272\u5173\u8054\u8d44\u6e90")
    @RequiresPermissions(value={"casAppRoles:saveResource"})
    public ApiResponse<Tip> saveResource(@RequestBody Map<String, String> map) {
        String ids = map.get("resourceIds");
        String roId = map.get("roleId");
        String applicationId = map.get("applicationId");
        this.casAppRoleResourceService.saveResource(ids, roId, applicationId);
        SuccessTip tip = new SuccessTip();
        tip.setMessage("\u89d2\u8272\u5173\u8054\u8d44\u6e90\u4fdd\u5b58\u6210\u529f\uff01");
        return ApiResponse.data((Object)tip);
    }

    @RequestMapping(value={"/lazyRoleUserTreeView"})
    @RequiresPermissions(value={"casAppRoles:lazyRoleUserTreeView"})
    @BussinessLog(key="/casAppRolesFront/lazyRoleUserTreeView", type="04", value="\u61d2\u52a0\u8f7d\u83b7\u53d6\u89d2\u8272\u7528\u6237\u6811")
    public ApiResponse<List<JSTreeModel>> getLazyRoleUserTreeView(@RequestBody Map<String, String> map) {
        String roleId = map.get("roleId");
        String nodeId = map.get("nodeId");
        String applicationId = map.get("applicationId");
        List<JSTreeModel> jsTreeModelList = this.casUserUtil.getCasUserByRole(roleId, nodeId, applicationId);
        return ApiResponse.data(ForestNodeMerger.merge(jsTreeModelList));
    }

    @RequestMapping(value={"/getRoleOrgUser"})
    @RequiresPermissions(value={"casAppRoles:getRoleOrgUser"})
    @BussinessLog(key="/casAppRolesFront/getRoleOrgUser", type="04", value="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u89d2\u8272\u7684\u4fe1\u606f")
    public ApiResponse<JSONObject> getRoleOrgUser(@RequestBody Map<String, Object> map) {
        String roleId = map.get("roleId").toString();
        String orgId = map.get("orgId").toString();
        int pageNo = map.get("pageNo") == null ? 1 : Integer.parseInt(map.get("pageNo").toString());
        int limit = map.get("limit") == null ? 20 : Integer.parseInt(map.get("limit").toString());
        String name = map.get("name").toString();
        String account = map.get("account").toString();
        String applicationId = map.get("applicationId").toString();
        Page page = new Page((long)pageNo, (long)limit);
        List<Object> list = ToolUtil.isEmpty((Object)roleId) ? new ArrayList() : this.casAppUserRoleService.getRoleOrgUser((Page<Object>)page, roleId, orgId, name, account, applicationId);
        JSONObject json = new JSONObject();
        json.put("data", list);
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return ApiResponse.data((Object)json);
    }

    @RequestMapping(value={"/addOrDelUserRole"})
    @RequiresPermissions(value={"casAppRoles:addOrDelUserRole"})
    @BussinessLog(key="/casAppRolesFront/addOrDelUserRole", type="01", value="\u6dfb\u52a0\u5220\u9664\u7528\u6237\u89d2\u8272")
    public ApiResponse<Tip> addOrDelUserRole(@RequestBody Map<String, String> map) {
        String adds = map.get("adds");
        String dels = map.get("dels");
        String roleId = map.get("roleId");
        String applicationId = map.get("applicationId");
        List addList = JSONObject.parseArray((String)adds, RoleOrgUserVo.class);
        List delList = JSONObject.parseArray((String)dels, RoleOrgUserVo.class);
        return ApiResponse.data((Object)this.casAppUserRoleService.addOrDelUserRole(addList, delList, roleId, applicationId));
    }

    @RequestMapping(value={"/saveGroup"})
    @BussinessLog(key="/casAppRolesFront/saveGroup", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:saveGroup"})
    public ApiResponse<Object> saveGroup(@RequestBody Map<String, String> map) {
        String applicationId = map.get("applicationId");
        String groupName = map.get("groupName");
        String groupAlias = map.get("groupAlias");
        String checkId = map.get("checkId");
        return ApiResponse.data((Object)this.casAppRolesService.saveGroup(applicationId, groupName, checkId, groupAlias));
    }

    @RequestMapping(value={"/sameGroupName"})
    @RequiresPermissions(value={"casAppRoles:sameGroupName"})
    @BussinessLog(key="/casAppRolesFront/sameGroupName", type="04", value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u5206\u7ec4")
    public ApiResponse<List<CasAppRoleGroup>> sameGroupName(@RequestBody Map<String, String> map) {
        String name = map.get("sameGroupName");
        String applicationId = map.get("applicationId");
        List list = this.casAppRoleGroupMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_NAME", (Object)name)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        return ApiResponse.data((Object)list);
    }

    @RequestMapping(value={"/roleGroupViewPage"})
    @BussinessLog(key="/casAppRolesFront/roleGroupViewPage", type="04", value="\u67e5\u770b\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @RequiresPermissions(value={"roleManager:roleGroupViewPage"})
    public ApiResponse<CasAppRoleGroup> roleGroupViewPage(@RequestBody Map<String, String> map) {
        String nodeId = map.get("id");
        String applicationId = map.get("applicationId");
        CasAppRoleGroup selectInfo = new CasAppRoleGroup();
        selectInfo.setGroupId(nodeId);
        selectInfo.setApplicationId(applicationId);
        QueryWrapper entityWrapper = new QueryWrapper((Object)selectInfo);
        CasAppRoleGroup group = (CasAppRoleGroup)((Object)this.casAppRoleGroupMapper.selectOne((Wrapper)entityWrapper));
        return ApiResponse.data((Object)((Object)group));
    }

    @RequestMapping(value={"/editGroup"})
    @BussinessLog(key="/casAppRolesFront/editGroup", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf-\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @RequiresPermissions(value={"casAppRoles:editGroup"})
    public ApiResponse<Object> editGroup(@RequestBody Map<String, String> map) {
        String groupName = map.get("groupName");
        String groupAlias = map.get("groupAlias");
        String checkId = map.get("checkId");
        String applicationId = map.get("applicationId");
        return ApiResponse.data((Object)this.casAppRolesService.editGroup(applicationId, groupName, checkId, groupAlias));
    }

    @RequestMapping(value={"/roleTree"})
    @RequiresPermissions(value={"casAppRoles:roleTree"})
    @BussinessLog(key="/casAppRolesFront/roleTree", type="04", value="\u52a0\u8f7d\u89d2\u8272\u6811")
    public ApiResponse<List<JSTreeModel>> roleTree(@RequestBody Map<String, String> map) {
        String applicationId = map.get("applicationId");
        List<JSTreeModel> result = this.casAppRolesService.getRoleTree(applicationId);
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent("#");
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u89d2\u8272\u5217\u8868");
        jsTreeModel.setId("1");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }
}

