/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.frontcontroller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.cas.system.dao.CasAppFunctionsMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppModulesMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppResourcesMapper;
import com.jxdinfo.hussar.cas.system.model.CasAppFunctions;
import com.jxdinfo.hussar.cas.system.model.CasAppModules;
import com.jxdinfo.hussar.cas.system.model.CasAppResources;
import com.jxdinfo.hussar.cas.system.model.CasAppRoleResource;
import com.jxdinfo.hussar.cas.system.service.ICasAppResourcesService;
import com.jxdinfo.hussar.cas.system.service.ICasAppRoleResourceService;
import com.jxdinfo.hussar.cas.system.service.ICasAppRolesService;
import com.jxdinfo.hussar.cas.system.service.ICasResManageService;
import com.jxdinfo.hussar.cas.util.ForestNodeMerger;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/casAppResourceFront"})
public class CasAppResourcesFrontController
extends BaseController {
    @Resource
    ICasResManageService casResManageService;
    @Resource
    ICasAppResourcesService casAppResourcesService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    CasAppResourcesMapper casAppResourcesMapper;
    @Resource
    ICasAppRoleResourceService casAppRoleResourceService;
    @Resource
    private ICasAppRolesService casAppRolesService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private CasAppModulesMapper casAppModulesMapper;
    @Resource
    private CasAppFunctionsMapper casAppFunctionsMapper;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @RequestMapping(value={"/editResTree"})
    @RequiresPermissions(value={"casAppResource:editResTree"})
    @BussinessLog(key="/casAppResourceFront/editResTree", type="04", value="\u89d2\u8272\u4fee\u6539\u5c55\u793a\u529f\u80fd\u8d44\u6e90\u6811")
    public ApiResponse<List<JSTreeModel>> editResTree(@RequestBody Map<String, String> map) {
        String roleId = map.get("roleId");
        String applicationId = map.get("applicationId");
        List resourceList = this.casAppRoleResourceService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)roleId)).eq((Object)"APPLICATION_ID", (Object)applicationId));
        String[] resourceIds = new String[resourceList.size()];
        for (int i = 0; i < resourceList.size(); ++i) {
            resourceIds[i] = ((CasAppRoleResource)((Object)resourceList.get(i))).getResourceId();
        }
        List<JSTreeModel> result = this.casResManageService.getResTree(applicationId);
        block1: for (JSTreeModel js : result) {
            js.setState(false, false, false);
            if (ToolUtil.equals((Object)js.getConstant(), (Object)"1")) {
                js.setState(false, false, true);
                for (String id : resourceIds) {
                    if (!ToolUtil.equals((Object)js.getId(), (Object)id)) continue;
                    js.setState(true, true, true);
                    continue block1;
                }
                continue;
            }
            for (String id : resourceIds) {
                if (!ToolUtil.equals((Object)js.getId(), (Object)id)) continue;
                js.setState(true, true, false);
                continue block1;
            }
        }
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/selfResourceTree"})
    @RequiresPermissions(value={"casAppResource:selfResourceTree"})
    @BussinessLog(key="/casAppResourceFront/selfResourceTree", type="04", value="\u53ea\u52a0\u8f7d\u5f53\u524d\u7528\u6237\u7684\u8d44\u6e90\u6811")
    public ApiResponse<List<JSTreeModel>> selfResourceTree(@RequestBody Map<String, String> map) {
        String[] resourceIds = map.get("resourceIds").trim().split(",");
        String applicationId = map.get("applicationId");
        List<JSTreeModel> result = this.casResManageService.selfResourceTree(resourceIds, applicationId);
        List<JSTreeModel> tree = this.doRecursive(result);
        block0: for (JSTreeModel js : tree) {
            for (String id : resourceIds) {
                if (ToolUtil.equals((Object)js.getId(), (Object)id)) {
                    js.setState(true, true, true);
                    continue block0;
                }
                js.setState(false, false, true);
            }
        }
        return ApiResponse.data(ForestNodeMerger.merge(tree));
    }

    private List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, "");
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!"#".equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent("#");
        model.setCode("GROUP");
        model.setText("\u89d2\u8272\u8d44\u6e90\u6811");
        model.setId("1");
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    private void recursive(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (i < 0) break;
            JSTreeModel map = list.get(i);
            if (!"1".equals(map.getIsRes()) && !parentId.equals(map.getId())) continue;
            parentId = map.getParent();
            result.add(map);
            list.remove(i);
            this.recursive(list, result, parentId);
        }
    }

    @RequestMapping(value={"/resTree"})
    @RequiresPermissions(value={"casAppResource:resTree"})
    @BussinessLog(key="/casAppResourceFront/resTree", type="04", value="\u529f\u80fd\u8d44\u6e90\u6811")
    public ApiResponse<List<JSTreeModel>> resTree(@RequestBody Map<String, String> map) {
        String type = map.get("type");
        String applicationId = map.get("applicationId");
        List<Object> result = new ArrayList();
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        if ("menuRes".equals(type)) {
            String resType = this.sysDicRefService.getDictValue("res_type", "\u83dc\u5355\u8d44\u6e90");
            result = this.casResManageService.getMenuResTree(resType, applicationId);
            result.add(root);
        } else {
            String nodeId = map.get("nodeId");
            if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)nodeId)) {
                String string = map.get("isLeaf");
                String nodeType = map.get("nodeType");
                boolean isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType);
                boolean isLeaf = ToolUtil.equals((Object)"1", (Object)string);
                boolean isFun = ToolUtil.equals((Object)"isFun", (Object)nodeType);
                boolean isFunAndRes = isModule && isLeaf || isFun;
                List<Object> tree = new ArrayList();
                if (ToolUtil.equals((Object)"#", (Object)nodeId)) {
                    nodeId = "1";
                    result.add(root);
                    tree = this.casResManageService.getMoudleAndFunctionTree(nodeId, applicationId);
                } else if (isModule && !isLeaf) {
                    tree = this.casResManageService.getMoudleAndFunctionTree(nodeId, applicationId);
                } else if (isFunAndRes) {
                    tree = this.casResManageService.getFunctionAndResTree(nodeId, applicationId);
                }
                result.addAll(tree);
            } else {
                result = this.casResManageService.getResTree(applicationId);
                result.add(root);
            }
        }
        for (JSTreeModel jSTreeModel : result) {
            String isLeaf = jSTreeModel.getIsLeaf();
            String isModule = jSTreeModel.getType();
            if (!"isModule".equals(isModule) || !"0".equals(isLeaf)) continue;
            jSTreeModel.getState().put("notLeafModule", true);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequiresPermissions(value={"casAppResource:delModule"})
    @RequestMapping(value={"/delModule"})
    @BussinessLog(key="/casAppResourceFront/delModule", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf-\u6a21\u5757", pk="moduleId")
    public ApiResponse<JSONObject> delModule(@RequestBody Map<String, String> map) {
        String moduleId = map.get("moduleId");
        String applicationId = map.get("applicationId");
        JSONObject jsonObject = this.casResManageService.delModule(moduleId, applicationId);
        return ApiResponse.data((Object)jsonObject);
    }

    @RequiresPermissions(value={"casAppResource:delFunction"})
    @BussinessLog(key="/casAppResourceFront/delFunction", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf-\u529f\u80fd", pk="functionId")
    @RequestMapping(value={"/delFunction"})
    public ApiResponse<JSONObject> delFunction(@RequestBody Map<String, String> map) {
        String functionId = map.get("functionId");
        String applicationId = map.get("applicationId");
        JSONObject jsonObject = this.casResManageService.delFunction(functionId, applicationId);
        return ApiResponse.data((Object)jsonObject);
    }

    @RequiresPermissions(value={"casAppResource:delResource"})
    @BussinessLog(key="/casAppResourceFront/delResource", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90", pk="resourceId")
    @RequestMapping(value={"/delResource"})
    public ApiResponse<JSONObject> delResource(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String applicationId = map.get("applicationId");
        JSONObject jsonObject = this.casResManageService.delResource(resourceId, applicationId);
        return ApiResponse.data((Object)jsonObject);
    }

    @RequestMapping(value={"/resourceChangeById"})
    @RequiresPermissions(value={"casAppResource:resourceChangeById"})
    @BussinessLog(key="/casAppResourceFront/resourceChangeById", type="04", value="\u83b7\u53d6\u8d44\u6e90\u8f6c\u79fb\u6811")
    public ApiResponse<List<JSTreeModel>> resourceChangeById(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String applicationId = map.get("applicationId");
        List<JSTreeModel> result = this.casResManageService.resourceChangeById(resourceId, applicationId);
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/moduleChangeById"})
    @RequiresPermissions(value={"casAppResource:moduleChangeById"})
    @BussinessLog(key="/casAppResourceFront/moduleChangeById", type="03", value="\u6a21\u5757\u8f6c\u79fb")
    public ApiResponse<List<JSTreeModel>> moduleChangeById(@RequestBody Map<String, Object> map) {
        String moduleId = map.get("moduleId") == null ? "" : map.get("moduleId").toString();
        String applicationId = map.get("applicationId") == null ? "" : map.get("applicationId").toString();
        String isLeaf = map.get("isLeaf") == null ? "" : map.get("isLeaf").toString();
        List<JSTreeModel> result = this.casResManageService.moduleChangeById(moduleId, isLeaf, applicationId);
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/resourceTreeById"})
    @RequiresPermissions(value={"casAppResource:resourceTreeById"})
    @BussinessLog(key="/casAppResourceFront/resourceTreeById", type="04", value="\u6839\u636e\u529f\u80fdID\u83b7\u53d6\u8d44\u6e90\u6811")
    public ApiResponse<List<JSTreeModel>> resourceTreeById(@RequestBody Map<String, String> map) {
        String functionId = map.get("functionId");
        String functionName = map.get("functionName");
        String applicationId = map.get("applicationId");
        List<JSTreeModel> result = this.casResManageService.resourceTreeByModuleId(functionId, applicationId);
        JSTreeModel root = new JSTreeModel();
        root.setId(functionId);
        root.setText(functionName);
        root.setParent("#");
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isFun");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/functionTreeById"})
    @RequiresPermissions(value={"casAppResource:functionTreeById"})
    @BussinessLog(key="/casAppResourceFront/functionTreeById", type="04", value="\u6839\u636e\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6811")
    public ApiResponse<List<JSTreeModel>> functionTreeById(@RequestBody Map<String, String> map) {
        String moduleId = map.get("moduleId");
        String moduleName = map.get("moduleName");
        String applicationId = map.get("applicationId");
        List<JSTreeModel> result = this.casResManageService.functionTreeByModuleId(moduleId, applicationId);
        JSTreeModel root = new JSTreeModel();
        root.setId(moduleId);
        root.setText(moduleName);
        root.setParent("#");
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/moduleTreeById"})
    @RequiresPermissions(value={"casAppResource:moduleTreeById"})
    @BussinessLog(key="/casAppResourceFront/moduleTreeById", type="04", value="\u6839\u636eID\u83b7\u53d6\u4e0b\u7ea7\u6811", pk="moduleId")
    public ApiResponse<List<JSTreeModel>> moduleTreeById(@RequestBody Map<String, Object> map) {
        String moduleId = map.get("moduleId").toString();
        String isHead = map.get("isRoot").toString();
        String applicationId = map.get("applicationId").toString();
        Boolean isRoot = Boolean.valueOf(isHead);
        List<JSTreeModel> result = this.casResManageService.moduleTreeById(moduleId, applicationId);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("1");
            root.setCode("1");
            root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/resourceTreeOrder"})
    @RequiresPermissions(value={"casAppResource:resourceTreeOrder"})
    @BussinessLog(key="/casAppResourceFront/resourceTreeOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Boolean> resourceTreeOrder(@RequestBody Map<String, String> map) {
        String treeInfo = map.get("treeInfo");
        String applicationId = map.get("applicationId");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        boolean flag = this.casResManageService.saveResourceTreeOrder(treeArr, applicationId);
        return ApiResponse.data((Object)flag);
    }

    @RequestMapping(value={"/functionTreeOrder"})
    @RequiresPermissions(value={"casAppResource:functionTreeOrder"})
    @BussinessLog(key="/casAppResourceFront/functionTreeOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u529f\u80fd\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Tip> functionTreeOrder(@RequestBody Map<String, String> map) {
        String treeInfo = map.get("treeInfo");
        String applicationId = map.get("applicationId");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.casResManageService.saveFunctionTreeOrder(treeArr, applicationId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/moduleTreeOrder"})
    @RequiresPermissions(value={"casAppResource:moduleTreeOrder"})
    @BussinessLog(key="/casAppResourceFront/moduleTreeOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u6a21\u5757\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Tip> moduleTreeOrder(@RequestBody Map<String, String> map) {
        String treeInfo = map.get("treeInfo");
        String applicationId = map.get("applicationId");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.casResManageService.saveModuleTreeOrder(treeArr, applicationId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/moduleTreeChange"})
    @RequiresPermissions(value={"casAppResource:moduleTreeChange"})
    @BussinessLog(key="/casAppResourceFront/moduleTreeChange", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u6a21\u5757\u8f6c\u79fb")
    public ApiResponse<Tip> moduleTreeChange(@RequestBody Map<String, String> map) {
        String moduleId = map.get("moduleId");
        String parentId = map.get("parentId");
        String applicationId = map.get("applicationId");
        this.casResManageService.moduleTreeChange(moduleId, parentId, applicationId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/functionTreeChange"})
    @RequiresPermissions(value={"casAppResource:functionTreeChange"})
    @BussinessLog(key="/casAppResourceFront/functionTreeChange", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u529f\u80fd\u8f6c\u79fb")
    public ApiResponse<Tip> functionTreeChange(@RequestBody Map<String, String> map) {
        String functionId = map.get("functionId");
        String parentId = map.get("parentId");
        String applicationId = map.get("applicationId");
        this.casResManageService.functionTreeChange(functionId, parentId, applicationId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/resourceTreeChange"})
    @RequiresPermissions(value={"casAppResource:resourceTreeChange"})
    @BussinessLog(key="/casAppResourceFront/resourceTreeChange", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u8f6c\u79fb")
    public ApiResponse<Tip> resourceTreeChange(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String parentId = map.get("parentId");
        String applicationId = map.get("applicationId");
        this.casResManageService.resourceTreeChange(resourceId, parentId, applicationId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/exportRes"})
    @RequiresPermissions(value={"casAppResource:exportRes"})
    @BussinessLog(key="/casAppResourceFront/exportRes", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u5bfc\u51fa")
    public void exportData(HttpServletResponse response, @RequestParam(value="ids") String ids, @RequestParam(value="applicationId") String applicationId) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.casResManageService.exportRes(idList, applicationId, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @RequiresPermissions(value={"casAppResource:importData"})
    @BussinessLog(key="/casAppResourceFront/importData", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u5bfc\u5165")
    public ApiResponse<Tip> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return ApiResponse.data((Object)this.casResManageService.importRes(content));
    }

    @RequiresPermissions(value={"casAppResource:moduleSave"})
    @RequestMapping(value={"/moduleSave"})
    @BussinessLog(key="/casAppResourceFront/moduleSave", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf-\u6a21\u5757")
    public ApiResponse<Integer> moduleSave(@RequestBody CasAppModules casAppModules) {
        return ApiResponse.data((Object)this.casResManageService.moduleSave(casAppModules));
    }

    @RequiresPermissions(value={"casAppResource:moduleAdd"})
    @RequestMapping(value={"/moduleAdd"})
    @BussinessLog(key="/casAppResourceFront/moduleAdd", type="04", value="\u65b0\u589e\u6a21\u5757", pk="moduleId")
    public ApiResponse<Map<String, Object>> moduleAdd(@RequestBody Map<String, String> map) {
        String moduleId = map.get("moduleId");
        String applicationId = map.get("applicationId");
        String currentCode = this.sysIdtableService.getCurrentCode("module_code", "sys_modules");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("currentCode", currentCode);
        return ApiResponse.data(dataMap);
    }

    @RequestMapping(value={"/moduleView"})
    @BussinessLog(key="/casAppResourceFront/moduleView", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf-\u6a21\u5757\u4fe1\u606f")
    @RequiresPermissions(value={"casAppResource:moduleView"})
    public ApiResponse<Map<String, Object>> moduleView(@RequestBody Map<String, String> map) {
        String moduleId = map.get("moduleId");
        String applicationId = map.get("applicationId");
        CasAppModules result = this.casResManageService.getModuleInfoById(moduleId, applicationId);
        HashMap<String, CasAppModules> dataMap = new HashMap<String, CasAppModules>();
        dataMap.put("casAppModules", result);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"casAppResource:moduleEditSave"})
    @RequestMapping(value={"/moduleEditSave"})
    @BussinessLog(key="/casAppResourceFront/moduleEditSave", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf-\u6a21\u5757", pk="moduleId")
    public ApiResponse<Tip> moduleEditSave(@RequestBody CasAppModules casAppModules) {
        boolean isAllowEditModule = this.casResManageService.isAllowEditModule(casAppModules, casAppModules.getApplicationId());
        CasAppModules sysModules = (CasAppModules)((Object)this.casAppModulesMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)casAppModules.getApplicationId())).eq((Object)"MODULE_ID", (Object)casAppModules.getModuleId())).get(0));
        LogObjectHolder.me().set((Object)sysModules);
        if (isAllowEditModule) {
            Integer count = this.casResManageService.moduleSave(casAppModules);
            if (count != 0) {
                SuccessTip tip = new SuccessTip();
                tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
                return ApiResponse.data((Object)tip);
            }
            return ApiResponse.data((Object)new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01"));
        }
        return ApiResponse.data((Object)new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08\u5b58\u5728\u4e0b\u7ea7\u6a21\u5757\u6216\u4e0b\u7ea7\u529f\u80fd\u65f6\u4e0d\u80fd\u4fee\u6539\u6a21\u5757\u7c7b\u578b\uff01\uff09"));
    }

    @RequiresPermissions(value={"casAppResource:functionSave"})
    @RequestMapping(value={"/functionSave"})
    @BussinessLog(key="/casAppResourceFront/functionSave", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf-\u529f\u80fd", pk="functionId")
    public ApiResponse<Integer> functionSave(@RequestBody CasAppFunctions sysFunctions) {
        sysFunctions.setFunctionId(null);
        return ApiResponse.data((Object)this.casResManageService.functionSave(sysFunctions));
    }

    @RequiresPermissions(value={"casAppResource:functionAdd"})
    @RequestMapping(value={"/functionAdd"})
    @BussinessLog(key="/casAppResourceFront/functionAdd", type="04", value="\u65b0\u589e\u529f\u80fd")
    public ApiResponse<Map<String, Object>> functionAdd(@RequestBody Map<String, String> map) {
        String moduleCode = map.get("moduleCode");
        String currentCode = this.sysIdtableService.getCurrentCode("function_code", "sys_functions");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("currentCode", moduleCode + currentCode);
        return ApiResponse.data(dataMap);
    }

    @RequestMapping(value={"/functionView"})
    @RequiresPermissions(value={"casAppResource:functionView"})
    @BussinessLog(key="/casAppResourceFront/functionView", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf-\u529f\u80fd\u4fe1\u606f")
    public ApiResponse<Map<String, Object>> functionView(@RequestBody Map<String, String> map) {
        String functionId = map.get("functionId");
        String applicationId = map.get("applicationId");
        CasAppFunctions result = this.casResManageService.getFunctionInfoById(functionId, applicationId);
        HashMap<String, CasAppFunctions> dataMap = new HashMap<String, CasAppFunctions>();
        dataMap.put("casAppFunctions", result);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"casAppResource:functionEditSave"})
    @RequestMapping(value={"/functionEditSave"})
    @BussinessLog(key="/casAppResourceFront/functionEditSave", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf-\u529f\u80fd", pk="functionId")
    public ApiResponse<Integer> functionEditSave(@RequestBody CasAppFunctions casAppFunctions) {
        List casAppFunctionsList = this.casAppFunctionsMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FUNCTION_ID", (Object)casAppFunctions.getFunctionId())).eq((Object)"APPLICATION_ID", (Object)casAppFunctions.getApplicationId()));
        LogObjectHolder.me().set(casAppFunctionsList.get(0));
        return ApiResponse.data((Object)this.casResManageService.functionSave(casAppFunctions));
    }

    @RequiresPermissions(value={"casAppResource:resourceSave"})
    @RequestMapping(value={"/resourceSave"})
    @BussinessLog(key="/casAppResourceFront/resourceSave", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90", pk="resourceId")
    public ApiResponse<String> resourceSave(@RequestBody CasAppResources sysResources) {
        sysResources.setResourceId(null);
        String resourceId = this.casResManageService.resourceSave(sysResources);
        return ApiResponse.data((Object)resourceId);
    }

    @RequestMapping(value={"/resourceAddSaveRole"})
    @BussinessLog(key="/casAppResourceFront/resourceAddSaveRole", type="01", value="\u4e1a\u52a1\u7cfb\u7edf-\u65b0\u589e\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58")
    @RequiresPermissions(value={"casAppResource:resourceAddSaveRole"})
    public ApiResponse<Tip> resourceAddSaveRole(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String applicationId = map.get("applicationId");
        String[] roleIds = map.get("roleIds").split(",");
        Date currentDate = new Date();
        String currentUser = ShiroKit.getUser().getAccount();
        ArrayList<CasAppRoleResource> sysRoleResourceList = new ArrayList<CasAppRoleResource>();
        for (String roleId : roleIds) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            CasAppRoleResource casAppRoleResource = new CasAppRoleResource();
            casAppRoleResource.setRoleId(roleId);
            casAppRoleResource.setResourceId(resourceId);
            casAppRoleResource.setCreateTime(currentDate);
            casAppRoleResource.setCreator(currentUser);
            casAppRoleResource.setLastEditor(currentUser);
            casAppRoleResource.setLastTime(currentDate);
            casAppRoleResource.setApplicationId(applicationId);
            sysRoleResourceList.add(casAppRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            this.casAppRoleResourceService.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
            this.abstractPushMsgMatcher.insertOperation("roleResource", "add", sysRoleResourceList, applicationId);
        }
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequiresPermissions(value={"casAppResource:resourceAdd"})
    @RequestMapping(value={"/resourceAdd"})
    @BussinessLog(key="/casAppResourceFront/resourceAdd", type="04", value="\u8d44\u6e90\u65b0\u589e")
    public ApiResponse<Map<String, Object>> resourceAdd(@RequestBody Map<String, String> map) {
        String functionId = map.get("functionId");
        String applicationId = map.get("applicationId");
        CasAppFunctions sysFunctions = this.casResManageService.getFunctionInfoById(functionId, applicationId);
        String functionCode = sysFunctions.getFunctionCode();
        String currentCode = this.sysIdtableService.getCurrentCode("resource_code", "sys_resources");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        List resTypes = this.sysDicRefService.getDictByType("res_type");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("currentCode", functionCode + currentCode);
        dataMap.put("resTypes", resTypes);
        return ApiResponse.data(dataMap);
    }

    @RequestMapping(value={"/sameUrl"})
    @RequiresPermissions(value={"casAppResource:sameUrl"})
    @BussinessLog(key="/casAppResourceFront/sameUrl", type="04", value="\u67e5\u8be2\u662f\u5426\u5df2\u6709url")
    public ApiResponse<List<CasAppResources>> sameUrl(@RequestBody Map<String, String> map) {
        String url = map.get("url");
        String applicationId = map.get("applicationId");
        CasAppResources sysResources = new CasAppResources();
        sysResources.setFunctionId(null);
        List<CasAppResources> list = this.casAppResourcesMapper.sameUrl(url, applicationId);
        return ApiResponse.data(list);
    }

    @RequiresPermissions(value={"casAppResource:resourceEditSave"})
    @RequestMapping(value={"/resourceEditSave"})
    @BussinessLog(key="/casAppResourceFront/resourceEditSave", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90", pk="resourceId")
    public ApiResponse<String> resourceEditSave(@RequestBody CasAppResources casAppResources) {
        if ("1".equals(casAppResources.getResTypeId())) {
            casAppResources.setIsRepeatAuthenticate("0");
        }
        return ApiResponse.data((Object)this.casResManageService.resourceSave(casAppResources));
    }

    @RequestMapping(value={"/resourceEditSaveRole"})
    @BussinessLog(key="/casAppResourceFront/resourceEditSaveRole", type="01", value="\u4e1a\u52a1\u7cfb\u7edf-\u4fee\u6539\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58")
    @RequiresPermissions(value={"casAppResource:resourceEditSaveRole"})
    public ApiResponse<Tip> resourceEditSaveRole(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String applicationId = map.get("applicationId");
        String[] roleIds = map.get("roleIds").split(",");
        this.casAppRoleResourceService.resourceEditSaveRole(resourceId, roleIds, applicationId);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/resourceView"})
    @RequiresPermissions(value={"casAppResource:resourceView"})
    @BussinessLog(key="/casAppResourceFront/resourceView", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u4fe1\u606f")
    public ApiResponse<Map<String, Object>> resourceView(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String applicationId = map.get("applicationId");
        CasAppResources result = this.casResManageService.getResourceInfoById(resourceId, applicationId);
        List resTypes = this.sysDicRefService.getDictByType("res_type");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("resTypes", resTypes);
        dataMap.put("casAppResources", (Object)result);
        return ApiResponse.data(dataMap);
    }

    @RequestMapping(value={"/getResourceRoles"})
    @BussinessLog(key="/casAppResourceFront/getResourceRoles", type="04", value="\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272")
    public ApiResponse<List<CasAppRoleResource>> getResourceRoles(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String applicationId = map.get("applicationId");
        List casAppRoleResources = this.casAppRoleResourceService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"resource_id", (Object)resourceId)).eq((Object)"application_id", (Object)applicationId));
        return ApiResponse.data((Object)casAppRoleResources);
    }

    @RequestMapping(value={"/roleTreeView"})
    @RequiresPermissions(value={"casAppResource:roleTreeView"})
    @BussinessLog(key="/casAppResourceFront/roleTreeView", type="04", value="\u83b7\u53d6\u67d0\u4e2a\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272\u6811")
    public ApiResponse<List<JSTreeModel>> getRoleTreeView(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String applicationId = map.get("applicationId");
        List roleResourceList = this.casAppRoleResourceService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"RESOURCE_ID", (Object)resourceId));
        if (ToolUtil.isEmpty((Object)roleResourceList)) {
            ArrayList<JSTreeModel> emptyList = new ArrayList<JSTreeModel>();
            JSTreeModel model = new JSTreeModel();
            model.setId("1");
            model.setCode("GROUP");
            model.setParent("#");
            model.setText("\u5173\u8054\u89d2\u8272");
            model.setType("isRoot");
            model.setState(false, false, true);
            emptyList.add(model);
            return ApiResponse.data(ForestNodeMerger.merge(emptyList));
        }
        ArrayList<String> roleIds = new ArrayList<String>();
        for (CasAppRoleResource roleResource : roleResourceList) {
            roleIds.add(roleResource.getRoleId());
        }
        List<JSTreeModel> result = this.casAppRolesService.selfRoleTree(roleIds.toArray(new String[roleIds.size()]), applicationId);
        List<JSTreeModel> tree = this.getRoleTree(result);
        block1: for (JSTreeModel js : tree) {
            for (String id : roleIds) {
                if (ToolUtil.equals((Object)js.getId(), (Object)id)) {
                    js.setState(true, true, true);
                    continue block1;
                }
                js.setState(false, false, true);
            }
        }
        return ApiResponse.data(ForestNodeMerger.merge(tree));
    }

    private List<JSTreeModel> getRoleTree(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursiveRoleTree(list, result, "");
        JSTreeModel model = new JSTreeModel();
        model.setId("1");
        model.setCode("GROUP");
        model.setParent("#");
        model.setText("\u5173\u8054\u89d2\u8272");
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    private void recursiveRoleTree(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (i < 0) break;
            JSTreeModel map = list.get(i);
            if (!"ROLE".equals(map.getCode()) && !parentId.equals(map.getId())) continue;
            parentId = map.getParent();
            result.add(map);
            list.remove(i);
            this.recursiveRoleTree(list, result, parentId);
        }
    }
}

