/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.frontcontroller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.cas.system.model.CasAppMenu;
import com.jxdinfo.hussar.cas.system.service.ICasAppMenuService;
import com.jxdinfo.hussar.cas.util.ForestNodeMerger;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/casAppMenuFront"})
public class CasAppMenuFrontController
extends BaseController {
    @Resource
    private ICasAppMenuService casAppMenuService;
    @Resource
    private ISysDicRefService iSysDicRefService;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @RequiresPermissions(value={"casAppMenu:menuTree"})
    @RequestMapping(value={"/menuTree"})
    @BussinessLog(key="/casAppMenuFront/menuTree", type="04", value="\u52a0\u8f7d\u83dc\u5355\u6811")
    public ApiResponse<List<JSTreeModel>> menuTree(@RequestBody Map<String, Object> map) {
        String applicationId = map.get("applicationId").toString();
        List<JSTreeModel> result = this.casAppMenuService.getMenuTree(applicationId);
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setText("\u83dc\u5355\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @BussinessLog(key="/casAppMenuFront/menuInfoSave", type="01", value="\u4e1a\u52a1\u7cfb\u7edf-\u65b0\u589e\u83dc\u5355", pk="menuId")
    @RequiresPermissions(value={"casAppMenu:menuInfoSave"})
    @RequestMapping(value={"/menuInfoSave"})
    public ApiResponse<Tip> menuInfoSave(@RequestBody CasAppMenu casAppMenu) {
        this.casAppMenuService.menuInfoSave(casAppMenu, casAppMenu.getApplicationId());
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"casAppMenu:menuInfoEditSave"})
    @RequestMapping(value={"/menuInfoEditSave"})
    @BussinessLog(key="/casAppMenuFront/menuInfoEditSave", type="03", value="\u83dc\u5355\u4fee\u6539\u4fdd\u5b58")
    public ApiResponse<Tip> menuInfoEditSave(@RequestBody CasAppMenu casAppMenu) {
        CasAppMenu result = this.casAppMenuService.getMenuInfo(casAppMenu.getMenuId(), casAppMenu.getApplicationId());
        LogObjectHolder.me().set((Object)result);
        this.casAppMenuService.menuInfoSave(casAppMenu, casAppMenu.getApplicationId());
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"casAppMenu:menuInfo"})
    @RequestMapping(value={"/menuInfo"})
    @BussinessLog(key="/casAppMenuFront/menuInfo", type="04", value="\u83dc\u5355\u4fe1\u606f\u9875\u9762\u8df3\u8f6c")
    public ApiResponse<Map> menuInfo(@RequestBody Map<String, String> body) {
        String menuId = body.get("menuId");
        String length = body.get("length");
        String applicationId = body.get("applicationId");
        HashMap<String, Object> map = new HashMap<String, Object>();
        CasAppMenu result = this.casAppMenuService.getMenuInfo(menuId, applicationId);
        map.put("menuInfo", (Object)result);
        map.put("length", length);
        map.put("openType", this.iSysDicRefService.getDictLabel("menu_type", result.getOpenType()));
        return ApiResponse.data(map);
    }

    @BussinessLog(key="/casAppMenuFront/delMenuById", type="02", value="\u4e1a\u52a1\u7cfb\u7edf-\u5220\u9664\u83dc\u5355", pk="menuId")
    @RequestMapping(value={"/delMenuById"})
    @RequiresPermissions(value={"casAppMenu:delMenuById"})
    public ApiResponse<Tip> delMenuById(@RequestBody Map<String, String> map) {
        String applicationId;
        String ids = map.get("menuIds") == null ? "" : map.get("menuIds");
        List<String> menuIds = Arrays.asList(ids.split(","));
        String string = applicationId = map.get("applicationId") == null ? "" : map.get("applicationId");
        if (this.casAppMenuService.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).in((Object)"MENU_ID", menuIds))) {
            this.abstractPushMsgMatcher.insertOperation("menu", "delete", menuIds, applicationId);
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"casAppMenu:menuTreeById"})
    @RequestMapping(value={"/menuTreeById"})
    @BussinessLog(key="/casAppMenuFront/menuTreeById", type="04", value="\u6839\u636e\u7236ID\u83b7\u53d6\u4e0b\u7ea7\u83dc\u5355\u6811", pk="menuId")
    public ApiResponse<List<JSTreeModel>> menuTreeById(@RequestBody Map<String, Object> map) {
        String menuId = map.get("menuId") == null ? null : map.get("menuId").toString();
        String isHead = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        String applicationId = map.get("applicationId") == null ? null : map.get("applicationId").toString();
        Boolean isRoot = Boolean.valueOf(isHead);
        List<JSTreeModel> result = this.casAppMenuService.menuTreeById(menuId, applicationId);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("1");
            root.setText("\u83dc\u5355\u5217\u8868");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/menuTreeOrder"})
    @RequiresPermissions(value={"casAppMenu:menuTreeOrder"})
    @BussinessLog(key="/casAppMenuFront/menuTreeOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u6811\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Tip> menuTreeOrder(@RequestBody Map<String, String> map) {
        String treeInfo = map.get("treeInfo");
        String applicationId = map.get("applicationId");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        JSONObject json = new JSONObject();
        ArrayList<CasAppMenu> list = new ArrayList<CasAppMenu>();
        for (int i = 0; i < treeArr.size(); ++i) {
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasAppMenu sm = new CasAppMenu();
            sm.setMenuId(id);
            sm.setSeq(Integer.parseInt(order));
            sm.setApplicationId(applicationId);
            list.add(sm);
            this.casAppMenuService.update((Object)sm, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"MENU_ID", (Object)id));
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.abstractPushMsgMatcher.insertOperation("menu", "update", list, applicationId);
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/menuTreeChange"})
    @RequiresPermissions(value={"casAppMenu:menuTreeChange"})
    @BussinessLog(key="/casAppMenuFront/menuTreeChange", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u6811\u8f6c\u79fb")
    public ApiResponse<Tip> menuTreeChange(@RequestBody Map<String, String> map) {
        String menuId = map.get("menuId");
        String parentId = map.get("parentId");
        String applicationId = map.get("applicationId");
        this.casAppMenuService.menuTreeChange(menuId, parentId, applicationId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/singleMove"})
    @RequiresPermissions(value={"casAppMenu:singleMove"})
    @BussinessLog(key="/casAppMenuFront/singleMove", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u6811\u4e0a\u79fb/\u4e0b\u79fb")
    public ApiResponse<Object> updateMoveNode(@RequestBody Map<String, Object> map) {
        String applicationId;
        String menuId = map.get("menuId") == null ? null : map.get("menuId").toString();
        boolean isUp = map.get("isUp") == null ? null : Boolean.valueOf(map.get("isUp").toString().equals("true"));
        String string = applicationId = map.get("applicationId") == null ? null : map.get("applicationId").toString();
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.casAppMenuService.updateMoveNode(menuId, isUp, applicationId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/exportMenu"})
    @RequiresPermissions(value={"casAppMenu:exportMenu"})
    @BussinessLog(key="/casAppMenuFront/exportMenu", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String menuIds = super.getPara("menuIds");
        String applicationId = super.getPara("applicationId");
        List<String> menuIdList = Arrays.asList(menuIds.split(","));
        this.casAppMenuService.exportMenu(menuIdList, applicationId, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @RequiresPermissions(value={"casAppMenu:importData"})
    @BussinessLog(key="/casAppMenuFront/importData", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u5bfc\u5165")
    public ApiResponse<Tip> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        Tip result = this.casAppMenuService.importMenu(content);
        return ApiResponse.success((int)result.getCode(), (String)result.getMessage());
    }
}

