/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.controller;

import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.cas.system.dao.CasAppUserRoleMapper;
import com.jxdinfo.hussar.cas.system.service.ICasAppUserRoleService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CasUserUtil {
    @Autowired
    private ISysUsersService iSysUsersService;
    @Resource
    private CasAppUserRoleMapper casAppUserRoleMapper;
    @Resource
    private ICasAppUserRoleService casAppUserRoleService;

    public List<JSTreeModel> getUserByRole(String roleId) {
        List list = this.iSysUsersService.getUserTreeByRole(roleId);
        List<JSTreeModel> retList = this.computUserByRole(list);
        this.listOrder(retList);
        return retList;
    }

    public List<JSTreeModel> getLazyUserByRole(String roleId, String nodeId, String applicationId) {
        ArrayList<JSTreeModel> jsTreeModels = new ArrayList<JSTreeModel>();
        if (nodeId.equals("#")) {
            nodeId = "11";
            JSTreeModel root = new JSTreeModel();
            root.setId("11");
            root.setCode("11");
            root.setText("\u5173\u8054\u7528\u6237");
            root.setParent("#");
            root.setType("isRoot");
            jsTreeModels.add(root);
        }
        List<JSTreeModel> list = this.casAppUserRoleService.getLazyUserTreeByRole(roleId, applicationId);
        ArrayList<JSTreeModel> retList = new ArrayList<JSTreeModel>(this.computUserByRole(list));
        for (JSTreeModel jsTreeModel : retList) {
            if (!jsTreeModel.getParent().equals(nodeId)) continue;
            jsTreeModels.add(jsTreeModel);
        }
        this.listOrder(jsTreeModels);
        for (JSTreeModel model : jsTreeModels) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return jsTreeModels;
    }

    public List<JSTreeModel> getCasUserByRole(String roleId, String nodeId, String applicationId) {
        List<JSTreeModel> jsTreeModels = this.casAppUserRoleService.getCasUserTreeByRole(roleId, applicationId);
        if (nodeId.equals("#")) {
            nodeId = "11";
            JSTreeModel root = new JSTreeModel();
            root.setId("11");
            root.setCode("11");
            root.setText("\u5173\u8054\u7528\u6237");
            root.setParent("#");
            root.setType("isRoot");
            jsTreeModels.add(root);
        }
        for (JSTreeModel model : jsTreeModels) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return jsTreeModels;
    }

    private List<JSTreeModel> computUserByRole(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> resultList = new ArrayList<JSTreeModel>();
        this.computeUserRecursion(list, resultList, "");
        return resultList;
    }

    private void computeUserRecursion(List<JSTreeModel> listData, List<JSTreeModel> resultList, String pId) {
        for (int i = 0; i < listData.size(); ++i) {
            JSTreeModel tmp;
            if (i > listData.size()) {
                i = 0;
            }
            if (!"USER".equals((tmp = listData.get(i)).getType()) && !pId.equals(tmp.getId())) continue;
            resultList.add(tmp);
            listData.remove(tmp);
            this.computeUserRecursion(listData, resultList, tmp.getParent());
        }
    }

    private void listOrder(List<JSTreeModel> list) {
        Collections.sort(list, new Comparator<JSTreeModel>(){

            @Override
            public int compare(JSTreeModel o1, JSTreeModel o2) {
                if (CasUserUtil.this.formateObj(o1.getFirstOrder()).compareTo(CasUserUtil.this.formateObj(o2.getFirstOrder())) == 0) {
                    if (CasUserUtil.this.formateObj(o1.getStruLevel()).compareTo(CasUserUtil.this.formateObj(o2.getStruLevel())) == 0) {
                        if (CasUserUtil.this.formateObj(o1.getStruOrder()).compareTo(CasUserUtil.this.formateObj(o2.getStruOrder())) == 0) {
                            return CasUserUtil.this.formateObj(o1.getText()).compareTo(CasUserUtil.this.formateObj(o2.getText()));
                        }
                        return CasUserUtil.this.formateObj(o1.getStruOrder()).compareTo(CasUserUtil.this.formateObj(o2.getStruOrder()));
                    }
                    return CasUserUtil.this.formateObj(o1.getStruLevel()).compareTo(CasUserUtil.this.formateObj(o2.getStruLevel()));
                }
                return CasUserUtil.this.formateObj(o1.getFirstOrder()).compareTo(CasUserUtil.this.formateObj(o2.getFirstOrder()));
            }
        });
    }

    private String formateObj(Object object) {
        return object == null ? "" : object.toString();
    }
}

