/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.messagepush.config;

import com.jxdinfo.hussar.cas.messagepush.ServerListenerAck;
import com.jxdinfo.hussar.cas.messagepush.config.DirectRabbitConfig;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="cas", name={"active-type"}, havingValue="CASServer", matchIfMissing=false)
public class ServerMessageListenerConfig {
    @Autowired
    private CachingConnectionFactory connectionFactory;
    @Autowired
    public ServerListenerAck serverListenerAck;
    @Autowired
    DirectRabbitConfig directRabbitConfig;

    @Bean
    public SimpleMessageListenerContainer simpleMessageListenerContainer() {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer((ConnectionFactory)this.connectionFactory);
        container.setConcurrentConsumers(1);
        container.setMaxConcurrentConsumers(1);
        container.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        container.setQueues(new Queue[]{this.directRabbitConfig.DirectQueueAck()});
        container.setMessageListener((MessageListener)this.serverListenerAck);
        return container;
    }
}

