/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.sync.controller;

import com.jxdinfo.hussar.bpm.sync.service.IBpmSyncMessageFailService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/bpmSync"})
public class BpmSyncController
extends BaseController {
    @Autowired
    private IBpmSyncMessageFailService bpmSyncMessageFailService;
    private static String PREFIX = "/bpm/sync/";

    @BussinessLog(key="/bpmSync/view", type="04", value="\u5de5\u4f5c\u6d41-\u6570\u636e\u540c\u6b65\u5931\u8d25\u9875\u9762")
    @RequiresPermissions(value={"bpmSync:view"})
    @RequestMapping(value={"/view"})
    public String index() {
        return PREFIX + "syncFail.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Map<String, Object> list() {
        int curr = Integer.parseInt(super.getPara("curr"));
        int nums = Integer.parseInt(super.getPara("nums"));
        if (ToolUtil.isEmpty((Object)curr) || ToolUtil.isEmpty((Object)nums)) {
            return null;
        }
        return this.bpmSyncMessageFailService.getBpmSyncFailList(curr, nums);
    }

    @RequestMapping(value={"/sendFailInfo"})
    @ResponseBody
    public boolean pushFail() {
        String ids = super.getPara("failId");
        this.bpmSyncMessageFailService.pushFail(ids);
        return true;
    }
}

