/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.messagepush.config;

import com.jxdinfo.hussar.bpm.messagepush.util.ShiroBpmConfiguration;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="bpm", name={"send-message"}, havingValue="true", matchIfMissing=false)
public class BpmDirectRabbitConfig {
    @Autowired
    private ShiroBpmConfiguration shiroBpmConfiguration;

    @Bean
    public Queue DirectQueueAck() {
        return new Queue(this.shiroBpmConfiguration.getQueue(), true);
    }

    @Bean
    DirectExchange DirectExchangeAck() {
        return new DirectExchange(this.shiroBpmConfiguration.getExchange());
    }

    @Bean
    Binding bindingDirectAck() {
        return BindingBuilder.bind((Queue)this.DirectQueueAck()).to(this.DirectExchangeAck()).with(this.shiroBpmConfiguration.getRouteKey());
    }
}

