/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.cas.cassync.dao.CasSyncMessageFailMapper;
import com.jxdinfo.hussar.cas.cassync.dao.CasSyncMessageMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppFunctionsMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppMenuMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppModulesMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppResourcesMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppRoleGroupMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppRoleResourceMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppRolesMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppUserRoleMapper;
import com.jxdinfo.hussar.cas.system.dao.CasApplicationGroupMapper;
import com.jxdinfo.hussar.cas.system.dao.CasApplicationMapper;
import com.jxdinfo.hussar.cas.system.model.CasApplication;
import com.jxdinfo.hussar.cas.system.model.CasApplicationGroup;
import com.jxdinfo.hussar.cas.system.service.ICasApplicationGroupService;
import com.jxdinfo.hussar.cas.system.service.ICasApplicationService;
import com.jxdinfo.hussar.cas.system.vo.CasApplicationVo;
import com.jxdinfo.hussar.cas.util.SplitStrUtil;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.HussarHttpRequest;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.encrypt.util.SM3Util;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CasApplicationServiceImpl
extends ServiceImpl<CasApplicationMapper, CasApplication>
implements ICasApplicationService {
    @Resource
    private CasApplicationMapper casApplicationMapper;
    @Resource
    private CasApplicationGroupMapper casApplicationGroupMapper;
    @Resource
    private ICasApplicationGroupService casApplicationGroupService;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private RabbitAdmin rabbitAdmin;
    @Resource
    private CasAppMenuMapper casAppMenuMapper;
    @Resource
    private CasAppResourcesMapper casAppResourcesMapper;
    @Resource
    private CasAppUserRoleMapper casAppUserRoleMapper;
    @Resource
    private CasAppRoleResourceMapper casAppRoleResourceMapper;
    @Resource
    private CasAppRolesMapper casAppRolesMapper;
    @Resource
    private CasAppFunctionsMapper casAppFunctionsMapper;
    @Resource
    private CasAppModulesMapper casAppModulesMapper;
    @Resource
    private CasAppRoleGroupMapper casAppRoleGroupMapper;
    @Resource
    private CasSyncMessageMapper casSyncMessageMapper;
    @Resource
    private CasSyncMessageFailMapper casSyncMessageFailMapper;

    @Override
    public List<JSTreeModel> getLazyCasTree(String nodeId) {
        ArrayList<JSTreeModel> jsTreeModels = new ArrayList();
        if (nodeId.equals("#")) {
            jsTreeModels = this.casApplicationGroupMapper.getFirstCasTree();
            JSTreeModel jsTreeModel = new JSTreeModel();
            jsTreeModel.setParent("#");
            jsTreeModel.setCode("GROUP");
            jsTreeModel.setText("\u4e1a\u52a1\u7cfb\u7edf");
            jsTreeModel.setId("1");
            jsTreeModel.setType("isRoot");
            jsTreeModels.add(jsTreeModel);
        } else {
            jsTreeModels = this.casApplicationGroupMapper.getLazyCasTree(nodeId);
        }
        return jsTreeModels;
    }

    @Override
    public String addCas(Map<String, String> map) {
        String applicationName = map.get("applicationName");
        String applicationUrl = map.get("applicationUrl");
        String groupId = map.get("groupId");
        String isHussar = map.get("isHussar");
        List casList = this.list((Wrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)groupId));
        int order = 1;
        if (casList.size() != 0) {
            order = this.casApplicationMapper.getMaxOrder(groupId);
        }
        CasApplication casApplication = new CasApplication();
        casApplication.setApplicationId(null);
        casApplication.setApplicationName(applicationName);
        casApplication.setApplicationUrl(applicationUrl);
        String token = this.abstractOTPCredentialsMatcher.getRandomSecretBase32();
        casApplication.setApplicationToken(token);
        casApplication.setGroupId(groupId);
        casApplication.setIsHussar(isHussar);
        casApplication.setApplicationOrder(order);
        casApplication.setApplicationStatus(null);
        casApplication.setCreateTime(new Date());
        casApplication.setLastTime(new Date());
        casApplication.setCreator(ShiroKit.getUser().getId());
        this.casApplicationMapper.insert((Object)casApplication);
        SplitStrUtil splitStrUtil = new SplitStrUtil();
        Object striArray = splitStrUtil.getStriArray(token);
        if (!ToolUtil.isEmpty((Object)striArray)) {
            Map strMap = (Map)striArray;
            String routingkey = "routingKey" + (String)strMap.get("routingkey");
            String exchange = "exchange" + (String)strMap.get("exchange");
            String queue = "queue" + (String)strMap.get("queue");
            DirectExchange exchange1 = this.createExchange(exchange);
            this.addExchange((AbstractExchange)exchange1);
            Queue delayQueue = this.createQueue(queue);
            this.addQueue(delayQueue);
            this.addBinding(delayQueue, exchange1, routingkey);
        }
        return casApplication.getApplicationId();
    }

    @Override
    public boolean editCas(Map<String, String> map) {
        String applicationId = map.get("applicationId");
        String applicationName = map.get("applicationName");
        String applicationUrl = map.get("applicationUrl");
        CasApplication casApplication = new CasApplication();
        casApplication.setApplicationId(applicationId);
        casApplication.setApplicationName(applicationName);
        casApplication.setApplicationUrl(applicationUrl);
        casApplication.setLastTime(new Date());
        casApplication.setLastEditor(ShiroKit.getUser().getId());
        Integer num = this.casApplicationMapper.updateById((Object)casApplication);
        return num != 0;
    }

    @Override
    @Transactional(rollbackFor={SQLException.class})
    public boolean delCas(String applicationId) {
        Integer num = this.casApplicationMapper.deleteById((Serializable)((Object)applicationId));
        if (num == 0) {
            return false;
        }
        this.casSyncMessageFailMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casSyncMessageMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casAppRoleResourceMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casAppUserRoleMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casAppRolesMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casAppRoleGroupMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casAppMenuMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casAppResourcesMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casAppFunctionsMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        this.casAppModulesMapper.delete((Wrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId));
        return true;
    }

    @Override
    public List<JSTreeModel> getCasOrderTree(String parent) {
        List<JSTreeModel> result = this.casApplicationGroupMapper.getCasOrderTree(parent);
        JSTreeModel root = new JSTreeModel();
        CasApplicationGroup group = (CasApplicationGroup)((Object)this.casApplicationGroupMapper.selectById((Serializable)((Object)parent)));
        root.setParent("#");
        root.setCode("GROUP");
        root.setText(group.getGroupName());
        root.setId(group.getGroupId());
        root.setType("GROUP");
        result.add(root);
        return result;
    }

    @Override
    public boolean saveCasOrder(JSONArray treeArr) {
        ArrayList<CasApplication> list = new ArrayList<CasApplication>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasApplication casApplication = new CasApplication();
            casApplication.setApplicationId(id);
            if (ToolUtil.isNotEmpty((Object)order)) {
                casApplication.setApplicationOrder(Integer.parseInt(order));
            } else {
                casApplication.setApplicationOrder(1);
            }
            list.add(casApplication);
        }
        return ToolUtil.isNotEmpty(list) && super.updateBatchById(list, list.size());
    }

    @Override
    public Object addGroup(String groupName) {
        CasApplicationGroup casApplicationGroup = new CasApplicationGroup();
        List groupList = this.casApplicationGroupService.list((Wrapper)new QueryWrapper());
        int order = 1;
        if (groupList.size() != 0) {
            order = this.casApplicationGroupMapper.getMaxOrder();
        }
        casApplicationGroup.setGroupId(null);
        casApplicationGroup.setGroupName(groupName);
        casApplicationGroup.setGroupOrder(order);
        casApplicationGroup.setCreateTime(new Date());
        casApplicationGroup.setCreator(ShiroKit.getUser().getId());
        Integer count = this.casApplicationGroupMapper.insert((Object)casApplicationGroup);
        if (count == 1) {
            return casApplicationGroup.getGroupId();
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @Override
    public Integer editGroup(String groupName, String groupId) {
        CasApplicationGroup casApplicationGroup = new CasApplicationGroup();
        casApplicationGroup.setGroupId(groupId);
        casApplicationGroup.setGroupName(groupName);
        casApplicationGroup.setLastEditor(ShiroKit.getUser().getAccount());
        casApplicationGroup.setLastTime(new Date());
        Integer count = this.casApplicationGroupMapper.updateById((Object)casApplicationGroup);
        return count;
    }

    @Override
    public List<JSTreeModel> getGroupOrderTree() {
        List<JSTreeModel> result = this.casApplicationGroupMapper.getGroupOrderTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent("#");
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u4e1a\u52a1\u7cfb\u7edf");
        jsTreeModel.setId("1");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        return result;
    }

    @Override
    public boolean saveGroupOrder(JSONArray treeArr) {
        ArrayList<CasApplicationGroup> list = new ArrayList<CasApplicationGroup>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasApplicationGroup group = new CasApplicationGroup();
            group.setGroupId(id);
            if (ToolUtil.isNotEmpty((Object)order)) {
                group.setGroupOrder(Integer.parseInt(order));
            } else {
                group.setGroupOrder(1);
            }
            list.add(group);
        }
        return ToolUtil.isNotEmpty(list) && this.casApplicationGroupService.updateBatchById(list, list.size());
    }

    @Override
    public Page<CasApplicationVo> getCasList(Page<CasApplicationVo> page, String groupId) {
        page.setRecords(this.casApplicationMapper.getCasList(page, groupId));
        return page;
    }

    @Override
    public JSONObject getCasListVue(String page, String limit, String groupId) {
        JSONObject jsonObject = new JSONObject();
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
            List<CasApplicationVo> list = this.casApplicationMapper.getCasListVue(pages, groupId);
            jsonObject.put("count", (Object)pages.getTotal());
            jsonObject.put("data", list);
            jsonObject.put("code", (Object)0);
        } else {
            jsonObject.put("data", null);
            jsonObject.put("code", (Object)"500");
            jsonObject.put("msg", (Object)"\u53c2\u6570\u4e0d\u7b26");
            jsonObject.put("count", null);
        }
        return jsonObject;
    }

    @Override
    public boolean testOnline(CasApplication casApplication) {
        boolean ifOnline = false;
        String token = casApplication.getApplicationToken();
        String url = casApplication.getApplicationUrl();
        JSONObject json = new JSONObject();
        long nonce = RandomUtils.nextLong();
        json.put("nonce", (Object)nonce);
        Long timestamp = System.currentTimeMillis();
        json.put("timestamp", (Object)timestamp);
        json.put("signature", (Object)SM3Util.digest((String)String.valueOf(timestamp)));
        try {
            JSONObject result = HussarHttpRequest.sendPost((String)(url + "/casonline/check"), (JSONObject)json, (String)token);
            String code = result.getString("code");
            String message = result.getString("message");
            if ("200".equals(code) && String.valueOf(nonce).equals(message)) {
                casApplication.setApplicationStatus("1");
                ifOnline = true;
            } else {
                casApplication.setApplicationStatus("0");
            }
            this.casApplicationMapper.updateById((Object)casApplication);
        }
        catch (Exception e) {
            casApplication.setApplicationStatus("0");
            this.casApplicationMapper.updateById((Object)casApplication);
            e.printStackTrace();
        }
        return ifOnline;
    }

    private DirectExchange createExchange(String exchangeName) {
        return new DirectExchange(exchangeName, true, false);
    }

    private Queue createQueue(String queue) {
        return new Queue(queue, true);
    }

    private void addExchange(AbstractExchange exchange) {
        this.rabbitAdmin.declareExchange((Exchange)exchange);
    }

    private void addQueue(Queue queue) {
        this.rabbitAdmin.declareQueue(queue);
    }

    private void addBinding(Queue queue, DirectExchange exchange, String routingKey) {
        Binding binding = BindingBuilder.bind((Queue)queue).to(exchange).with(routingKey);
        this.rabbitAdmin.declareBinding(binding);
    }
}

