/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.cas.system.dao.CasApplicationGroupMapper;
import com.jxdinfo.hussar.cas.system.model.CasApplication;
import com.jxdinfo.hussar.cas.system.model.CasApplicationGroup;
import com.jxdinfo.hussar.cas.system.service.ICasApplicationService;
import com.jxdinfo.hussar.cas.system.vo.CasApplicationVo;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/casApplication"})
public class CasApplicationController
extends BaseController {
    private String PREFIX = "/system/casApplication/";
    @Autowired
    private ICasApplicationService casApplicationService;
    @Resource
    private CasApplicationGroupMapper casApplicationGroupMapper;

    @RequestMapping(value={"/view"})
    @BussinessLog(key="/casApplication/view", type="04", value="\u7edf\u4e00\u6743\u9650\u9875\u9762")
    @RequiresPermissions(value={"casApplication:view"})
    public String index() {
        return this.PREFIX + "casApplication.html";
    }

    @RequestMapping(value={"/lazyCasTree"})
    @RequiresPermissions(value={"casApplication:lazyCasTree"})
    @ResponseBody
    public List<JSTreeModel> lazyCasTree(String nodeId) {
        return this.casApplicationService.getLazyCasTree(nodeId);
    }

    @RequestMapping(value={"/casAddPage"})
    @RequiresPermissions(value={"casApplication:casAddPage"})
    public String casAddPage(HttpServletRequest request) {
        String groupId = super.getPara("id");
        CasApplicationGroup group = (CasApplicationGroup)((Object)this.casApplicationGroupMapper.selectById((Serializable)((Object)groupId)));
        if (group != null) {
            request.setAttribute("group", (Object)group.getGroupName());
        } else {
            request.setAttribute("group", (Object)"");
        }
        request.setAttribute("groupId", (Object)groupId);
        return this.PREFIX + "casAddPage.html";
    }

    @RequestMapping(value={"/addCas"})
    @BussinessLog(key="/casApplication/addCas", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf")
    @RequiresPermissions(value={"casApplication:addCas"})
    @ResponseBody
    public String addCas() {
        String applicationName = super.getPara("applicationName");
        String applicationUrl = super.getPara("applicationUrl");
        String groupId = super.getPara("groupId");
        String isHussar = super.getPara("isHussar");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("applicationName", applicationName);
        map.put("applicationUrl", applicationUrl);
        map.put("groupId", groupId);
        map.put("isHussar", isHussar);
        String applicationId = this.casApplicationService.addCas(map);
        return applicationId;
    }

    @RequestMapping(value={"/casEditPage"})
    @RequiresPermissions(value={"casApplication:casEditPage"})
    public String casEditPage(HttpServletRequest request) {
        String applicationId = super.getPara("id");
        QueryWrapper entityWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId);
        List casList = this.casApplicationService.list((Wrapper)entityWrapper);
        CasApplicationGroup group = (CasApplicationGroup)((Object)this.casApplicationGroupMapper.selectById((Serializable)((Object)((CasApplication)((Object)casList.get(0))).getGroupId())));
        if (group != null) {
            request.setAttribute("group", (Object)group.getGroupName());
        } else {
            request.setAttribute("group", (Object)"");
        }
        request.setAttribute("casList", (Object)casList);
        return this.PREFIX + "casEditPage.html";
    }

    @RequestMapping(value={"/editCas"})
    @BussinessLog(key="/casApplication/editCas", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf")
    @RequiresPermissions(value={"casApplication:editCas"})
    @ResponseBody
    public Tip editCas() {
        String applicationId = super.getPara("applicationId");
        String applicationName = super.getPara("applicationName");
        String applicationUrl = super.getPara("applicationUrl");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("applicationId", applicationId);
        map.put("applicationName", applicationName);
        map.put("applicationUrl", applicationUrl);
        QueryWrapper entityWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId);
        List casList = this.casApplicationService.list((Wrapper)entityWrapper);
        LogObjectHolder.me().set(casList.get(0));
        boolean flag = this.casApplicationService.editCas(map);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u4fdd\u5b58\u6210\u529f");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/delCas"})
    @BussinessLog(key="/casApplication/delCas", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf")
    @RequiresPermissions(value={"casApplication:delCas"})
    @ResponseBody
    public Tip delCas() {
        String applicationId = super.getPara("id");
        boolean flag = this.casApplicationService.delCas(applicationId);
        if (flag) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/casViewPage"})
    @BussinessLog(key="/casApplication/casViewPage", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u9875\u9762")
    @RequiresPermissions(value={"casApplication:casViewPage"})
    public String casViewPage(HttpServletRequest request) {
        String applicationId = super.getPara("id");
        QueryWrapper entityWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId);
        List casList = this.casApplicationService.list((Wrapper)entityWrapper);
        CasApplicationGroup group = (CasApplicationGroup)((Object)this.casApplicationGroupMapper.selectById((Serializable)((Object)((CasApplication)((Object)casList.get(0))).getGroupId())));
        if (group != null) {
            request.setAttribute("group", (Object)group.getGroupName());
        } else {
            request.setAttribute("group", (Object)"");
        }
        request.setAttribute("casList", (Object)casList);
        return this.PREFIX + "casViewPage.html";
    }

    @RequestMapping(value={"/casOrderTree"})
    @RequiresPermissions(value={"casApplication:casOrderTree"})
    @ResponseBody
    public List<JSTreeModel> casOrderTree() {
        String parent = super.getPara("parent");
        return this.casApplicationService.getCasOrderTree(parent);
    }

    @RequestMapping(value={"/saveCasOrder"})
    @BussinessLog(key="/casApplication/saveCasOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf\u6392\u5e8f")
    @RequiresPermissions(value={"casApplication:saveCasOrder"})
    @ResponseBody
    public Tip saveCasOrder() {
        String info = super.getPara("info");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.casApplicationService.saveCasOrder(treeArr);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/casGroupViewPage"})
    @BussinessLog(key="/casApplication/casGroupViewPage", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u4fe1\u606f")
    @RequiresPermissions(value={"casApplication:casGroupViewPage"})
    public String casGroupViewPage(HttpServletRequest request) {
        String nodeId = super.getPara("id");
        CasApplicationGroup group = (CasApplicationGroup)((Object)this.casApplicationGroupMapper.selectById((Serializable)((Object)nodeId)));
        request.setAttribute("group", (Object)group);
        return this.PREFIX + "casGroupViewPage.html";
    }

    @RequestMapping(value={"/casGroupPage"})
    @RequiresPermissions(value={"casApplication:casGroupPage"})
    public String casAddGroupPage(HttpServletRequest request) {
        String groupId = "";
        String type = super.getPara("type");
        String groupName = "";
        if (ToolUtil.equals((Object)"edit", (Object)type)) {
            groupId = super.getPara("id");
            CasApplicationGroup group = (CasApplicationGroup)((Object)this.casApplicationGroupMapper.selectById((Serializable)((Object)groupId)));
            groupName = group.getGroupName();
        }
        request.setAttribute("groupName", (Object)groupName);
        request.setAttribute("groupId", (Object)groupId);
        request.setAttribute("type", (Object)type);
        return this.PREFIX + "casGroupPage.html";
    }

    @RequestMapping(value={"/saveGroup"})
    @RequiresPermissions(value={"casApplication:saveGroup"})
    @ResponseBody
    public Object saveGroup() {
        String groupName = super.getPara("groupName");
        String type = super.getPara("type");
        String groupId = super.getPara("groupId");
        if (ToolUtil.equals((Object)"add", (Object)type)) {
            return this.casApplicationService.addGroup(groupName);
        }
        int count = this.casApplicationService.editGroup(groupName, groupId);
        CasApplicationGroup group = (CasApplicationGroup)((Object)this.casApplicationGroupMapper.selectById((Serializable)((Object)groupId)));
        groupName = group.getGroupName();
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("groupName", groupName);
        LogObjectHolder.me().set(map);
        if (count == 1) {
            return groupId;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/searchCasGroup"})
    @RequiresPermissions(value={"casApplication:searchCasGroup"})
    @ResponseBody
    public List<CasApplication> searchCasGroup() {
        String id = super.getPara("id");
        return this.casApplicationService.list((Wrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)id));
    }

    @RequestMapping(value={"/delGroup"})
    @BussinessLog(key="/casApplication/delGroup", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4")
    @RequiresPermissions(value={"casApplication:delGroup"})
    @ResponseBody
    public Tip delGroup() {
        String id = super.getPara("id");
        Integer count = this.casApplicationGroupMapper.deleteById((Serializable)((Object)id));
        if (count == 1) {
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/groupOrderTree"})
    @RequiresPermissions(value={"casApplication:groupOrderTree"})
    @ResponseBody
    public List<JSTreeModel> groupOrderTree() {
        return this.casApplicationService.getGroupOrderTree();
    }

    @RequestMapping(value={"/saveGroupOrder"})
    @BussinessLog(key="/casApplication/saveGroupOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf\u5206\u7ec4\u6392\u5e8f")
    @RequiresPermissions(value={"casApplication:saveGroupOrder"})
    @ResponseBody
    public Tip saveGroupOrder() {
        String info = super.getPara("info");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.casApplicationService.saveGroupOrder(treeArr);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/list_single"})
    @RequiresPermissions(value={"casApplication:list_single"})
    @ResponseBody
    public Map<String, Object> listSingle() {
        String pageNum = super.getPara("curr");
        String limitNum = super.getPara("nums");
        String groupId = super.getPara("id");
        if (ToolUtil.equals((Object)"1", (Object)groupId)) {
            groupId = "";
        }
        Page<CasApplicationVo> page = new Page<CasApplicationVo>((long)Integer.valueOf(pageNum).intValue(), (long)Integer.valueOf(limitNum).intValue());
        page = this.casApplicationService.getCasList(page, groupId);
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("count", page.getTotal());
        map.put("data", page.getRecords());
        map.put("code", 0);
        return map;
    }

    @RequestMapping(value={"/testOnline"})
    @RequiresPermissions(value={"casApplication:testOnline"})
    @ResponseBody
    public boolean testOnline() throws Exception {
        String applicationId = super.getPara("applicationId");
        CasApplication casApplication = (CasApplication)((Object)this.casApplicationService.getById((Serializable)((Object)applicationId)));
        boolean ifOnline = this.casApplicationService.testOnline(casApplication);
        return ifOnline;
    }
}

