/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.messagepush.config;

import com.jxdinfo.hussar.cas.messagepush.ClientListenerReceiver;
import com.jxdinfo.hussar.cas.messagepush.config.DirectRabbitConfig;
import com.jxdinfo.hussar.cas.util.SplitStrUtil;
import com.jxdinfo.hussar.config.cas.ShiroCasConfiguration;
import java.util.Map;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="cas", name={"active-type"}, havingValue="CASClient", matchIfMissing=false)
public class ClientMessageListenerConfig {
    @Autowired
    private CachingConnectionFactory connectionFactory;
    @Autowired
    public ClientListenerReceiver clientListenerReceiver;
    @Autowired
    DirectRabbitConfig directRabbitConfig;
    @Autowired
    private ShiroCasConfiguration shiroCasConfiguration;

    @Bean
    public SimpleMessageListenerContainer simpleMessageListenerContainer() {
        SplitStrUtil splitStrUtil = new SplitStrUtil();
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer((ConnectionFactory)this.connectionFactory);
        container.setConcurrentConsumers(1);
        container.setMaxConcurrentConsumers(1);
        container.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        Map map = (Map)splitStrUtil.getStriArray(this.shiroCasConfiguration.getClientToken());
        container.setQueues(new Queue[]{new Queue("queue" + map.get("queue"), true)});
        container.setMessageListener((MessageListener)this.clientListenerReceiver);
        return container;
    }
}

