/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.messagepush;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.cas.cassync.model.CasSyncMessageFail;
import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageFailService;
import com.rabbitmq.client.Channel;
import java.util.Date;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="cas", name={"active-type"}, havingValue="CASServer", matchIfMissing=false)
@RabbitListener(queues={"${cas.mq-prefix}QueueAck"})
public class ServerListenerAck
implements ChannelAwareMessageListener {
    @Autowired
    private ICasSyncMessageFailService casSyncMessageFailService;

    public void onMessage(Message message, Channel channel) throws Exception {
        long deliveryTag = message.getMessageProperties().getDeliveryTag();
        String msg = message.toString();
        String[] msgArray = msg.split("'");
        JSONObject object = JSONObject.parseObject((String)msgArray[1].trim());
        CasSyncMessageFail casSyncMessageFail = new CasSyncMessageFail();
        casSyncMessageFail.setCreateTime(new Date());
        casSyncMessageFail.setMessageContent(object.getString("messageData").getBytes());
        casSyncMessageFail.setApplicationId(object.getString("applicationId"));
        casSyncMessageFail.setFailReason(object.getString("fallReason").getBytes());
        casSyncMessageFail.setMessageStatus("0");
        casSyncMessageFail.setMessageId(object.getString("messageId"));
        casSyncMessageFail.setMessageOrder(this.casSyncMessageFailService.getMaxOrder());
        casSyncMessageFail.setCreator(object.getString("userId"));
        this.casSyncMessageFailService.save((Object)casSyncMessageFail);
        channel.basicAck(deliveryTag, true);
    }
}

