/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.cassync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.cas.cassync.dao.CasSyncMessageFailMapper;
import com.jxdinfo.hussar.cas.cassync.dao.CasSyncMessageMapper;
import com.jxdinfo.hussar.cas.cassync.model.CasSyncMessage;
import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageService;
import com.jxdinfo.hussar.cas.cassync.vo.PushCountVo;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CasSyncMessageServiceImpl
extends ServiceImpl<CasSyncMessageMapper, CasSyncMessage>
implements ICasSyncMessageService {
    @Resource
    private CasSyncMessageMapper casSyncMessageMapper;
    @Resource
    private CasSyncMessageFailMapper casSyncMessageFailMapper;
    @Autowired
    private DruidProperties druidProperties;

    @Override
    public void insertOperation(String type, String ProcessingMode, Object object, String applicationId) {
        CasSyncMessage casSyncMessage = new CasSyncMessage();
        casSyncMessage.setMessageStatus("0");
        casSyncMessage.setCreateTime(new Date());
        ShiroUser user = ShiroKit.getUser();
        casSyncMessage.setCreator(user.getId());
        casSyncMessage.setLastEditor(user.getId());
        casSyncMessage.setLastTime(new Date());
        JSONObject content = new JSONObject();
        content.put("type", (Object)type);
        content.put("ProcessingMode", (Object)ProcessingMode);
        content.put("content", object);
        casSyncMessage.setMessageContent(content.toString().getBytes());
        int order = this.casSyncMessageMapper.getMaxOrder();
        casSyncMessage.setMessageOrder(order + 1);
        casSyncMessage.setApplicationId(applicationId);
        this.casSyncMessageMapper.insert((Object)casSyncMessage);
    }

    @Override
    public void updatePushStatus(String messageId) {
        CasSyncMessage casSyncMessage = (CasSyncMessage)((Object)this.casSyncMessageMapper.selectById((Serializable)((Object)messageId)));
        casSyncMessage.setMessageStatus("1");
        this.casSyncMessageMapper.updateById((Object)casSyncMessage);
    }

    @Override
    public List<PushCountVo> getPushCountGroupClient(String userId) {
        List<PushCountVo> list = this.casSyncMessageMapper.getPushCountClient(userId);
        List<PushCountVo> listAll = this.casSyncMessageMapper.getPushCountAll(userId);
        ArrayList<PushCountVo> resultList = new ArrayList<PushCountVo>();
        int all = Integer.parseInt(listAll.get(0).getNum());
        for (PushCountVo pushCountVo : list) {
            int clientNum = Integer.parseInt(pushCountVo.getNum());
            pushCountVo.setNum(clientNum + all + "");
            resultList.add(pushCountVo);
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> getPushCount(String userId) {
        int fail;
        List<Map<String, Object>> list;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String dbUrl = this.druidProperties.getUrl();
        if (dbUrl.startsWith("jdbc:postgresql")) {
            List<Map<String, Object>> newList = this.casSyncMessageMapper.getPushCount(userId);
            list = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < newList.size(); ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Set<String> se = newList.get(i).keySet();
                for (String set : se) {
                    map.put(set.toUpperCase(), newList.get(i).get(set));
                }
                list.add(map);
            }
        } else {
            list = this.casSyncMessageMapper.getPushCount(userId);
        }
        if (list.size() > 0) {
            HashMap<String, Object> resultMap;
            int organ = 0;
            int person = 0;
            int user = 0;
            int role = 0;
            int resource = 0;
            int menu = 0;
            for (Map<String, Object> map1 : list) {
                try {
                    JSONObject json;
                    String type;
                    Blob blob;
                    String blobString = "";
                    if (map1.containsKey("CONTENT") && map1.get("CONTENT") != null) {
                        if ("class [B".equals(map1.get("CONTENT").getClass().toString())) {
                            blobString = new String((byte[])map1.get("CONTENT"));
                        } else {
                            blob = (Blob)map1.get("CONTENT");
                            blobString = new String(blob.getBytes(1L, (int)blob.length()), "UTF-8");
                        }
                    }
                    if (map1.containsKey("content") && map1.get("content") != null) {
                        if ("class [B".equals(map1.get("content").getClass().toString())) {
                            blobString = new String((byte[])map1.get("content"));
                        } else {
                            blob = (Blob)map1.get("content");
                            blobString = new String(blob.getBytes(1L, (int)blob.length()), "UTF-8");
                        }
                    }
                    if ("organ".equals(type = (json = JSONObject.parseObject((String)blobString)).getString("type")) || "sysOrganType".equals(type) || "sysStruRule".equals(type)) {
                        ++organ;
                        continue;
                    }
                    if ("person".equals(type)) {
                        ++person;
                        continue;
                    }
                    if ("user".equals(type)) {
                        ++user;
                        continue;
                    }
                    if ("role".equals(type) || "roleGroup".equals(type) || "userRole".equals(type)) {
                        ++role;
                        continue;
                    }
                    if ("resource".equals(type) || "functions".equals(type) || "modules".equals(type) || "roleResource".equals(type)) {
                        ++resource;
                        continue;
                    }
                    if (!"menu".equals(type)) continue;
                    ++menu;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (organ != 0) {
                resultMap = new HashMap<String, Object>();
                resultMap.put("type", "organ");
                resultMap.put("count", organ);
                result.add(resultMap);
            }
            if (person != 0) {
                resultMap = new HashMap();
                resultMap.put("type", "person");
                resultMap.put("count", person);
                result.add(resultMap);
            }
            if (user != 0) {
                resultMap = new HashMap();
                resultMap.put("type", "user");
                resultMap.put("count", user);
                result.add(resultMap);
            }
            if (resource != 0) {
                resultMap = new HashMap();
                resultMap.put("type", "resource");
                resultMap.put("count", resource);
                result.add(resultMap);
            }
            if (role != 0) {
                resultMap = new HashMap();
                resultMap.put("type", "role");
                resultMap.put("count", role);
                result.add(resultMap);
            }
            if (menu != 0) {
                resultMap = new HashMap();
                resultMap.put("type", "menu");
                resultMap.put("count", menu);
                result.add(resultMap);
            }
        }
        if ((fail = this.casSyncMessageFailMapper.getPushCount(userId)) != 0) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("type", "fail");
            resultMap.put("count", fail);
            result.add(resultMap);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, Object> getCasSyncList(String page, String limit, String creator, String applicationName) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            Set<String> se;
            List<Object> list;
            Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
            ArrayList<Map> resultlist = new ArrayList<Map>();
            String dbUrl = this.druidProperties.getUrl();
            if (dbUrl.startsWith("jdbc:postgresql")) {
                void var11_12;
                List<Map<String, Object>> newList = this.casSyncMessageMapper.getCasSyncList(pages, creator, applicationName);
                list = new ArrayList();
                boolean bl = false;
                while (var11_12 < newList.size()) {
                    HashMap<String, Object> ma = new HashMap<String, Object>();
                    se = newList.get((int)var11_12).keySet();
                    for (String set : se) {
                        ma.put(set.toUpperCase(), newList.get((int)var11_12).get(set));
                    }
                    list.add(ma);
                    ++var11_12;
                }
            } else if (dbUrl.startsWith("jdbc:oracle")) {
                void var11_14;
                List<Map<String, Object>> oracleList = this.casSyncMessageMapper.getCasSyncList(pages, creator, applicationName);
                list = new ArrayList();
                boolean bl = false;
                while (var11_14 < oracleList.size()) {
                    HashMap<String, Object> oracleMap = new HashMap<String, Object>();
                    se = oracleList.get((int)var11_14).keySet();
                    for (String set : se) {
                        oracleMap.put(set.toLowerCase(), oracleList.get((int)var11_14).get(set));
                    }
                    list.add(oracleMap);
                    ++var11_14;
                }
            } else {
                list = this.casSyncMessageMapper.getCasSyncList(pages, creator, applicationName);
            }
            if (list.size() != 0) {
                for (Map map2 : list) {
                    try {
                        String blobString = "";
                        if ("class [B".equals(map2.get("contents").getClass().toString())) {
                            blobString = new String((byte[])map2.get("contents"));
                        } else {
                            Blob blob = (Blob)map2.get("contents");
                            blobString = new String(blob.getBytes(1L, (int)blob.length()), "UTF-8");
                        }
                        JSONObject json = JSONObject.parseObject((String)blobString);
                        String contents = "type:" + json.getString("type") + "@ProcessingMode:" + json.getString("ProcessingMode");
                        map2.put("contents", contents);
                        resultlist.add(map2);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                list = resultlist;
            }
            map.put("count", pages.getTotal());
            map.put("data", list);
            map.put("code", 0);
            return map;
        }
        map.put("data", null);
        map.put("code", "500");
        map.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        map.put("count", null);
        return map;
    }
}

