/**
 * @Description: 定义数据同步脚本文件
 * @Author: liangdong
 * @Date: 2018/2/27.
 */
layui.use(['upload', 'jquery', 'layer', 'Hussar', 'HussarAjax', 'form', 'table', 'element'], function () {
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var table = layui.table;
    var upload = layui.upload;
    var element = layui.element;

    /**
     * 组织机构规则的单例
     */
    var dataSync = {
        id: "pushMsgTable",	//表格id
        seItem: null,		//选中的条目
        table: null,
        loading: null,
        layerIndex: -1,
        progress: null,
        total: -1
    };

    //数据导入
    var uploadInst = upload.render({
        elem: '#importInfo'
        ,
        url: Hussar.ctxPath + '/initialDataSync/casImpSysInfoByJsonFile?applicationToken=' + $("#applicationToken").val()
        ,
        before:function(){
            layer.open({
                type: 1,
                skin: 'confirm-class',
                area: ['700px', '18px'], //宽高
                closeBtn:0,
                title:0,
                fix: false, //不固定
                maxmin: false,
                shadeClose: false,
                shade: 0.4,
                content: $("#progressDiv"),
                success:function(){
                    dataSync.progress = window.setInterval(function () {
                        var ajax = new $ax(Hussar.ctxPath + "/initialDataSync/casImpSysInfoByJsonFileProgress",
                            function (data) {
                                element.progress('demo',data/9 * 100 + '%');
                            },
                            function (data) {

                            });
                        ajax.setAsync(true);
                        ajax.start();
                    }, 2000);
                }
            });
        }
        ,
        done: function (data) {
            if (data.code == "200") {
                window.parent.layer.msg("导入成功！");
                element.progress('demo','100%');
                window.clearInterval(dataSync.progress);
                window.location.reload();
            } else {
                layer.msg(data.message);
                layer.closeAll('page');
                window.clearInterval(dataSync.progress);
            }
        }
        ,
        error: function () {
            layer.msg("导入失败！");
            layer.closeAll('page');
            window.clearInterval(dataSync.progress);
        }
        ,
        accept: 'file'//允许上传的文件类型
    });

    //数据导出
    dataSync.expJsonInfo = function () {
        window.location.href = Hussar.ctxPath + "/initialDataSync/casExportSysInfoToJson";
    }

    //数据同步
    dataSync.pushSyncInfo = function () {
        if (dataSync.checkIds()) {
            var loadIndex = layer.load(1,{shade:[0.8,'#393D49']});
            var ajax = new $ax(Hussar.ctxPath + "/ServerController/sendSyncInfo",
                function (data) {
                    data = data || {};
                    if (data.code == 200) {
                        Hussar.success("操作成功！");
                        table.reload('pushMsgTable', {
                            page: {
                                curr: 1
                                // 重新从第 1 页开始
                            },
                            where: {
                                applicationName: $('#applicationName').val(),
                            },
                            encryptEnable: true //layui table 传输加密
                        });
                    } else {
                        Hussar.error("操作失败！（" + (data.message || '未知错误') + "）");
                    }
                    layer.close(loadIndex);
                },
                function (data) {
                    Hussar.error("操作失败！（" + (data.message || '未知错误') + "）");
                    layer.close(loadIndex);
             });
            ajax.set("messageIds", dataSync.seItem.join());
            ajax.setAsync(true);
            ajax.start();
        }else{
            Hussar.error("请按照时间顺序推送数据");
        }
    }

    /**
     * 初始化按钮事件
     */
    dataSync.initButtonEvent = function () {
        $("#export").click(function () {
            dataSync.expJsonInfo();
        });
        $("#pushSyncInfo").click(function () {
            dataSync.pushSyncInfo();
        });
        $('#search').on('click', function () {
            var applicationName = $('#applicationName');
            // 执行重载
            table.reload('pushMsgTable', {
                page: {
                    curr: 1
                    // 重新从第 1 页开始
                },
                where: {
                    applicationName: applicationName.val(),
                },
                encryptEnable: true //layui table 传输加密
            });
        });
    }

    /**
     * 选中多条结果
     */
    dataSync.checkIds = function () {
        var checkStatus = table.checkStatus('pushMsgTable'), data = checkStatus.data;
        var allStatus = layui.table.cache.pushMsgTable;
        var limitNum = $(".layui-laypage-limits").find("option:selected").val() //分页数目
        var currPage = $(".layui-laypage-em").next().html(); //当前页码值
        var totalPage;
        if (dataSync.total.count%limitNum == 0){
            totalPage = dataSync.total.count/limitNum;
        } else {
            totalPage = Math.trunc(dataSync.total.count/limitNum) + 1;
        }

        var ids = [];
        var rowIds = [];
        if (data.length != 0) {
            // 判断当前是否是最后一页
            if (currPage == totalPage){
                // 收集未选中的数据
                for (var i = 0; i < allStatus.length; i++){
                    var flag = false;
                    for (var j = 0; j < data.length; j ++){
                        if (allStatus[i].message_id == data[j].message_id){
                            flag = true;
                        }
                    }
                    if (!flag) {
                        rowIds.push(allStatus[i].create_time);
                    }
                }
                // 比较时间
                for (var i = 0; i < data.length; i++){
                    for (var j = 0; j < rowIds.length;j++) {
                        // 判断是否有时间相同的和时间靠后的
                        if ((data[i].create_time > rowIds[j]) || (data[i].create_time == rowIds[j])){
                            return false;
                        }
                    }
                }
            }else {
                return false;
            }

            for (var i = 0, l = data.length; i < l; i++) {
                var r = data[i];
                ids.push(r.message_id);
            }
        }

        dataSync.seItem = ids;
        return true;
    };

    /**
     * 初始化表格
     */
    dataSync.initTableView = function () {
        table.render({
            elem: '#pushMsgTable',
            url: Hussar.ctxPath + '/casSyncMessage/list',
            page: true,
            id: 'pushMsgTable',
            even: true,
            height: $("body").height() - $(".layui-form").outerHeight(true) - 26,
            request: {
                pageName: 'curr', //页码的参数名称，默认：page
                limitName: 'nums' //每页数据量的参数名，默认：limit
            },
            cols: [[
                {type: 'checkbox', width: 40},
                {type: 'numbers', title: '序号', align: 'center', width: 50},
                {field: 'contents', title: '消息类型', align: 'center', templet: showContent,},
                {field: 'application_name', title: '业务系统名称', align: 'center'},
                {field: 'creator', title: '创建人', align: 'center'},
                {field: 'create_time', title: '创建时间', align: 'center', templet: formatDate},
            ]],
            where: {
                applicationName: $('#applicationNmme').val()
            },
            done:function (count) {
                dataSync.total = count;
            },
            encryptEnable: true //layui table 传输加密
        });
    }

    function showContent(d) {
        var str = d.contents.split("@");
        var type = str[0].replace("type:", "");
        var ProcessingMode = str[1].replace("ProcessingMode:", "");
        if (type == "organ") {
            type = "组织机构";
        } else if (type == "user") {
            type = "用户";
        } else if (type == "person") {
            type = "人员";
        } else if (type == "functions") {
            type = "功能";
        } else if (type == "modules") {
            type = "模块";
        } else if (type == "resource") {
            type = "资源";
        } else if (type == "roleResource") {
            type = "资源角色";
        } else if (type == "roleGroup") {
            type = "角色分组";
        } else if (type == "menu") {
            type = "菜单";
        } else if (type == "userRole") {
            type = "人员角色";
        } else if (type == "role") {
            type = "角色";
        } else if (type == "sysOrganType") {
            type = "组织机构类型";
        } else if (type == "sysStruRule") {
            type = "组织机构规则";
        }
        if (ProcessingMode == "add") {
            ProcessingMode = "新增";
        } else if (ProcessingMode == "update") {
            ProcessingMode = "修改";
        } else {
            ProcessingMode = "删除";
        }
        return type + ProcessingMode;
    }


    function formatDate(d) {
        var timeStr = new Date(d.create_time);
        var year = timeStr.getFullYear();  //取得4位数的年份
        var month = timeStr.getMonth() + 1;  //取得日期中的月份，其中0表示1月，11表示12月
        if ((month + "").length == 1) {
            month = "0" + month;
        }
        var date = timeStr.getDate();      //返回日期月份中的天数（1到31）
        if ((date + "").length == 1) {
            date = "0" + date;
        }
        var hour = timeStr.getHours();     //返回日期中的小时数（0到23）
        if ((hour + "").length == 1) {
            hour = "0" + hour;
        }
        var minute = timeStr.getMinutes(); //返回日期中的分钟数（0到59）
        if ((minute + "").length == 1) {
            minute = "0" + minute;
        }
        var second = timeStr.getSeconds(); //返回日期中的秒数（0到59）
        if ((second + "").length == 1) {
            second = "0" + second;
        }
        return year + "-" + month + "-" + date + " " + hour + ":" + minute + ":" + second;
    }

    $(function () {
        dataSync.initTableView(); //初始化表格
        dataSync.initButtonEvent(); //初始化按钮事件
    });

});




