/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.messagepush.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.cas.cassync.model.CasSyncMessage;
import com.jxdinfo.hussar.cas.cassync.model.CasSyncMessageFail;
import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageFailService;
import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageService;
import com.jxdinfo.hussar.cas.system.model.CasApplication;
import com.jxdinfo.hussar.cas.system.service.ICasApplicationService;
import com.jxdinfo.hussar.cas.util.SplitStrUtil;
import com.jxdinfo.hussar.cas.websocket.server.WebSocketServer;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/ServerController"})
public class ServerController
extends BaseController {
    @Autowired
    private AmqpTemplate rabbitTemplate;
    @Resource
    private RabbitAdmin rabbitAdmin;
    @Autowired
    private ICasSyncMessageService casSyncMessageService;
    @Autowired
    private ICasApplicationService casApplicationService;
    @Autowired
    private ICasSyncMessageFailService casSyncMessageFailService;
    @Autowired
    private WebSocketServer webSocketServer;

    @RequestMapping(value={"/sendSyncInfo"})
    @RequiresPermissions(value={"ServerController:sendSyncInfo"})
    @ResponseBody
    public Object sendSyncInfo() {
        String messageIds = super.getPara("messageIds");
        String userId = ShiroKit.getUser().getId();
        if (messageIds == null || "".equals(messageIds)) {
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"message_status", (Object)"0");
            ew.eq((Object)"creator", (Object)userId);
            ew.orderByAsc((Object)"message_order");
            List list = this.casSyncMessageService.list((Wrapper)ew);
            for (CasSyncMessage casSyncMessage : list) {
                Object object = this.IntegratePushMessage(casSyncMessage);
                if (String.valueOf(object) == "") continue;
                return object;
            }
        } else {
            String[] messageIdArr = messageIds.split(",");
            for (int t = messageIdArr.length - 1; t >= 0; --t) {
                String messageId = messageIdArr[t];
                CasSyncMessage casSyncMessage = (CasSyncMessage)((Object)this.casSyncMessageService.getById((Serializable)((Object)messageId)));
                Object object = this.IntegratePushMessage(casSyncMessage);
                if (String.valueOf(object) == "") continue;
                return object;
            }
        }
        this.webSocketServer.onMessage(userId);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/sendSyncInfoAgain"})
    @RequiresPermissions(value={"ServerController:sendSyncInfoAgain"})
    @ResponseBody
    public Object sendSyncInfoAgain() {
        String messageIds = super.getPara("messageIds");
        if (messageIds == null || "".equals(messageIds)) {
            QueryWrapper ew = new QueryWrapper();
            String userId = ShiroKit.getUser().getId();
            ew.eq((Object)"creator", (Object)userId);
            ew.eq((Object)"message_status", (Object)"0");
            ew.orderByAsc((Object)"message_order");
            List list = this.casSyncMessageFailService.list((Wrapper)ew);
            for (CasSyncMessageFail casSyncMessageFail : list) {
                Object object = this.IntegratePushMessageFail(casSyncMessageFail);
                if (String.valueOf(object) == "") continue;
                return object;
            }
        } else {
            String[] messageIdArr = messageIds.split(",");
            for (int t = messageIdArr.length - 1; t >= 0; --t) {
                String messageId = messageIdArr[t];
                CasSyncMessageFail casSyncMessageFail = (CasSyncMessageFail)((Object)this.casSyncMessageFailService.getById((Serializable)((Object)messageId)));
                Object object = this.IntegratePushMessageFail(casSyncMessageFail);
                if (String.valueOf(object) == "") continue;
                return object;
            }
        }
        return SUCCESS_TIP;
    }

    private Object IntegratePushMessage(CasSyncMessage casSyncMessage) {
        JSONObject object = new JSONObject();
        object.put("messageId", (Object)casSyncMessage.getMessageId());
        object.put("messageData", (Object)new String(casSyncMessage.getMessageContent()));
        String applicationId = casSyncMessage.getApplicationId();
        object.put("applicationId", (Object)applicationId);
        object.put("userId", (Object)ShiroKit.getUser().getId());
        if ("".equals(applicationId) || applicationId == null) {
            List list1 = this.casApplicationService.list(null);
            for (CasApplication casApplication : list1) {
                object.put("applicationId", (Object)casApplication.getApplicationId());
                Object returnObj = this.pushToMq(casSyncMessage, null, object, casApplication);
                if (ToolUtil.isEmpty((Object)returnObj)) continue;
                return returnObj;
            }
        } else {
            CasApplication casApplication = (CasApplication)((Object)this.casApplicationService.getById((Serializable)((Object)applicationId)));
            Object returnObj = this.pushToMq(casSyncMessage, null, object, casApplication);
            if (!ToolUtil.isEmpty((Object)returnObj)) {
                return returnObj;
            }
        }
        return "";
    }

    private Object IntegratePushMessageFail(CasSyncMessageFail casSyncMessageFail) {
        JSONObject object = new JSONObject();
        object.put("messageId", (Object)casSyncMessageFail.getMessageId());
        object.put("messageData", (Object)new String(casSyncMessageFail.getMessageContent()));
        String applicationId = casSyncMessageFail.getApplicationId();
        object.put("applicationId", (Object)applicationId);
        object.put("userId", (Object)ShiroKit.getUser().getId());
        CasApplication casApplication = (CasApplication)((Object)this.casApplicationService.getById((Serializable)((Object)applicationId)));
        Object returnObj = this.pushToMq(null, casSyncMessageFail, object, casApplication);
        if (!ToolUtil.isEmpty((Object)returnObj)) {
            return returnObj;
        }
        return "";
    }

    private Object pushToMq(CasSyncMessage casSyncMessage, CasSyncMessageFail casSyncMessageFail, JSONObject object, CasApplication casApplication) {
        SplitStrUtil splitStrUtil = new SplitStrUtil();
        Object striArray = splitStrUtil.getStriArray(casApplication.getApplicationToken());
        if (!ToolUtil.isEmpty((Object)striArray)) {
            Map map = (Map)striArray;
            String routingkey = "routingKey" + (String)map.get("routingkey");
            String exchange = "exchange" + (String)map.get("exchange");
            String queue = "queue" + (String)map.get("queue");
            DirectExchange exchange1 = this.createExchange(exchange);
            this.addExchange((AbstractExchange)exchange1);
            Queue delayQueue = this.createQueue(queue);
            this.addQueue(delayQueue);
            this.addBinding(delayQueue, exchange1, routingkey);
            this.rabbitTemplate.convertAndSend(exchange, routingkey, (Object)object);
            if (!ToolUtil.isEmpty((Object)((Object)casSyncMessage))) {
                casSyncMessage.setMessageStatus("1");
                this.casSyncMessageService.updateById((Object)casSyncMessage);
            }
            if (!ToolUtil.isEmpty((Object)((Object)casSyncMessageFail))) {
                casSyncMessageFail.setMessageStatus("1");
                this.casSyncMessageFailService.updateById((Object)casSyncMessageFail);
            }
            return null;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5931\u8d25\uff01");
    }

    private DirectExchange createExchange(String exchangeName) {
        return new DirectExchange(exchangeName, true, false);
    }

    private Queue createQueue(String queue) {
        return new Queue(queue, true);
    }

    private void addExchange(AbstractExchange exchange) {
        this.rabbitAdmin.declareExchange((Exchange)exchange);
    }

    private void addQueue(Queue queue) {
        this.rabbitAdmin.declareQueue(queue);
    }

    private void addBinding(Queue queue, DirectExchange exchange, String routingKey) {
        Binding binding = BindingBuilder.bind((Queue)queue).to(exchange).with(routingKey);
        this.rabbitAdmin.declareBinding(binding);
    }
}

