/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.sync.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.messagepush.service.IBpmPushService;
import com.jxdinfo.hussar.bpm.sync.dao.BpmSyncMessageFailMapper;
import com.jxdinfo.hussar.bpm.sync.model.BpmSyncMessageFail;
import com.jxdinfo.hussar.bpm.sync.service.IBpmSyncMessageFailService;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmSyncMessageFailServiceImpl
extends ServiceImpl<BpmSyncMessageFailMapper, BpmSyncMessageFail>
implements IBpmSyncMessageFailService {
    @Resource
    BpmSyncMessageFailMapper bpmSyncMessageFailMapper;
    @Autowired
    private DruidProperties druidProperties;
    @Autowired
    private IBpmPushService bpmPushService;

    @Override
    public int getMaxOrder() {
        return this.bpmSyncMessageFailMapper.getMaxOrder() + 1;
    }

    @Override
    public Map<String, Object> getBpmSyncFailList(Integer page, Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (ToolUtil.isNotEmpty((Object)page) && ToolUtil.isNotEmpty((Object)limit)) {
            List<Map<String, Object>> list;
            Page pages = new Page((long)page.intValue(), (long)limit.intValue());
            ArrayList<Map<String, Object>> resultlist = new ArrayList<Map<String, Object>>();
            String dbUrl = this.druidProperties.getUrl();
            if (dbUrl.startsWith("jdbc:postgresql")) {
                List<Map<String, Object>> newList = this.bpmSyncMessageFailMapper.getBpmSyncFailList(pages);
                list = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < newList.size(); ++i) {
                    HashMap<String, Object> ma = new HashMap<String, Object>();
                    Set<String> se = newList.get(i).keySet();
                    for (String set : se) {
                        ma.put(set.toUpperCase(), newList.get(i).get(set));
                    }
                    list.add(ma);
                }
            } else {
                list = this.bpmSyncMessageFailMapper.getBpmSyncFailList(pages);
            }
            if (list.size() != 0) {
                for (Map<String, Object> map1 : list) {
                    try {
                        String blobString = "";
                        if ("class [B".equals(map1.get("contents").getClass().toString())) {
                            blobString = new String((byte[])map1.get("contents"));
                        } else {
                            Blob blob = (Blob)map1.get("contents");
                            blobString = new String(blob.getBytes(1L, (int)blob.length()), "UTF-8");
                        }
                        JSONObject json = JSONObject.parseObject((String)blobString);
                        String dataType = json.getString("dataType");
                        String operationType = json.getString("operationType");
                        map1.put("contents", json.toString());
                        String dataTypeName = "\u89e3\u6790\u9519\u8bef";
                        if (ToolUtil.equals((Object)"organ", (Object)dataType)) {
                            dataTypeName = "\u7ec4\u7ec7\u673a\u6784";
                        } else if (ToolUtil.equals((Object)"userRole", (Object)dataType)) {
                            dataTypeName = "\u7528\u6237\u89d2\u8272\u5173\u7cfb";
                        } else if (ToolUtil.equals((Object)"role", (Object)dataType)) {
                            dataTypeName = "\u89d2\u8272";
                        }
                        String operationTypeName = "\u89e3\u6790\u9519\u8bef";
                        if (ToolUtil.equals((Object)"delete", (Object)operationType)) {
                            operationTypeName = "\u5220\u9664";
                        } else if (ToolUtil.equals((Object)"add", (Object)operationType)) {
                            operationTypeName = "\u65b0\u589e";
                        } else if (ToolUtil.equals((Object)"update", (Object)operationType)) {
                            operationTypeName = "\u66f4\u65b0";
                        } else if (ToolUtil.equals((Object)"deleteByUserId", (Object)operationType)) {
                            operationTypeName = "\u6839\u636e\u7528\u6237id\u5220\u9664";
                        } else if (ToolUtil.equals((Object)"deleteByRoleId", (Object)operationType)) {
                            operationTypeName = "\u6839\u636e\u89d2\u8272id\u5220\u9664";
                        }
                        String type = dataTypeName + "-" + operationTypeName;
                        map1.put("type", type);
                        String blobReasonString = "";
                        if ("class [B".equals(map1.get("fail_reason").getClass().toString())) {
                            blobReasonString = new String((byte[])map1.get("fail_reason"));
                        } else {
                            Blob blobReason = (Blob)map1.get("fail_reason");
                            blobReasonString = new String(blobReason.getBytes(1L, (int)blobReason.length()), "UTF-8");
                        }
                        map1.put("fail_reason", blobReasonString);
                        resultlist.add(map1);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                list = resultlist;
            }
            map.put("count", pages.getTotal());
            map.put("data", list);
            map.put("code", 0);
            return map;
        }
        map.put("data", null);
        map.put("code", "500");
        map.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        map.put("count", null);
        return map;
    }

    @Override
    public void pushFail(String ids) {
        String[] failIdArray = ids.split(",");
        ArrayList failIdList = new ArrayList();
        Collections.addAll(failIdList, failIdArray);
        List list = this.bpmSyncMessageFailMapper.selectBatchIds(failIdList);
        for (BpmSyncMessageFail bpmSyncMessageFail : list) {
            String content = new String(bpmSyncMessageFail.getMessageContent());
            Map sendMap = (Map)JSON.parseObject((String)content, Map.class);
            this.bpmPushService.sendSyncInfo(sendMap.get("dataType").toString(), sendMap.get("operationType").toString(), sendMap.get("data"));
            bpmSyncMessageFail.setMessageStatus("1");
            this.bpmSyncMessageFailMapper.updateById((Object)bpmSyncMessageFail);
        }
    }
}

