/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.messagepush.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.messagepush.service.IBpmPushService;
import com.jxdinfo.hussar.bpm.messagepush.util.ShiroBpmConfiguration;
import javax.annotation.Resource;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmPushServiceImpl
implements IBpmPushService {
    @Autowired
    private AmqpTemplate rabbitTemplate;
    @Resource
    private RabbitAdmin rabbitAdmin;
    @Autowired
    private ShiroBpmConfiguration shiroBpmConfiguration;

    @Override
    public void sendSyncInfo(String type, String ProcessingMode, Object obj) {
        JSONObject object = new JSONObject();
        object.put("tenantId", (Object)this.shiroBpmConfiguration.getTenantId());
        object.put("tenantCipher", (Object)this.shiroBpmConfiguration.getTenantCipher());
        object.put("dataType", (Object)type);
        object.put("operationType", (Object)ProcessingMode);
        object.put("data", obj);
        JSONObject sendObject = new JSONObject();
        sendObject.put("data", (Object)object);
        String routeKey = this.shiroBpmConfiguration.getRouteKey();
        String exchange = this.shiroBpmConfiguration.getExchange();
        String queue = this.shiroBpmConfiguration.getQueue();
        DirectExchange exchange1 = this.createExchange(exchange);
        this.addExchange((AbstractExchange)exchange1);
        Queue delayQueue = this.createQueue(queue);
        this.addQueue(delayQueue);
        this.addBinding(delayQueue, exchange1, routeKey);
        this.rabbitTemplate.convertAndSend(exchange, routeKey, (Object)sendObject);
    }

    private DirectExchange createExchange(String exchangeName) {
        return new DirectExchange(exchangeName, true, false);
    }

    private Queue createQueue(String queue) {
        return new Queue(queue, true);
    }

    private void addExchange(AbstractExchange exchange) {
        this.rabbitAdmin.declareExchange((Exchange)exchange);
    }

    private void addQueue(Queue queue) {
        this.rabbitAdmin.declareQueue(queue);
    }

    private void addBinding(Queue queue, DirectExchange exchange, String routingKey) {
        Binding binding = BindingBuilder.bind((Queue)queue).to(exchange).with(routingKey);
        this.rabbitAdmin.declareBinding(binding);
    }
}

