/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.cas.system.model.CasAppMenu;
import com.jxdinfo.hussar.cas.system.service.ICasAppMenuService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/casAppMenu"})
public class CasAppMenuController
extends BaseController {
    private String PREFIX = "/system/casApplication/menuManage/";
    @Resource
    private ICasAppMenuService casAppMenuService;
    @Resource
    private ISysDicRefService iSysDicRefService;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @RequestMapping(value={"/menuList"})
    @RequiresPermissions(value={"casAppMenu:menuList"})
    @BussinessLog(key="/casAppMenu/menuList", type="04", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u7ef4\u62a4\u9875\u9762")
    public String menuList() {
        return this.PREFIX + "menuManage.html";
    }

    @RequiresPermissions(value={"casAppMenu:menuTree"})
    @RequestMapping(value={"/menuTree"})
    @ResponseBody
    public List<JSTreeModel> menuTree() {
        String applicationId = super.getPara("applicationId");
        List<JSTreeModel> result = this.casAppMenuService.getMenuTree(applicationId);
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setText("\u83dc\u5355\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"/menuAdd"})
    @RequiresPermissions(value={"casAppMenu:menuAdd"})
    public String menuAdd(Model model) {
        String applicationId = super.getPara("applicationId");
        String menuId = super.getPara("menuId");
        CasAppMenu casAppMenu = this.casAppMenuService.getMenuInfo(menuId, applicationId);
        String menuName = "";
        if (ToolUtil.isNotEmpty((Object)((Object)casAppMenu))) {
            menuName = casAppMenu.getText();
        }
        String length = super.getPara("length");
        model.addAttribute("length", (Object)length);
        model.addAttribute("menuId", (Object)menuId);
        model.addAttribute("menuName", (Object)menuName);
        model.addAttribute("applicationId", (Object)applicationId);
        return this.PREFIX + "casMenuAdd.html";
    }

    @BussinessLog(key="/casAppMenu/menuInfoSave", type="01", value="\u4e1a\u52a1\u7cfb\u7edf-\u65b0\u589e\u83dc\u5355", pk="menuId")
    @RequiresPermissions(value={"casAppMenu:menuInfoSave"})
    @RequestMapping(value={"/menuInfoSave"})
    @ResponseBody
    public void menuInfoSave(CasAppMenu casAppMenu) {
        this.casAppMenuService.menuInfoSave(casAppMenu, casAppMenu.getApplicationId());
    }

    @BussinessLog(key="/casAppMenu/menuInfoEditSave", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u4fee\u6539\u83dc\u5355", pk="menuId")
    @RequiresPermissions(value={"casAppMenu:menuInfoEditSave"})
    @RequestMapping(value={"/menuInfoEditSave"})
    @ResponseBody
    public void menuInfoEditSave(CasAppMenu casAppMenu, String applicationId) {
        this.casAppMenuService.menuInfoSave(casAppMenu, applicationId);
    }

    @RequiresPermissions(value={"casAppMenu:menuInfo"})
    @RequestMapping(value={"/menuInfo"})
    public String menuInfo(Model model) {
        String menuId = super.getPara("menuId");
        String length = super.getPara("length");
        String applicationId = super.getPara("applicationId");
        CasAppMenu result = this.casAppMenuService.getMenuInfo(menuId, applicationId);
        if (!ToolUtil.equals((Object)"1", (Object)result.getParentId())) {
            result = this.casAppMenuService.getMenu(menuId, applicationId, result.getIsLeaf());
        }
        model.addAttribute("menuInfo", (Object)result);
        model.addAttribute("length", (Object)length);
        model.addAttribute("openType", (Object)this.iSysDicRefService.getDictLabel("menu_type", result.getOpenType()));
        return this.PREFIX + "casMenuView.html";
    }

    @BussinessLog(key="/casAppMenu/delMenuById", type="02", value="\u4e1a\u52a1\u7cfb\u7edf-\u5220\u9664\u83dc\u5355", pk="menuId")
    @RequestMapping(value={"/delMenuById"})
    @RequiresPermissions(value={"casAppMenu:delMenuById"})
    @ResponseBody
    public Tip delMenuById() {
        String ids = super.getPara("menuIds");
        List<String> menuIds = Arrays.asList(ids.split(","));
        String applicationId = super.getPara("applicationId");
        if (this.casAppMenuService.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).in((Object)"MENU_ID", menuIds))) {
            this.abstractPushMsgMatcher.insertOperation("menu", "delete", menuIds, applicationId);
            SuccessTip tip = new SuccessTip();
            tip.setMessage("\u5220\u9664\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/menuInfoEdit"})
    @RequiresPermissions(value={"casAppMenu:menuInfoEdit"})
    public String menuInfoEdit(Model model) {
        String menuId = super.getPara("menuId");
        String length = super.getPara("length");
        String applicationId = super.getPara("applicationId");
        CasAppMenu result = this.casAppMenuService.getMenuInfo(menuId, applicationId);
        if (!ToolUtil.equals((Object)"1", (Object)result.getParentId())) {
            result = this.casAppMenuService.getMenu(menuId, applicationId, result.getIsLeaf());
        }
        model.addAttribute("menuInfo", (Object)result);
        model.addAttribute("length", (Object)length);
        return this.PREFIX + "casMenuEdit.html";
    }

    @RequiresPermissions(value={"casAppMenu:menuTreeById"})
    @RequestMapping(value={"/menuTreeById"})
    @ResponseBody
    public List<JSTreeModel> menuTreeById() {
        String menuId = super.getPara("menuId");
        String isHead = super.getPara("isRoot");
        String applicationId = super.getPara("applicationId");
        Boolean isRoot = Boolean.valueOf(isHead);
        List<JSTreeModel> result = this.casAppMenuService.menuTreeById(menuId, applicationId);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("1");
            root.setText("\u83dc\u5355\u5217\u8868");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return result;
    }

    @RequestMapping(value={"/menuTreeOrder"})
    @RequiresPermissions(value={"casAppMenu:menuTreeOrder"})
    @ResponseBody
    @BussinessLog(key="/casAppMenu/menuTreeOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u6811\u4e0b\u7ea7\u6392\u5e8f")
    public void menuTreeOrder() {
        String treeInfo = super.getPara("treeInfo");
        String applicationId = super.getPara("applicationId");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        JSONObject json = new JSONObject();
        ArrayList<CasAppMenu> list = new ArrayList<CasAppMenu>();
        for (int i = 0; i < treeArr.size(); ++i) {
            json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = json.getString("seq");
            CasAppMenu sm = new CasAppMenu();
            sm.setMenuId(id);
            sm.setSeq(Integer.parseInt(order));
            sm.setApplicationId(applicationId);
            list.add(sm);
            this.casAppMenuService.update((Object)sm, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APPLICATION_ID", (Object)applicationId)).eq((Object)"MENU_ID", (Object)id));
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.abstractPushMsgMatcher.insertOperation("menu", "update", list, applicationId);
        }
    }

    @RequestMapping(value={"/menuTreeChange"})
    @RequiresPermissions(value={"casAppMenu:menuTreeChange"})
    @ResponseBody
    @BussinessLog(key="/casAppMenu/menuTreeChange", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u6811\u8f6c\u79fb")
    public void menuTreeChange() {
        String menuId = super.getPara("menuId");
        String parentId = super.getPara("parentId");
        String applicationId = super.getPara("applicationId");
        this.casAppMenuService.menuTreeChange(menuId, parentId, applicationId);
    }

    @RequestMapping(value={"/allIcons"})
    @RequiresPermissions(value={"casAppMenu:allIcons"})
    public String allIcons() {
        return "/bsp/menu/allIcons.json";
    }

    @RequestMapping(value={"/singleMove"})
    @ResponseBody
    @RequiresPermissions(value={"casAppMenu:singleMove"})
    @BussinessLog(key="/casAppMenu/singleMove", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u6811\u4e0a\u79fb/\u4e0b\u79fb")
    public Object updateMoveNode(String menuId, boolean isUp, String applicationId) {
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.casAppMenuService.updateMoveNode(menuId, isUp, applicationId);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/exportMenu"})
    @RequiresPermissions(value={"casAppMenu:exportMenu"})
    @BussinessLog(key="/casAppMenu/exportMenu", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String menuIds = super.getPara("menuIds");
        String applicationId = super.getPara("applicationId");
        List<String> menuIdList = Arrays.asList(menuIds.split(","));
        this.casAppMenuService.exportMenu(menuIdList, applicationId, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @RequiresPermissions(value={"casAppMenu:importData"})
    @BussinessLog(key="/casAppMenu/importData", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u83dc\u5355\u5bfc\u5165")
    public Tip importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return this.casAppMenuService.importMenu(content);
    }
}

