/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.cassync.controller;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.cas.cassync.model.CasSyncMessage;
import com.jxdinfo.hussar.cas.cassync.service.ICasSyncMessageService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/casSyncMessage"})
public class CasSyncMessageController
extends BaseController {
    @Autowired
    private ICasSyncMessageService casSyncMessageService;
    private static String PREFIX = "/dataSync/";

    @BussinessLog(key="/casSyncMessage/view", type="04", value="\u6570\u636e\u540c\u6b65\u9875\u9762")
    @RequiresPermissions(value={"casSyncMessage:view"})
    @RequestMapping(value={"/view"})
    public String index() {
        return PREFIX + "dataSyncApply.html";
    }

    @RequestMapping(value={"/getPendingDeliveryList"})
    @ResponseBody
    public List<CasSyncMessage> getPendingDeliveryList() {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"message_status", (Object)"0");
        ew.orderByAsc((Object)"message_order");
        List list = this.casSyncMessageService.list((Wrapper)ew);
        return list;
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Map<String, Object> list() {
        String applicationName = super.getPara("applicationName");
        String page = super.getPara("curr");
        String limit = super.getPara("nums");
        if (!StringUtils.isEmpty((String)applicationName)) {
            applicationName = applicationName.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        String userId = ShiroKit.getUser().getId();
        Map<String, Object> result = this.casSyncMessageService.getCasSyncList(page, limit, userId, applicationName);
        return result;
    }

    @RequestMapping(value={"/getPushCount"})
    @ResponseBody
    public List<Map<String, Object>> getPushCount() {
        String userId = ShiroKit.getUser().getId();
        List<Map<String, Object>> count = this.casSyncMessageService.getPushCount(userId);
        return count;
    }
}

