/**
 * @Description: 定义数据同步脚本文件
 * @Author: liangdong
 * @Date: 2018/2/27.
 */
layui.use(['upload','jquery','layer','Hussar','HussarAjax','form','table'], function(){
    var Hussar = layui.Hussar;
    var $ = layui.jquery;
    var layer = layui.layer;
    var $ax = layui.HussarAjax;
    var form = layui.form;
    var table = layui.table
        ,upload = layui.upload;

    /**
     * 组织机构规则的单例
     */
    var dataSync = {
        id: "pushMsgTable",	//表格id
        seItem: null,		//选中的条目
        table: null,
        layerIndex: -1
    };

    /**
     * 选中多条结果
     */
    dataSync.checkIds = function() {
        var checkStatus = table.checkStatus('pushMsgFailTable'), data = checkStatus.data;
        var ids = [];
        if (data.length != 0) {
            for (var i = 0, l = data.length; i < l; i++) {
                var r = data[i];
                ids.push(r.ID);
            }
        }
        dataSync.seItem = ids;
        return true;
    };

    //再次同步失败数据
    dataSync.pushSyncInfoAgain  = function () {
        if(dataSync.checkIds()){
            var loadIndex = layer.load(1,{shade:[0.8,'#393D49']});
            var ajax = new $ax(Hussar.ctxPath+"/ServerController/sendSyncInfoAgain",
                function (data) {
                    data = data || {};
                    if(data.code == 200){
                        Hussar.success("操作成功！");
                        // 执行重载
                        table.reload('pushMsgFailTable', {
                            page : {
                                curr : 1
                                // 重新从第 1 页开始
                            },
                            where : {
                                applicationName : $('#applicationName').val(),
                            },
                            encryptEnable: true //layui table 传输加密
                        });
                    }else{
                        Hussar.error("操作失败！（" + (data.message || '未知错误') + "）");
                    }
                    layer.close(loadIndex);
                },
                function (data) {
                    Hussar.error("操作失败！（" + (data.message || '未知错误') + "）");
                    layer.close(loadIndex);
                });
            ajax.set("messageIds",dataSync.seItem.join());
            ajax.setAsync(true);
            ajax.start();
        }

    }


    /**
     * 初始化按钮事件
     */
    dataSync.initButtonEvent = function () {
        $("#pushSyncInfoAgain").click(function(){
            dataSync.pushSyncInfoAgain()
        });
        $('#search').on('click', function() {
            var applicationName = $('#applicationName');
            // 执行重载
            table.reload('pushMsgFailTable', {
                page : {
                    curr : 1
                    // 重新从第 1 页开始
                },
                where : {
                    applicationName : applicationName.val(),
                },
                encryptEnable: true //layui table 传输加密
            });
        });
    }

    /**
     * 初始化表格
     */
    dataSync.initTableView = function () {
        table.render({
            elem: '#pushMsgFailTable',
            url: Hussar.ctxPath+'/casSyncMessageFail/list',
            page: true,
            id: 'pushMsgFailTable',
            even: true,
            height:$("body").height() - $(".layui-form").outerHeight(true)-26,
            request: {
                pageName: 'curr', //页码的参数名称，默认：page
                limitName: 'nums' //每页数据量的参数名，默认：limit
            },
            cols: [[
                {type : 'checkbox', width : 40},
                {type: 'numbers', title: '序号', align: 'center',width:50},
                {field: 'CONTENTS', title: '消息类型', align:'center',templet : showContent,},
                {field: 'FAIL_REASON', title: '失败原因', align:'center'},
                {field: 'APPLICATION_NAME', title: '业务系统名称', align:'center'},
                {field: 'CREATOR', title: '创建人', align:'center'},
                {field: 'CREATE_TIME', title: '创建时间', align:'center',templet : formatDate},
            ]],
            where: {
                applicationName : $('#applicationNmme').val()
            },
            encryptEnable: true //layui table 传输加密
        });
    }

    function showContent(d) {
        var str = d.CONTENTS.split("@");
        var type = str[0].replace("type:","");
        var ProcessingMode = str[1].replace("ProcessingMode:","");
        if(type == "organ"){
            type = "组织机构";
        }else if(type == "user"){
            type = "用户";
        }else if(type == "person"){
            type = "人员";
        }else if(type == "functions"){
            type = "功能";
        }else if(type == "modules"){
            type = "模块";
        }else if(type == "resource"){
            type = "资源";
        }else if(type == "roleResource"){
            type = "资源角色";
        }else if(type == "roleGroup"){
            type = "角色分组";
        }else if(type == "menu"){
            type = "菜单";
        }else if(type == "userRole"){
            type = "人员角色";
        }else if(type == "role"){
            type = "角色";
        }
        if(ProcessingMode == "add"){
            ProcessingMode = "新增";
        }else if(ProcessingMode == "update"){
            ProcessingMode = "修改";
        }else {
            ProcessingMode = "删除";
        }
        return type + ProcessingMode;
    }

    function formatDate(d) {
        var timeStr = new Date(d.CREATE_TIME);
        var year=timeStr.getFullYear();  //取得4位数的年份
        var month=timeStr.getMonth()+1;  //取得日期中的月份，其中0表示1月，11表示12月
        if((month+"").length == 1){
            month = "0"+ month;
        }
        var date=timeStr.getDate();      //返回日期月份中的天数（1到31）
        if((date+"").length == 1){
            date = "0"+ date;
        }
        var hour=timeStr.getHours();     //返回日期中的小时数（0到23）
        if((hour+"").length == 1){
            hour = "0"+ hour;
        }
        var minute=timeStr.getMinutes(); //返回日期中的分钟数（0到59）
        if((minute+"").length == 1){
            minute = "0"+ minute;
        }
        var second=timeStr.getSeconds(); //返回日期中的秒数（0到59）
        if((second+"").length == 1){
            second = "0"+ second;
        }
        return year+"-"+month+"-"+date+" "+hour+":"+minute+":"+second;
    }

    $(function () {
        dataSync.initTableView(); //初始化表格
        dataSync.initButtonEvent(); //初始化按钮事件
    });

});




