/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.cas.system.dao.CasAppRoleResourceMapper;
import com.jxdinfo.hussar.cas.system.model.CasAppRoleResource;
import com.jxdinfo.hussar.cas.system.service.ICasAppRoleResourceService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CasAppRoleResourceServiceImpl
extends ServiceImpl<CasAppRoleResourceMapper, CasAppRoleResource>
implements ICasAppRoleResourceService {
    @Resource
    private CasAppRoleResourceMapper casAppRoleResourceMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveResource(String ids, String roId, String applicationId) {
        List deleteList = this.casAppRoleResourceMapper.selectList(new EntityWrapper().eq("ROLE_ID", (Object)roId).eq("APPLICATION_ID", (Object)applicationId));
        this.casAppRoleResourceMapper.delete(new EntityWrapper().eq("ROLE_ID", (Object)roId).eq("APPLICATION_ID", (Object)applicationId));
        if (deleteList.size() != 0) {
            this.abstractPushMsgMatcher.insertOperation("roleResource", "delete", (Object)deleteList, applicationId);
        }
        String[] id = ids.split(",");
        ArrayList<CasAppRoleResource> casAppRoleResourceList = new ArrayList<CasAppRoleResource>();
        for (String reId : id) {
            if (ToolUtil.isEmpty((Object)reId)) continue;
            CasAppRoleResource casAppRoleResource = new CasAppRoleResource();
            casAppRoleResource.setRoleId(roId);
            casAppRoleResource.setCreateTime(new Date());
            casAppRoleResource.setCreator(ShiroKit.getUser().getId());
            casAppRoleResource.setLastEditor(ShiroKit.getUser().getId());
            casAppRoleResource.setApplicationId(applicationId);
            casAppRoleResource.setLastTime(new Date());
            casAppRoleResource.setResourceId(reId);
            casAppRoleResourceList.add(casAppRoleResource);
        }
        if (ToolUtil.isNotEmpty(casAppRoleResourceList)) {
            super.insertBatch(casAppRoleResourceList, casAppRoleResourceList.size());
            this.abstractPushMsgMatcher.insertOperation("roleResource", "add", casAppRoleResourceList, applicationId);
        }
    }

    @Override
    public void reclaimPerm(String id, String applicationId) {
        List<CasAppRoleResource> casAppRoleResourceList = this.casAppRoleResourceMapper.getRoleResourceByRoleId(id, applicationId);
        this.casAppRoleResourceMapper.delete(new EntityWrapper().eq("ROLE_ID", (Object)id).eq("APPLICATION_ID", (Object)applicationId));
        this.abstractPushMsgMatcher.insertOperation("roleResource", "delete", casAppRoleResourceList, applicationId);
    }

    @Override
    public List<CasAppRoleResource> queryPerm(String id, String applicationId) {
        List list = this.casAppRoleResourceMapper.selectList(new EntityWrapper().eq("ROLE_ID", (Object)id).eq("APPLICATION_ID", (Object)applicationId));
        return list;
    }

    @Override
    @Transactional(rollbackFor={SQLException.class})
    public boolean resourceEditSaveRole(String resourceId, String[] roleIds, String applicationId) {
        boolean flag = false;
        List deleteList = this.casAppRoleResourceMapper.selectList(new EntityWrapper().eq("RESOURCE_ID", (Object)resourceId).eq("APPLICATION_ID", (Object)applicationId));
        this.casAppRoleResourceMapper.delete(new EntityWrapper().eq("RESOURCE_ID", (Object)resourceId).eq("APPLICATION_ID", (Object)applicationId));
        if (deleteList.size() != 0) {
            this.abstractPushMsgMatcher.insertOperation("roleResource", "delete", (Object)deleteList, applicationId);
        }
        Date currentDate = new Date();
        String currentUser = ShiroKit.getUser().getAccount();
        ArrayList<CasAppRoleResource> sysRoleResourceList = new ArrayList<CasAppRoleResource>();
        for (String roleId : roleIds) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            CasAppRoleResource casAppRoleResource = new CasAppRoleResource();
            casAppRoleResource.setRoleId(roleId);
            casAppRoleResource.setResourceId(resourceId);
            casAppRoleResource.setCreateTime(currentDate);
            casAppRoleResource.setCreator(currentUser);
            casAppRoleResource.setLastEditor(currentUser);
            casAppRoleResource.setLastTime(currentDate);
            casAppRoleResource.setApplicationId(applicationId);
            sysRoleResourceList.add(casAppRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            flag = this.insertBatch(sysRoleResourceList, sysRoleResourceList.size());
            this.abstractPushMsgMatcher.insertOperation("roleResource", "add", sysRoleResourceList, applicationId);
        }
        return flag;
    }
}

