/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.cas.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.cas.system.dao.CasAppFunctionsMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppModulesMapper;
import com.jxdinfo.hussar.cas.system.dao.CasAppResourcesMapper;
import com.jxdinfo.hussar.cas.system.model.CasAppFunctions;
import com.jxdinfo.hussar.cas.system.model.CasAppModules;
import com.jxdinfo.hussar.cas.system.model.CasAppResources;
import com.jxdinfo.hussar.cas.system.model.CasAppRoleResource;
import com.jxdinfo.hussar.cas.system.service.ICasAppResourcesService;
import com.jxdinfo.hussar.cas.system.service.ICasAppRoleResourceService;
import com.jxdinfo.hussar.cas.system.service.ICasAppRolesService;
import com.jxdinfo.hussar.cas.system.service.ICasResManageService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/casAppResource"})
public class CasAppResourcesController
extends BaseController {
    private String PREFIX = "/system/casApplication/resourceManage";
    @Resource
    ICasResManageService casResManageService;
    @Resource
    ICasAppResourcesService casAppResourcesService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    CasAppResourcesMapper casAppResourcesMapper;
    @Resource
    ICasAppRoleResourceService casAppRoleResourceService;
    @Resource
    private ICasAppRolesService casAppRolesService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private CasAppModulesMapper casAppModulesMapper;
    @Resource
    private CasAppFunctionsMapper casAppFunctionsMapper;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;

    @RequestMapping(value={"/resTree"})
    @RequiresPermissions(value={"casAppResource:resTree"})
    @ResponseBody
    public List<JSTreeModel> resTree(HttpServletRequest request) {
        String type = request.getParameter("type");
        String applicationId = request.getParameter("applicationId");
        List<Object> result = new ArrayList();
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        if ("menuRes".equals(type)) {
            String resType = this.sysDicRefService.getDictValue("res_type", "\u83dc\u5355\u8d44\u6e90");
            result = this.casResManageService.getMenuResTree(resType, applicationId);
            result.add(root);
        } else {
            String nodeId = super.getPara("nodeId");
            if (this.globalProperties.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)nodeId)) {
                String leaf = super.getPara("isLeaf");
                String nodeType = super.getPara("nodeType");
                boolean isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType);
                boolean isLeaf = ToolUtil.equals((Object)"1", (Object)leaf);
                boolean isFun = ToolUtil.equals((Object)"isFun", (Object)nodeType);
                boolean isFunAndRes = isModule && isLeaf || isFun;
                List<Object> tree = new ArrayList();
                if (ToolUtil.equals((Object)"#", (Object)nodeId)) {
                    nodeId = "1";
                    result.add(root);
                    tree = this.casResManageService.getMoudleAndFunctionTree(nodeId, applicationId);
                } else if (isModule && !isLeaf) {
                    tree = this.casResManageService.getMoudleAndFunctionTree(nodeId, applicationId);
                } else if (isFunAndRes) {
                    tree = this.casResManageService.getFunctionAndResTree(nodeId, applicationId);
                }
                result.addAll(tree);
            } else {
                result = this.casResManageService.getResTree(applicationId);
                result.add(root);
            }
        }
        return result;
    }

    @RequestMapping(value={"/moduleTreeById"})
    @RequiresPermissions(value={"casAppResource:moduleTreeById"})
    @ResponseBody
    public List<JSTreeModel> moduleTreeById(HttpServletRequest request) {
        String moduleId = request.getParameter("moduleId");
        String isHead = request.getParameter("isRoot");
        String applicationId = request.getParameter("applicationId");
        Boolean isRoot = Boolean.valueOf(isHead);
        List<JSTreeModel> result = this.casResManageService.moduleTreeById(moduleId, applicationId);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("1");
            root.setCode("1");
            root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return result;
    }

    @RequiresPermissions(value={"casAppResource:moduleAdd"})
    @RequestMapping(value={"moduleAdd"})
    public String moduleAdd(Model model) {
        String currentCode;
        String moduleId = super.getPara("moduleId");
        String applicationId = super.getPara("applicationId");
        CasAppModules sysModules = this.casResManageService.getModuleInfoById(moduleId, applicationId);
        String moduleName = "";
        if (ToolUtil.isNotEmpty((Object)((Object)sysModules))) {
            moduleName = sysModules.getModuleName();
        }
        if (ToolUtil.isEmpty((Object)(currentCode = this.sysIdtableService.getCurrentCode("module_code", "sys_modules")))) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        model.addAttribute("currentCode", (Object)currentCode);
        model.addAttribute("moduleId", (Object)moduleId);
        model.addAttribute("moduleName", (Object)moduleName);
        model.addAttribute("applicationId", (Object)applicationId);
        return this.PREFIX + "/modulesAdd.html";
    }

    @RequiresPermissions(value={"casAppResource:moduleEdit"})
    @RequestMapping(value={"moduleEdit"})
    public String moduleEdit(Model model) {
        String moduleId = super.getPara("moduleId");
        String applicationId = super.getPara("applicationId");
        CasAppModules result = this.casResManageService.getModuleInfoById(moduleId, applicationId);
        model.addAttribute("sysModules", (Object)result);
        return this.PREFIX + "/modulesEdit.html";
    }

    @RequestMapping(value={"moduleView"})
    @BussinessLog(key="/casAppResource/moduleView", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf-\u6a21\u5757\u4fe1\u606f")
    @RequiresPermissions(value={"casAppResource:moduleView"})
    public String moduleView(Model model) {
        String moduleId = super.getPara("moduleId");
        String applicationId = super.getPara("applicationId");
        CasAppModules result = this.casResManageService.getModuleInfoById(moduleId, applicationId);
        model.addAttribute("sysModules", (Object)result);
        return this.PREFIX + "/modulesView.html";
    }

    @RequiresPermissions(value={"casAppResource:moduleSave"})
    @RequestMapping(value={"moduleSave"})
    @BussinessLog(key="/casAppResource/moduleSave", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf-\u6a21\u5757")
    @ResponseBody
    public Integer moduleSave(CasAppModules casAppModules) {
        return this.casResManageService.moduleSave(casAppModules);
    }

    @RequiresPermissions(value={"casAppResource:moduleEditSave"})
    @RequestMapping(value={"moduleEditSave"})
    @BussinessLog(key="/casAppResource/moduleEditSave", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf-\u6a21\u5757", pk="moduleId")
    @ResponseBody
    public Tip moduleEditSave(CasAppModules casAppModules) {
        boolean isAllowEditModule = this.casResManageService.isAllowEditModule(casAppModules, casAppModules.getApplicationId());
        CasAppModules sysModules = (CasAppModules)((Object)this.casAppModulesMapper.selectList(new EntityWrapper().eq("APPLICATION_ID", (Object)casAppModules.getApplicationId()).eq("MODULE_ID", (Object)casAppModules.getModuleId())).get(0));
        LogObjectHolder.me().set((Object)sysModules);
        if (isAllowEditModule) {
            Integer count = this.casResManageService.moduleSave(casAppModules);
            if (count != 0) {
                SuccessTip tip = new SuccessTip();
                tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
                return tip;
            }
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return new ErrorTip(HttpCode.CONFLICT.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01\uff08\u5b58\u5728\u4e0b\u7ea7\u6a21\u5757\u6216\u4e0b\u7ea7\u529f\u80fd\u65f6\u4e0d\u80fd\u4fee\u6539\u6a21\u5757\u7c7b\u578b\uff01\uff09");
    }

    @RequiresPermissions(value={"casAppResource:delModule"})
    @RequestMapping(value={"delModule"})
    @BussinessLog(key="/casAppResource/delModule", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf-\u6a21\u5757", pk="moduleId")
    @ResponseBody
    public JSONObject delModule() {
        String moduleId = super.getPara("moduleId");
        String applicationId = super.getPara("applicationId");
        return this.casResManageService.delModule(moduleId, applicationId);
    }

    @RequiresPermissions(value={"casAppResource:functionAdd"})
    @RequestMapping(value={"functionAdd"})
    public String functionAdd(Model model) {
        String moduleId = super.getPara("moduleId");
        String applicationId = super.getPara("applicationId");
        CasAppModules sysModules = this.casResManageService.getModuleInfoById(moduleId, applicationId);
        String moduleCode = sysModules.getModuleCode();
        String moduleName = sysModules.getModuleName();
        String currentCode = this.sysIdtableService.getCurrentCode("function_code", "sys_functions");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        model.addAttribute("currentCode", (Object)(moduleCode + currentCode));
        model.addAttribute("moduleId", (Object)moduleId);
        model.addAttribute("moduleName", (Object)moduleName);
        model.addAttribute("applicationId", (Object)applicationId);
        return this.PREFIX + "/functionAdd.html";
    }

    @RequiresPermissions(value={"casAppResource:functionEdit"})
    @RequestMapping(value={"functionEdit"})
    public String functionEdit(Model model) {
        String functionId = super.getPara("functionId");
        String applicationId = super.getPara("applicationId");
        CasAppFunctions result = this.casResManageService.getFunctionInfoById(functionId, applicationId);
        model.addAttribute("sysFunctions", (Object)result);
        return this.PREFIX + "/functionEdit.html";
    }

    @RequestMapping(value={"functionView"})
    @RequiresPermissions(value={"casAppResource:functionView"})
    @BussinessLog(key="/casAppResource/functionView", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf-\u529f\u80fd\u4fe1\u606f")
    public String functionView(Model model) {
        String functionId = super.getPara("functionId");
        String applicationId = super.getPara("applicationId");
        CasAppFunctions result = this.casResManageService.getFunctionInfoById(functionId, applicationId);
        model.addAttribute("sysFunctions", (Object)result);
        return this.PREFIX + "/functionView.html";
    }

    @RequiresPermissions(value={"casAppResource:functionSave"})
    @RequestMapping(value={"functionSave"})
    @ResponseBody
    @BussinessLog(key="/casAppResource/functionSave", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf-\u529f\u80fd", pk="functionId")
    public Integer functionSave(CasAppFunctions sysFunctions) {
        sysFunctions.setFunctionId(null);
        return this.casResManageService.functionSave(sysFunctions);
    }

    @RequiresPermissions(value={"casAppResource:functionEditSave"})
    @RequestMapping(value={"functionEditSave"})
    @ResponseBody
    @BussinessLog(key="/casAppResource/functionEditSave", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf-\u529f\u80fd", pk="functionId")
    public Integer functionEditSave(CasAppFunctions casAppFunctions) {
        List casAppFunctionsList = this.casAppFunctionsMapper.selectList(new EntityWrapper().eq("FUNCTION_ID", (Object)casAppFunctions.getFunctionId()).eq("APPLICATION_ID", (Object)casAppFunctions.getApplicationId()));
        LogObjectHolder.me().set(casAppFunctionsList.get(0));
        return this.casResManageService.functionSave(casAppFunctions);
    }

    @RequiresPermissions(value={"casAppResource:delFunction"})
    @BussinessLog(key="/casAppResource/delFunction", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf-\u529f\u80fd", pk="functionId")
    @RequestMapping(value={"delFunction"})
    @ResponseBody
    public JSONObject delFunction() {
        String functionId = super.getPara("functionId");
        String applicationId = super.getPara("applicationId");
        return this.casResManageService.delFunction(functionId, applicationId);
    }

    @RequiresPermissions(value={"casAppResource:resourceAdd"})
    @RequestMapping(value={"resourceAdd"})
    public String resourceAdd(Model model) {
        String functionId = super.getPara("functionId");
        String applicationId = super.getPara("applicationId");
        CasAppFunctions sysFunctions = this.casResManageService.getFunctionInfoById(functionId, applicationId);
        String functionCode = sysFunctions.getFunctionCode();
        String functionName = sysFunctions.getFunctionName();
        String currentCode = this.sysIdtableService.getCurrentCode("resource_code", "sys_resources");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        List resTypes = this.sysDicRefService.getDictByType("res_type");
        model.addAttribute("currentCode", (Object)(functionCode + currentCode));
        model.addAttribute("resTypes", (Object)resTypes);
        model.addAttribute("functionId", (Object)functionId);
        model.addAttribute("functionName", (Object)functionName);
        model.addAttribute("applicationId", (Object)applicationId);
        return this.PREFIX + "/resourceAdd.html";
    }

    @RequiresPermissions(value={"casAppResource:resourceEdit"})
    @RequestMapping(value={"resourceEdit"})
    public String resourceEdit(Model model) {
        String resourceId = super.getPara("resourceId");
        String applicationId = super.getPara("applicationId");
        CasAppResources result = this.casResManageService.getResourceInfoById(resourceId, applicationId);
        List resTypes = this.sysDicRefService.getDictByType("res_type");
        model.addAttribute("resTypes", (Object)resTypes);
        model.addAttribute("sysResources", (Object)result);
        return this.PREFIX + "/resourceEdit.html";
    }

    @RequiresPermissions(value={"casAppResource:resourceSave"})
    @RequestMapping(value={"resourceSave"})
    @ResponseBody
    @BussinessLog(key="/casAppResource/resourceSave", type="01", value="\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90", pk="resourceId")
    public String resourceSave(CasAppResources sysResources) {
        sysResources.setResourceId(null);
        String resourceId = this.casResManageService.resourceSave(sysResources);
        String applicationId = sysResources.getApplicationId();
        return resourceId + "@" + applicationId;
    }

    @RequiresPermissions(value={"casAppResource:resourceEditSave"})
    @RequestMapping(value={"resourceEditSave"})
    @ResponseBody
    @BussinessLog(key="/casAppResource/resourceEditSave", type="03", value="\u4fee\u6539\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90", pk="resourceId")
    public void resourceEditSave(CasAppResources casAppResources) {
        if ("1".equals(casAppResources.getResTypeId())) {
            casAppResources.setIsRepeatAuthenticate("0");
        }
        this.casResManageService.resourceSave(casAppResources);
    }

    @RequestMapping(value={"resourceView"})
    @RequiresPermissions(value={"casAppResource:resourceView"})
    @BussinessLog(key="/casAppResource/resourceView", type="04", value="\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u4fe1\u606f")
    public String resourceView(Model model) {
        String resourceId = super.getPara("resourceId");
        String applicationId = super.getPara("applicationId");
        CasAppResources result = this.casResManageService.getResourceInfoById(resourceId, applicationId);
        List resTypes = this.sysDicRefService.getDictByType("res_type");
        model.addAttribute("resTypes", (Object)resTypes);
        model.addAttribute("sysResources", (Object)result);
        return this.PREFIX + "/resourceView.html";
    }

    @RequiresPermissions(value={"casAppResource:delResource"})
    @BussinessLog(key="/casAppResource/delResource", type="02", value="\u5220\u9664\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90", pk="resourceId")
    @RequestMapping(value={"delResource"})
    @ResponseBody
    public JSONObject delResource() {
        String resourceId = super.getPara("resourceId");
        String applicationId = super.getPara("applicationId");
        return this.casResManageService.delResource(resourceId, applicationId);
    }

    @RequestMapping(value={"moduleTreeOrder"})
    @ResponseBody
    @RequiresPermissions(value={"casAppResource:moduleTreeOrder"})
    @BussinessLog(key="/casAppResource/moduleTreeOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u6a21\u5757\u4e0b\u7ea7\u6392\u5e8f")
    public void moduleTreeOrder() {
        String treeInfo = super.getPara("treeInfo");
        String applicationId = super.getPara("applicationId");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.casResManageService.saveModuleTreeOrder(treeArr, applicationId);
    }

    @RequestMapping(value={"/functionTreeById"})
    @RequiresPermissions(value={"casAppResource:functionTreeById"})
    @ResponseBody
    public List<JSTreeModel> functionTreeById() {
        String moduleId = super.getPara("moduleId");
        String moduleName = super.getPara("moduleName");
        String applicationId = super.getPara("applicationId");
        List<JSTreeModel> result = this.casResManageService.functionTreeByModuleId(moduleId, applicationId);
        JSTreeModel root = new JSTreeModel();
        root.setId(moduleId);
        root.setText(moduleName);
        root.setParent("#");
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"functionTreeOrder"})
    @ResponseBody
    @RequiresPermissions(value={"casAppResource:functionTreeOrder"})
    @BussinessLog(key="/casAppResource/functionTreeOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u529f\u80fd\u4e0b\u7ea7\u6392\u5e8f")
    public void functionTreeOrder() {
        String treeInfo = super.getPara("treeInfo");
        String applicationId = super.getPara("applicationId");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.casResManageService.saveFunctionTreeOrder(treeArr, applicationId);
    }

    @RequestMapping(value={"resourceTreeById"})
    @RequiresPermissions(value={"casAppResource:resourceTreeById"})
    @ResponseBody
    public List<JSTreeModel> resourceTreeById() {
        String functionId = super.getPara("functionId");
        String functionName = super.getPara("functionName");
        String applicationId = super.getPara("applicationId");
        List<JSTreeModel> result = this.casResManageService.resourceTreeByModuleId(functionId, applicationId);
        JSTreeModel root = new JSTreeModel();
        root.setId(functionId);
        root.setText(functionName);
        root.setParent("#");
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isFun");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"resourceTreeOrder"})
    @ResponseBody
    @RequiresPermissions(value={"casAppResource:resourceTreeOrder"})
    @BussinessLog(key="/casAppResource/resourceTreeOrder", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u4e0b\u7ea7\u6392\u5e8f")
    public boolean resourceTreeOrder() {
        String treeInfo = super.getPara("treeInfo");
        String applicationId = super.getPara("applicationId");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        return this.casResManageService.saveResourceTreeOrder(treeArr, applicationId);
    }

    @RequestMapping(value={"moduleChangeById"})
    @RequiresPermissions(value={"casAppResource:moduleChangeById"})
    @ResponseBody
    public List<JSTreeModel> moduleChangeById() {
        String moduleId = super.getPara("moduleId");
        String applicationId = super.getPara("applicationId");
        String isLeaf = super.getPara("isLeaf");
        List<JSTreeModel> result = this.casResManageService.moduleChangeById(moduleId, isLeaf, applicationId);
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"moduleTreeChange"})
    @ResponseBody
    @RequiresPermissions(value={"casAppResource:moduleTreeChange"})
    @BussinessLog(key="/casAppResource/moduleTreeChange", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u6a21\u5757\u8f6c\u79fb")
    public void moduleTreeChange() {
        String moduleId = super.getPara("moduleId");
        String parentId = super.getPara("parentId");
        String applicationId = super.getPara("applicationId");
        this.casResManageService.moduleTreeChange(moduleId, parentId, applicationId);
    }

    @RequestMapping(value={"functionTreeChange"})
    @ResponseBody
    @RequiresPermissions(value={"casAppResource:functionTreeChange"})
    @BussinessLog(key="/casAppResource/functionTreeChange", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u529f\u80fd\u8f6c\u79fb")
    public void functionTreeChange() {
        String functionId = super.getPara("functionId");
        String parentId = super.getPara("parentId");
        String applicationId = super.getPara("applicationId");
        this.casResManageService.functionTreeChange(functionId, parentId, applicationId);
    }

    @RequestMapping(value={"resourceChangeById"})
    @RequiresPermissions(value={"casAppResource:resourceChangeById"})
    @ResponseBody
    public List<JSTreeModel> resourceChangeById() {
        String resourceId = super.getPara("resourceId");
        String applicationId = super.getPara("applicationId");
        List<JSTreeModel> result = this.casResManageService.resourceChangeById(resourceId, applicationId);
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"resourceTreeChange"})
    @ResponseBody
    @RequiresPermissions(value={"casAppResource:resourceTreeChange"})
    @BussinessLog(key="/casAppResource/resourceTreeChange", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u8f6c\u79fb")
    public void resourceTreeChange() {
        String resourceId = super.getPara("resourceId");
        String parentId = super.getPara("parentId");
        String applicationId = super.getPara("applicationId");
        this.casResManageService.resourceTreeChange(resourceId, parentId, applicationId);
    }

    @RequestMapping(value={"/selfResourceTree"})
    @RequiresPermissions(value={"casAppResource:selfResourceTree"})
    @ResponseBody
    public List<JSTreeModel> selfResourceTree() {
        String[] resourceIds = super.getPara("resourceIds").trim().split(",");
        String applicationId = super.getPara("applicationId");
        List<JSTreeModel> result = this.casResManageService.selfResourceTree(resourceIds, applicationId);
        List<JSTreeModel> tree = this.doRecursive(result);
        block0: for (JSTreeModel js : tree) {
            for (String id : resourceIds) {
                if (ToolUtil.equals((Object)js.getId(), (Object)id)) {
                    js.setState(true, true, true);
                    continue block0;
                }
                js.setState(false, false, true);
            }
        }
        return tree;
    }

    public List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, "");
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!"#".equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent("#");
        model.setCode("GROUP");
        model.setText("\u89d2\u8272\u8d44\u6e90\u6811");
        model.setId("1");
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    public void recursive(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (i < 0) break;
            JSTreeModel map = list.get(i);
            if (!"1".equals(map.getIsRes()) && !parentId.equals(map.getId())) continue;
            parentId = map.getParent();
            result.add(map);
            list.remove(i);
            this.recursive(list, result, parentId);
        }
    }

    @RequestMapping(value={"/sameUrl"})
    @RequiresPermissions(value={"casAppResource:sameUrl"})
    @ResponseBody
    public List<CasAppResources> sameUrl() {
        String url = super.getPara("url");
        String applicationId = super.getPara("applicationId");
        CasAppResources sysResources = new CasAppResources();
        sysResources.setFunctionId(null);
        List<CasAppResources> list = this.casAppResourcesMapper.sameUrl(url, applicationId);
        return list;
    }

    @RequestMapping(value={"/editResTree"})
    @RequiresPermissions(value={"casAppResource:editResTree"})
    @ResponseBody
    public List<JSTreeModel> editResTree() {
        String[] resourceIds = super.getPara("resourceIds").trim().split(",");
        String applicationId = super.getPara("applicationId");
        List<JSTreeModel> result = this.casResManageService.getResTree(applicationId);
        block0: for (JSTreeModel js : result) {
            js.setState(false, false, false);
            if (ToolUtil.equals((Object)js.getConstant(), (Object)"1")) {
                js.setState(false, false, true);
                for (String id : resourceIds) {
                    if (!ToolUtil.equals((Object)js.getId(), (Object)id)) continue;
                    js.setState(true, true, true);
                    continue block0;
                }
                continue;
            }
            for (String id : resourceIds) {
                if (!ToolUtil.equals((Object)js.getId(), (Object)id)) continue;
                js.setState(true, true, false);
                continue block0;
            }
        }
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        return result;
    }

    @RequestMapping(value={"/roleTreeView"})
    @RequiresPermissions(value={"casAppResource:roleTreeView"})
    @ResponseBody
    public List<JSTreeModel> getRoleTreeView() {
        String resourceId = super.getPara("resourceId");
        String applicationId = super.getPara("applicationId");
        List roleResourceList = this.casAppRoleResourceService.selectList(new EntityWrapper().eq("APPLICATION_ID", (Object)applicationId).eq("RESOURCE_ID", (Object)resourceId));
        if (ToolUtil.isEmpty((Object)roleResourceList)) {
            ArrayList<JSTreeModel> emptyList = new ArrayList<JSTreeModel>();
            JSTreeModel model = new JSTreeModel();
            model.setId("1");
            model.setCode("GROUP");
            model.setParent("#");
            model.setText("\u5173\u8054\u89d2\u8272");
            model.setType("isRoot");
            model.setState(false, false, true);
            emptyList.add(model);
            return emptyList;
        }
        ArrayList<String> roleIds = new ArrayList<String>();
        for (CasAppRoleResource roleResource : roleResourceList) {
            roleIds.add(roleResource.getRoleId());
        }
        List<JSTreeModel> result = this.casAppRolesService.selfRoleTree(roleIds.toArray(new String[roleIds.size()]), applicationId);
        List<JSTreeModel> tree = this.getRoleTree(result);
        block1: for (JSTreeModel js : tree) {
            for (String id : roleIds) {
                if (ToolUtil.equals((Object)js.getId(), (Object)id)) {
                    js.setState(true, true, true);
                    continue block1;
                }
                js.setState(false, false, true);
            }
        }
        return tree;
    }

    public List<JSTreeModel> getRoleTree(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursiveRoleTree(list, result, "");
        JSTreeModel model = new JSTreeModel();
        model.setId("1");
        model.setCode("GROUP");
        model.setParent("#");
        model.setText("\u5173\u8054\u89d2\u8272");
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    public void recursiveRoleTree(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (i < 0) break;
            JSTreeModel map = list.get(i);
            if (!"ROLE".equals(map.getCode()) && !parentId.equals(map.getId())) continue;
            parentId = map.getParent();
            result.add(map);
            list.remove(i);
            this.recursiveRoleTree(list, result, parentId);
        }
    }

    @RequestMapping(value={"/resourceAddSaveRole"})
    @BussinessLog(key="/casAppResource/resourceAddSaveRole", type="01", value="\u4e1a\u52a1\u7cfb\u7edf-\u65b0\u589e\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58")
    @RequiresPermissions(value={"casAppResource:resourceAddSaveRole"})
    @ResponseBody
    public Tip resourceAddSaveRole() {
        String resourceId = super.getPara("resourceId");
        String applicationId = super.getPara("applicationId");
        String[] roleIds = super.getPara("roleIds").split(",");
        Date currentDate = new Date();
        String currentUser = ShiroKit.getUser().getAccount();
        ArrayList<CasAppRoleResource> sysRoleResourceList = new ArrayList<CasAppRoleResource>();
        for (String roleId : roleIds) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            CasAppRoleResource casAppRoleResource = new CasAppRoleResource();
            casAppRoleResource.setRoleId(roleId);
            casAppRoleResource.setResourceId(resourceId);
            casAppRoleResource.setCreateTime(currentDate);
            casAppRoleResource.setCreator(currentUser);
            casAppRoleResource.setLastEditor(currentUser);
            casAppRoleResource.setLastTime(currentDate);
            casAppRoleResource.setApplicationId(applicationId);
            sysRoleResourceList.add(casAppRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            this.casAppRoleResourceService.insertBatch(sysRoleResourceList, sysRoleResourceList.size());
            this.abstractPushMsgMatcher.insertOperation("roleResource", "add", sysRoleResourceList, applicationId);
        }
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/resourceEditSaveRole"})
    @BussinessLog(key="/casAppResource/resourceEditSaveRole", type="01", value="\u4e1a\u52a1\u7cfb\u7edf-\u4fee\u6539\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58")
    @RequiresPermissions(value={"casAppResource:resourceEditSaveRole"})
    @ResponseBody
    public Tip resourceEditSaveRole() {
        String resourceId = super.getPara("resourceId");
        String applicationId = super.getPara("applicationId");
        String[] roleIds = super.getPara("roleIds").split(",");
        this.casAppRoleResourceService.resourceEditSaveRole(resourceId, roleIds, applicationId);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/roleTreeEdit"})
    @RequiresPermissions(value={"casAppResource:roleTreeEdit"})
    @ResponseBody
    public List<JSTreeModel> getRoleTreeEdit() {
        String resourceId = super.getPara("resourceId");
        String applicationId = super.getPara("applicationId");
        List roleResourceList = this.casAppRoleResourceService.selectList(new EntityWrapper().eq("RESOURCE_ID", (Object)resourceId).eq("APPLICATION_ID", (Object)applicationId));
        List<JSTreeModel> result = this.casAppRolesService.getRoleTree(applicationId);
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent("#");
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u5173\u8054\u89d2\u8272");
        jsTreeModel.setId("1");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        block0: for (JSTreeModel tree : result) {
            tree.setState(false, false, false);
            for (CasAppRoleResource roleResource : roleResourceList) {
                if (!tree.getId().equals(roleResource.getRoleId())) continue;
                tree.setState(true, true, false);
                continue block0;
            }
        }
        return result;
    }

    @RequestMapping(value={"/exportRes"})
    @ResponseBody
    @RequiresPermissions(value={"casAppResource:exportRes"})
    @BussinessLog(key="/casAppResource/exportRes", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u5bfc\u51fa")
    public Tip exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        String applicationId = super.getPara("applicationId");
        List<String> idList = Arrays.asList(ids.split(","));
        this.casResManageService.exportRes(idList, applicationId, response);
        return SUCCESS_TIP;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @RequiresPermissions(value={"casAppResource:importData"})
    @BussinessLog(key="/casAppResource/importData", type="03", value="\u4e1a\u52a1\u7cfb\u7edf-\u8d44\u6e90\u5bfc\u5165")
    public Tip importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return this.casResManageService.importRes(content);
    }

    @RequestMapping(value={"/checkResource"})
    @RequiresPermissions(value={"casAppResource:checkResource"})
    @ResponseBody
    public JSONObject checkResource(String resourceUrl) {
        JSONObject json = new JSONObject();
        json.put("flag", (Object)this.casAppResourcesService.checkResource(resourceUrl));
        this.abstractOTPCredentialsMatcher.getClass();
        json.put("csrfToken", (Object)this.abstractOTPCredentialsMatcher.generate("FCUD3YLMJYG2F72L2NFDXYPL6UJBUUN24BGBK6JDEIKHUA4ZOD2A"));
        return json;
    }
}

