/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.util.CreateFileUtil;
import com.jxdinfo.hussar.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/dataSync"})
public class DataSync {
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysMenuManageService sysMenuManageService;
    @Autowired
    private ISysResourcesService sysResourcesService;
    @Autowired
    private ISysRoleResourceService sysRoleResourceService;
    private static String PREFIX = "/dataSync/";

    @BussinessLog(key="/dataSync/view", type="04", value="\u6570\u636e\u540c\u6b65\u9875\u9762")
    @RequiresPermissions(value={"dataSync:view"})
    @RequestMapping(value={"/view"})
    public String index() {
        return PREFIX + "dataSyncApply.html";
    }

    @RequestMapping(value={"/casExportSysInfoToJson"})
    @ResponseBody
    public void casExportSysInfoToJson(HttpServletResponse response) throws IOException {
        JSONObject object = new JSONObject();
        List organArray = this.sysOrganService.selectList(null);
        object.put("organArray", (Object)organArray);
        List userList = this.sysUsersService.selectList(null);
        object.put("userList", (Object)userList);
        List roleList = this.sysRolesService.selectList(null);
        object.put("roleList", (Object)roleList);
        List userRoleList = this.sysUserRoleService.selectList(null);
        object.put("userRoleList", (Object)userRoleList);
        List resourceList = this.sysResourcesService.selectList(null);
        object.put("resourceList", (Object)resourceList);
        List roleResource = this.sysRoleResourceService.selectList(null);
        object.put("roleResource", (Object)roleResource);
        List menuList = this.sysMenuManageService.selectList(null);
        object.put("menuList", (Object)menuList);
        String jsonString = object.toString();
        String filePath = "/fileStorage/download/json";
        String fileName = "CASSync";
        CreateFileUtil.createJsonFile(jsonString, filePath, fileName);
        response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(fileName + ".json", "UTF-8"));
        String realPath = filePath + File.separator + fileName + ".json";
        FileInputStream in = new FileInputStream(realPath);
        int len = 0;
        byte[] buffer = new byte[1024];
        ServletOutputStream out = response.getOutputStream();
        while ((len = ((InputStream)in).read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        ((InputStream)in).close();
        this.deleteJsonFile(new File(realPath));
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/casImpSysInfoByJsonFile"})
    @ResponseBody
    public Object casImpSysInfoByJsonFile(@RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        File f = null;
        if (file.equals("") || file.getSize() <= 0L) {
            file = null;
        } else {
            try {
                InputStream ins = file.getInputStream();
                f = new File(file.getOriginalFilename());
                FileUtil.inputStreamToFile(ins, f);
                String input = FileUtils.readFileToString((File)f, (String)"UTF-8");
                JSONObject jsonObject = JSONObject.parseObject((String)input);
                List organArray = (List)jsonObject.get((Object)"organArray");
                List userList = (List)jsonObject.get((Object)"userList");
                List roleList = (List)jsonObject.get((Object)"roleList");
                List userRoleList = (List)jsonObject.get((Object)"userRoleList");
                List resourceList = (List)jsonObject.get((Object)"resourceList");
                List roleResource = (List)jsonObject.get((Object)"roleResource");
                List list = (List)jsonObject.get((Object)"menuList");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new SuccessTip();
    }

    private void deleteJsonFile(File file) {
        if (file.isFile()) {
            file.delete();
        } else {
            String[] childFilePaths;
            for (String childFilePath : childFilePaths = file.list()) {
                File childFile = new File(file.getAbsolutePath() + "/" + childFilePath);
                this.deleteJsonFile(childFile);
            }
            file.delete();
        }
    }
}

