/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.taskmonitor.controller;

import com.jxdinfo.hussar.bpm.taskmonitor.service.TaskMonitorService;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/taskMonitor"})
public class TaskMonitorController {
    @Autowired
    private TaskMonitorService taskMonitorService;

    @RequestMapping(value={"/processRunning"})
    public ModelAndView processRunning() {
        return new ModelAndView("/bpm/taskmonitor/processRunning.html");
    }

    @RequestMapping(value={"/processFinished"})
    public ModelAndView processFinished() {
        return new ModelAndView("/bpm/taskmonitor/processFinished.html");
    }

    @RequestMapping(value={"/queryProcessRunning"})
    public Map<String, Object> queryProcessRunning(@RequestParam(required=false) String processDefinitionName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("processDefinitionName", processDefinitionName);
            map.put("page", page);
            map.put("limit", limit);
            return this.taskMonitorService.queryProcessRunning(map);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/queryProcessFinished"})
    public Map<String, Object> queryProcessFinished(@RequestParam(required=false) String processDefinitionName, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("processDefinitionName", processDefinitionName);
            map.put("page", page);
            map.put("limit", limit);
            return this.taskMonitorService.queryProcessFinished(map);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }
}

