/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.rest.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.utils.ServiceResult;
import com.jxdinfo.hussar.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.bpm.process.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.bpm.processimage.utils.HMProcessDiagramGenerator;
import com.jxdinfo.hussar.bpm.rest.service.ProcessInstanceService;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ProcessInstanceServiceImpl
implements ProcessInstanceService {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceServiceImpl.class);
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    private static final Map<String, String> TASK_SOURCE_FLAG = new HashMap<String, String>();

    @Override
    public String startProcessInstanceById(String processDefinitionId, String userId, String businessKey, Map<String, Object> variablesMap) {
        try {
            this.identityService.setAuthenticatedUserId(userId);
            if (variablesMap == null) {
                variablesMap = new HashMap<String, Object>();
            }
            variablesMap.put("_ACTIVITI_SKIP_EXPRESSION_ENABLED", true);
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessKey, variablesMap);
            this.saveLineHis(processInstance, userId);
            return this.installReturnValue(processInstance, userId);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, Map<String, Object> variablesMap) {
        try {
            this.identityService.setAuthenticatedUserId(userId);
            if (variablesMap == null) {
                variablesMap = new HashMap<String, Object>();
            }
            variablesMap.put("_ACTIVITI_SKIP_EXPRESSION_ENABLED", true);
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey, businessKey, variablesMap);
            this.saveLineHis(processInstance, userId);
            return this.installReturnValue(processInstance, userId);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String startProcessInstanceById(String processDefinitionId, String userId, String businessKey) {
        try {
            this.identityService.setAuthenticatedUserId(userId);
            HashMap<String, Boolean> variablesMap = new HashMap<String, Boolean>();
            variablesMap.put("_ACTIVITI_SKIP_EXPRESSION_ENABLED", true);
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessKey, variablesMap);
            this.saveLineHis(processInstance, userId);
            return this.installReturnValue(processInstance, userId);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    @Override
    public String startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey) {
        try {
            this.identityService.setAuthenticatedUserId(userId);
            HashMap<String, Boolean> variablesMap = new HashMap<String, Boolean>();
            variablesMap.put("_ACTIVITI_SKIP_EXPRESSION_ENABLED", true);
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey, businessKey, variablesMap);
            this.saveLineHis(processInstance, userId);
            return this.installReturnValue(processInstance, userId);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private String installReturnValue(ProcessInstance processInstance, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).active().singleResult();
        Set<String> users = this.getAssigneeByTaskId(task.getId());
        if (users == null || users.size() == 0) {
            this.taskService.setAssignee(task.getId(), userId);
        }
        map.put("NodeName", task.getName());
        map.put("NodeId", task.getTaskDefinitionKey());
        map.put("definitionKey", task.getTaskDefinitionKey());
        map.put("definitionName", task.getName());
        map.put("taskId", task.getId());
        map.put("processInstanceId", processInstance.getId());
        map.put("userId", this.getAssigneeByTaskId(task.getId()));
        return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
    }

    private void saveLineHis(ProcessInstance processInstance, String userId) {
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).orderByHistoricActivityInstanceEndTime().asc()).list();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        ExecutionEntity executionEntity = (ExecutionEntity)processInstance;
        if (historicActivityInstances != null && historicActivityInstances.size() > 0) {
            List<SysActHiLine> sysActHiLines = new ArrayList<SysActHiLine>();
            List<String> ids = historicActivityInstances.stream().map(HistoricActivityInstance::getActivityId).collect(Collectors.toList());
            String startActivityId = historicProcessInstance.getStartActivityId();
            ActivityImpl activity = def.findActivity(startActivityId);
            sysActHiLines = this.installHiLine(activity, executionEntity, sysActHiLines, ids, userId);
            if (sysActHiLines != null && sysActHiLines.size() > 0) {
                this.iSysActHiLineService.insertBatch(sysActHiLines);
            }
        }
    }

    private List<SysActHiLine> installHiLine(ActivityImpl activity, ExecutionEntity executionEntity, List<SysActHiLine> sysActHiLines, List<String> ids, String userId) {
        List outgoingTransitions = activity.getOutgoingTransitions();
        if (outgoingTransitions != null && outgoingTransitions.size() > 0) {
            for (PvmTransition p : outgoingTransitions) {
                if (!ids.contains(p.getDestination().getId())) continue;
                ActivityImpl acti = (ActivityImpl)p.getDestination();
                SysActHiLine sysActHiLine = new SysActHiLine();
                sysActHiLine.setId(IdWorker.get32UUID());
                sysActHiLine.setProcInstId(executionEntity.getProcessInstanceId());
                sysActHiLine.setProcDefId(executionEntity.getProcessDefinitionId());
                sysActHiLine.setProcDefKey(executionEntity.getProcessDefinitionKey());
                sysActHiLine.setLineId(p.getId());
                sysActHiLine.setLineName(p.getProperty("name") == null ? "" : p.getProperty("name").toString());
                sysActHiLine.setCompleteTime(new Timestamp(System.currentTimeMillis()));
                sysActHiLine.setCompleteUser(userId);
                sysActHiLine.setProcessName(executionEntity.getProcessDefinition().getName());
                sysActHiLine.setInNode(acti.getId());
                sysActHiLine.setInNodeName(acti.getProperty("name") == null ? "" : acti.getProperty("name").toString());
                sysActHiLine.setOutNode(activity.getId());
                sysActHiLine.setOutNodeName(activity.getProperty("name") == null ? "" : activity.getProperty("name").toString());
                sysActHiLines.add(sysActHiLine);
                if (acti.getId().equals(executionEntity.getActivityId())) continue;
                this.installHiLine(acti, executionEntity, sysActHiLines, ids, userId);
            }
        }
        return sysActHiLines;
    }

    @Override
    public String queryProcessInstanceByKey(String processDefinitionKey, String businessKey, int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            ArrayList<ProcessInstance> insts = new ArrayList<ProcessInstance>();
            List deployments = this.repositoryService.createProcessDefinitionQuery().processDefinitionKeyLike("%" + processDefinitionKey + "%").latestVersion().list();
            for (int i = 0; i < deployments.size(); ++i) {
                List list = this.runtimeService.createProcessInstanceQuery().processDefinitionId(((ProcessDefinition)deployments.get(i)).getId()).processInstanceBusinessKey(businessKey).list();
                insts.addAll(list);
            }
            List<ProcessInstance> result = this.pageListSql(page, rows, insts);
            ArrayList mapList = new ArrayList();
            for (int i = 0; i < result.size(); ++i) {
                HashMap<String, Object> mapResult = new HashMap<String, Object>();
                ProcessInstance proins = result.get(i);
                mapResult.put("processDefinitionId", proins.getProcessDefinitionId());
                mapResult.put("processVariables", proins.getProcessVariables());
                mapResult.put("businessKey", proins.getBusinessKey());
                mapResult.put("deploymentId", proins.getDeploymentId());
                mapResult.put("description", proins.getDescription());
                mapResult.put("localizedDescription", proins.getLocalizedDescription());
                mapResult.put("name", proins.getName());
                mapResult.put("processDefinitionKey", proins.getProcessDefinitionKey());
                mapResult.put("processDefinitionName", proins.getProcessDefinitionName());
                mapResult.put("tenantId", proins.getTenantId());
                mapResult.put("isSuspended", proins.isSuspended());
                mapResult.put("processDefinitionVersion", proins.getProcessDefinitionVersion());
                mapResult.put("id", proins.getId());
                mapList.add(mapResult);
            }
            map.put("data", JSONArray.toJSONString(mapList));
            map.put("count", mapList.size());
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), JSON.toJSONString(map));
        }
    }

    @Override
    public String queryProcessInstanceList(int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List list = this.runtimeService.createProcessInstanceQuery().list();
            List<ProcessInstance> result = this.pageListSql(page, rows, list);
            ArrayList mapList = new ArrayList();
            for (int i = 0; i < result.size(); ++i) {
                HashMap<String, Object> mapResult = new HashMap<String, Object>();
                ProcessInstance proins = result.get(i);
                mapResult.put("processDefinitionId", proins.getProcessDefinitionId());
                mapResult.put("processVariables", proins.getProcessVariables());
                mapResult.put("businessKey", proins.getBusinessKey());
                mapResult.put("deploymentId", proins.getDeploymentId());
                mapResult.put("description", proins.getDescription());
                mapResult.put("localizedDescription", proins.getLocalizedDescription());
                mapResult.put("name", proins.getName());
                mapResult.put("processDefinitionKey", proins.getProcessDefinitionKey());
                mapResult.put("processDefinitionName", proins.getProcessDefinitionName());
                mapResult.put("tenantId", proins.getTenantId());
                mapResult.put("isSuspended", proins.isSuspended());
                mapResult.put("processDefinitionVersion", proins.getProcessDefinitionVersion());
                mapResult.put("id", proins.getId());
                mapList.add(mapResult);
            }
            map.put("data", JSONArray.toJSONString(mapList));
            map.put("count", mapList.size());
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), JSON.toJSONString(map));
        }
    }

    @Override
    public String updateProcessInstanceState(String operation, String processInstanceId) {
        HashMap mapResult = new HashMap();
        try {
            if ("suspend".equals(operation)) {
                this.runtimeService.suspendProcessInstanceById(processInstanceId);
            } else if ("active".equals(operation)) {
                this.runtimeService.activateProcessInstanceById(processInstanceId);
            }
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapResult));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), JSON.toJSONString(mapResult));
        }
    }

    @Override
    public String deleteProcessInstance(String processInstanceId, String reason) {
        HashMap mapResult = new HashMap();
        try {
            this.runtimeService.deleteProcessInstance(processInstanceId, reason);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapResult));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), JSON.toJSONString(mapResult));
        }
    }

    @Override
    public String backFlowProcessInstance(String currentTaskId, String destinationTaskId) {
        HashMap mapResult = new HashMap();
        try {
            HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(currentTaskId)).singleResult();
            HistoricTaskInstance destinationTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(destinationTaskId)).singleResult();
            ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult();
            if (instance == null) {
                return ServiceResult.getResult("0", "\u6d41\u7a0b\u5b9e\u4f8b\u4e3anull", mapResult.toString());
            }
            ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
            if (definition == null) {
                return ServiceResult.getResult("0", "\u6d41\u7a0b\u5b9a\u4e49\u4e3a\u7a7a", mapResult.toString());
            }
            ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
            ActivityImpl destinationActivity = definition.findActivity(destinationTask.getTaskDefinitionKey());
            ArrayList oriPvmTransitionList = new ArrayList();
            List pvmTransitionList = currActivity.getOutgoingTransitions();
            oriPvmTransitionList.addAll(pvmTransitionList);
            pvmTransitionList.clear();
            ArrayList<TransitionImpl> newTransitions = new ArrayList<TransitionImpl>();
            TransitionImpl newTransition = currActivity.createOutgoingTransition();
            newTransition.setDestination(destinationActivity);
            destinationActivity.getIncomingTransitions().remove(newTransition);
            newTransitions.add(newTransition);
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getId())).taskDefinitionKey(currTask.getTaskDefinitionKey())).list();
            for (Task task : tasks) {
                this.taskService.claim(task.getId(), task.getAssignee());
                this.taskService.complete(task.getId());
                this.historyService.deleteHistoricTaskInstance(task.getId());
            }
            for (TransitionImpl transitionImpl : newTransitions) {
                currActivity.getOutgoingTransitions().remove(transitionImpl);
            }
            pvmTransitionList.addAll(oriPvmTransitionList);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapResult));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), JSON.toJSONString(mapResult));
        }
    }

    @Override
    public String endProcessInstance(String taskId) {
        HashMap mapResult = new HashMap();
        try {
            TaskEntity task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
            ActivityImpl endActivity = null;
            for (ActivityImpl ac : processDefinition.getActivities()) {
                if (!"endEvent".equals(ac.getProperty("type"))) continue;
                endActivity = ac;
            }
            ActivityImpl currActivity = processDefinition.findActivity(task.getTaskDefinitionKey());
            ArrayList oriPvmTransitionList = new ArrayList();
            List pvmTransitionList = currActivity.getOutgoingTransitions();
            oriPvmTransitionList.addAll(pvmTransitionList);
            pvmTransitionList.clear();
            ArrayList<TransitionImpl> newTransitions = new ArrayList<TransitionImpl>();
            TransitionImpl newTransition = currActivity.createOutgoingTransition();
            newTransition.setDestination(endActivity);
            if (endActivity != null && endActivity.getIncomingTransitions() != null) {
                endActivity.getIncomingTransitions().remove(newTransition);
            }
            newTransitions.add(newTransition);
            this.taskService.complete(taskId);
            for (TransitionImpl transitionImpl : newTransitions) {
                currActivity.getOutgoingTransitions().remove(transitionImpl);
            }
            pvmTransitionList.addAll(oriPvmTransitionList);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapResult));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), JSON.toJSONString(mapResult));
        }
    }

    @Override
    public String queryFinishedProcessInstance(String processDefinitionId, String businessKey, int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List insts = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).processDefinitionId(processDefinitionId).finished().listPage((page - 1) * rows, rows);
            map.put("data", JSONArray.toJSONString((Object)insts));
            map.put("count", insts.size());
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), JSON.toJSONString(map));
        }
    }

    @Override
    public String queryProcessInstanceCompleteState(String processInstanceId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String isEnded = "true";
        try {
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (processInstance != null && !processInstance.isEnded()) {
                isEnded = "false";
            }
            map.put("isEnded", isEnded);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(map));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), JSON.toJSONString(map));
        }
    }

    @Override
    public void queryProcessInstancePicture(String processInstanceId, HttpServletResponse response) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        String processDefinitonId = processInstance.getProcessDefinitionId();
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitonId);
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).includeTaskLocalVariables()).includeProcessVariables()).list();
        HashMap map = new HashMap();
        map = taskList.size() == 0 ? this.queryPreActivitiesByTaskIdFinished(processInstanceId) : this.queryPreActivitiesByTaskId(taskList, processInstanceId, processDefinitonId);
        ArrayList<String> runningNode = new ArrayList<String>();
        for (Task task : taskList) {
            runningNode.add(task.getTaskDefinitionKey());
        }
        OutputStream os = null;
        InputStream is = null;
        try {
            is = new HMProcessDiagramGenerator(1.0).generateDiagram(bm, "png", (List)map.get("idList"), (List)map.get("lineList"), "\u96c5\u9ed1", "\u96c5\u9ed1", "\u96c5\u9ed1", null, 1.0, runningNode, (HashMap)map.get("typeMap"));
            int size = is.available();
            byte[] data = new byte[size];
            is.read(data);
            response.setContentType("image/png");
            response.setContentLength(size);
            os = response.getOutputStream();
            os.write(data);
            os.flush();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private HashMap queryPreActivitiesByTaskId(List taskList, String processInstanceId, String processDefinitonId) {
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitonId);
        List highLightedActivitList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("parallelGateway").finished().list();
        ArrayList<ActivityImpl> list = new ArrayList<ActivityImpl>();
        for (int i = 0; i < highLightedActivitList.size(); ++i) {
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)highLightedActivitList.get(i);
            ActivityImpl activity = def.findActivity(historicActivityInstance.getActivityId());
            List in = activity.getIncomingTransitions();
            if (in.size() <= 1) continue;
            list.add(activity);
        }
        try {
            List in;
            ActivityImpl activity;
            ArrayList<String> idList = new ArrayList<String>();
            ArrayList<String> lineList = new ArrayList<String>();
            HashMap<String, Object> typeMap = new HashMap<String, Object>();
            ArrayList<String> executionList = new ArrayList<String>();
            for (int i = 0; i < taskList.size(); ++i) {
                Task task = (Task)taskList.get(i);
                if (task == null) continue;
                executionList.add(task.getExecutionId());
                String activitiId = task.getTaskDefinitionKey();
                activity = def.findActivity(activitiId);
                in = activity.getIncomingTransitions();
                this.getPreActivities(processInstanceId, in, idList, lineList, typeMap);
            }
            List endEventActivitList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("endEvent").finished().list();
            if (endEventActivitList != null && endEventActivitList.size() > 0) {
                for (int i = 0; i < endEventActivitList.size(); ++i) {
                    HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)endEventActivitList.get(i);
                    activity = def.findActivity(historicActivityInstance.getActivityId());
                    in = activity.getIncomingTransitions();
                    this.getPreActivities(processInstanceId, in, idList, lineList, typeMap);
                    idList.add(activity.getId());
                    typeMap.put(activity.getId(), activity.getProperty("type"));
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                ActivityImpl activity2 = (ActivityImpl)list.get(i);
                List in2 = activity2.getIncomingTransitions();
                this.getParallelGatewayPreActivities(in2, idList, lineList, typeMap, executionList, processInstanceId);
            }
            map.put("idList", idList);
            map.put("lineList", lineList);
            map.put("typeMap", typeMap);
            return map;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return map;
        }
    }

    private HashMap queryPreActivitiesByTaskIdFinished(String processInstanceId) {
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        try {
            List historicTaskInstanceList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).orderByHistoricTaskInstanceEndTime().desc()).list();
            HistoricTaskInstance task = (HistoricTaskInstance)historicTaskInstanceList.get(0);
            if (task != null) {
                ActivityImpl activityImpl;
                ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
                ArrayList<String> idList = new ArrayList<String>();
                ArrayList<String> lineList = new ArrayList<String>();
                ArrayList<String> outLineList = new ArrayList<String>();
                HashMap<String, String> typeMap = new HashMap<String, String>();
                List list = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().finished().asc()).list();
                for (HistoricActivityInstance his : list) {
                    idList.add(his.getActivityId());
                    typeMap.put(his.getActivityId(), his.getActivityType());
                    activityImpl = processDefinition.findActivity(his.getActivityId());
                    List outgoing = activityImpl.getOutgoingTransitions();
                    for (PvmTransition pv : outgoing) {
                        outLineList.add(pv.getId());
                    }
                }
                for (HistoricActivityInstance his : list) {
                    activityImpl = processDefinition.findActivity(his.getActivityId());
                    List incoming = activityImpl.getIncomingTransitions();
                    for (PvmTransition pv : incoming) {
                        if (!outLineList.contains(pv.getId())) continue;
                        lineList.add(pv.getId());
                    }
                }
                map.put("idList", idList);
                map.put("lineList", lineList);
                map.put("typeMap", typeMap);
            }
            return map;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return map;
        }
    }

    private void getParallelGatewayPreActivities(List<PvmTransition> in, List<String> idList, List<String> lineList, HashMap<String, Object> typeMap, List<String> executionList, String processInstanceId) {
        for (PvmTransition pv : in) {
            PvmActivity source = pv.getSource();
            List highLightedActivitList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityId(source.getId()).list();
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)highLightedActivitList.get(0);
            if (executionList.indexOf(historicActivityInstance.getExecutionId()) != -1) continue;
            lineList.add(pv.getId());
            idList.add(source.getId());
            typeMap.put(source.getId(), source.getProperty("type"));
            List incoming = source.getIncomingTransitions();
            this.getPreActivities(processInstanceId, incoming, idList, lineList, typeMap);
        }
    }

    private void getPreActivities(String processInstanceId, List<PvmTransition> in, List<String> idList, List<String> lineList, HashMap<String, Object> typeMap) {
        List list = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceEndTime().finished().desc()).list();
        ArrayList<String> actList = new ArrayList<String>();
        for (HistoricActivityInstance hai : list) {
            actList.add(hai.getActivityId());
        }
        for (PvmTransition pv : in) {
            if (lineList.contains(pv.getId()) || !actList.contains(pv.getSource().getId())) continue;
            lineList.add(pv.getId());
            PvmActivity source = pv.getSource();
            idList.add(source.getId());
            typeMap.put(source.getId(), source.getProperty("type"));
            List incoming = source.getIncomingTransitions();
            if (incoming == null || incoming.size() <= 0) continue;
            this.getPreActivities(processInstanceId, incoming, idList, lineList, typeMap);
        }
    }

    @Override
    public String getProcessTrace(String processInstanceId) {
        ArrayList activityInfos = new ArrayList();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("userTask").orderByHistoricActivityInstanceStartTime().desc()).finished().list();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        for (ActivityImpl activity : activitiList) {
            HashMap<String, Object> activityInfo = new HashMap<String, Object>();
            activityInfo.put("width", activity.getWidth());
            activityInfo.put("height", activity.getHeight());
            activityInfo.put("x", activity.getX());
            activityInfo.put("y", activity.getY());
            activityInfo.put("actId", activity.getId());
            if (activity.getProperty("name") == null || "".equals(activity.getProperty("name").toString())) {
                activityInfo.put("name", "\u672a\u8bbe\u7f6e");
            } else {
                activityInfo.put("name", activity.getProperty("name"));
            }
            List taskList = null;
            if (tasks != null && tasks.size() > 0) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && taskList.size() > 0) {
                Set<String> user = this.getAssigneeByTaskId(((Task)taskList.get(0)).getId());
                if (user != null && user.size() > 0) {
                    String assignee = this.iAssigneeChooseService.getUsers(Arrays.asList(user.toArray()));
                    activityInfo.put("assignee", assignee);
                } else {
                    activityInfo.put("assignee", "\u65e0\u4efb\u52a1\u63a5\u6536\u4eba");
                }
                activityInfo.put("execution", "currentNode");
            } else {
                List hisActivitList = null;
                if (hisList != null && hisList.size() > 0) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getActivityId().equals(activity.getId())).collect(Collectors.toList());
                }
                HashMap<String, String> userInfo = new HashMap<String, String>();
                HashMap<String, Date> timeInfo = new HashMap<String, Date>();
                HashMap<String, String> commentInfo = new HashMap<String, String>();
                List<String> userList = new ArrayList<String>();
                if (hisActivitList != null && hisActivitList.size() > 0) {
                    userList = hisActivitList.stream().map(HistoricActivityInstance::getAssignee).filter(x -> x != null).collect(Collectors.toList());
                }
                Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
                if (hisActivitList == null || hisActivitList.size() <= 0) continue;
                for (int i = 0; i < hisActivitList.size(); ++i) {
                    List comments;
                    HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)hisActivitList.get(i);
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if ((comments = this.taskService.getTaskComments(historicActivityInstance.getTaskId(), "complete")) != null && comments.size() > 0) {
                        commentInfo.put(historicActivityInstance.getId(), ((Comment)comments.get(0)).getFullMessage() == null ? "\u65e0\u5ba1\u6279\u610f\u89c1" : ((Comment)comments.get(0)).getFullMessage());
                    } else {
                        commentInfo.put(historicActivityInstance.getId(), "\u65e0\u5ba1\u6279\u610f\u89c1");
                    }
                    userInfo.put(historicActivityInstance.getId(), user);
                    timeInfo.put(historicActivityInstance.getId(), historicActivityInstance.getEndTime());
                }
                activityInfo.put("commentInfo", commentInfo);
                activityInfo.put("userInfo", userInfo);
                activityInfo.put("timeInfo", timeInfo);
                activityInfo.put("execution", "finishedNode");
            }
            activityInfo.put("type", activity.getProperty("type"));
            activityInfos.add(activityInfo);
        }
        return ServiceResult.getResult("1", "success", JSONArray.toJSONString(activityInfos));
    }

    @Override
    public String getAllProcessTrace(String processInstanceId) {
        ArrayList list = new ArrayList();
        List<String> userList = new ArrayList<String>();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(x -> x != null).collect(Collectors.toList());
        }
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                List comments;
                HashMap<String, Object> map = new HashMap<String, Object>();
                String user = "";
                if (hsi.getAssignee() != null) {
                    user = finalUsersMap.get(hsi.getAssignee());
                }
                if (StringUtils.isEmpty((CharSequence)user)) {
                    user = "\u81ea\u52a8\u8df3\u8fc7\u8282\u70b9";
                }
                if ((comments = this.taskService.getTaskComments(hsi.getId(), "complete")) != null && comments.size() > 0) {
                    map.put("comments", ((Comment)comments.get(0)).getFullMessage() == null ? "\u65e0\u5ba1\u6279\u610f\u89c1" : ((Comment)comments.get(0)).getFullMessage());
                } else {
                    map.put("comments", "\u65e0\u5ba1\u6279\u610f\u89c1");
                }
                Map variables = hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                map.put("startTime", sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    map.put("assignee", user);
                    map.put("endTime", sdf.format(hsi.getEndTime()));
                    if (variables != null) {
                        map.put("taskSourceFlag", TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag") == null ? "skip" : variables.get("taskSourceFlag")));
                    } else {
                        map.put("taskSourceFlag", "");
                    }
                } else {
                    map.put("endTime", "");
                    Set<String> users = this.getAssigneeByTaskId(hsi.getId());
                    if (user != null && users.size() > 0) {
                        String assignee = this.iAssigneeChooseService.getUsers(Arrays.asList(users.toArray()));
                        map.put("assignee", assignee);
                    }
                    map.put("comments", "");
                    map.put("taskSourceFlag", "");
                }
                map.put("activityName", hsi.getName());
                map.put("activityId", hsi.getId());
                map.put("processDefinitionId", hsi.getProcessDefinitionId());
                map.put("processInstanceId", hsi.getProcessInstanceId());
                map.put("variables", variables);
                list.add(map);
            }
        }
        return ServiceResult.getResult("1", "success", JSON.toJSONString(list));
    }

    @Override
    public String queryProcessDefinitionByInstanceId(String processInstanceId) {
        try {
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
            ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
            processDefinitionModel.setKey(processDefinition.getKey());
            processDefinitionModel.setDescription(processDefinition.getDescription());
            processDefinitionModel.setVersion(String.valueOf(processDefinition.getVersion()));
            processDefinitionModel.setResourceName(processDefinition.getResourceName());
            processDefinitionModel.setDeploymentId(processDefinition.getDeploymentId());
            processDefinitionModel.setDiagramResourceName(processDefinition.getDiagramResourceName());
            processDefinitionModel.setHasStartFormKey(String.valueOf(processDefinition.hasStartFormKey()));
            processDefinitionModel.setHasGraphicalNotation(String.valueOf(processDefinition.hasGraphicalNotation()));
            processDefinitionModel.setIsSuspended(String.valueOf(processDefinition.isSuspended()));
            processDefinitionModel.setTenantId(processDefinition.getTenantId());
            return ServiceResult.getResult("1", "1", JSONArray.toJSONString((Object)processDefinition));
        }
        catch (Exception e) {
            return ServiceResult.getResult("0", e.getMessage(), "");
        }
    }

    private List<ProcessInstance> pageListSql(int pageNumber, int pageSize, List<ProcessInstance> list) {
        ArrayList<ProcessInstance> data = new ArrayList<ProcessInstance>();
        int start = (pageNumber - 1) * pageSize;
        int end = start + pageSize;
        if (list != null && list.size() > 0) {
            int l = list.size();
            for (int i = 0; i < l; ++i) {
                if (start > i || i >= end) continue;
                data.add(list.get(i));
            }
        }
        return data;
    }

    private List<String> getHighLightedFlows(String processDefinitionId, List<HistoricActivityInstance> historicActivityInstances) {
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
        ArrayList<String> highFlows = new ArrayList<String>();
        for (int i = 0; i < historicActivityInstances.size() - 1; ++i) {
            ActivityImpl activityImpl = processDefinitionEntity.findActivity(historicActivityInstances.get(i).getActivityId());
            ArrayList<ActivityImpl> sameStartTimeNodes = new ArrayList<ActivityImpl>();
            ActivityImpl sameActivityImpl1 = processDefinitionEntity.findActivity(historicActivityInstances.get(i + 1).getActivityId());
            sameStartTimeNodes.add(sameActivityImpl1);
            for (int j = i + 1; j < historicActivityInstances.size() - 1; ++j) {
                HistoricActivityInstance activityImpl1 = historicActivityInstances.get(j);
                HistoricActivityInstance activityImpl2 = historicActivityInstances.get(j + 1);
                if (!activityImpl1.getStartTime().equals(activityImpl2.getStartTime())) break;
                ActivityImpl sameActivityImpl2 = processDefinitionEntity.findActivity(activityImpl2.getActivityId());
                sameStartTimeNodes.add(sameActivityImpl2);
            }
            List pvmTransitions = activityImpl.getOutgoingTransitions();
            for (PvmTransition pvmTransition : pvmTransitions) {
                ActivityImpl pvmActivityImpl = (ActivityImpl)pvmTransition.getDestination();
                if (!sameStartTimeNodes.contains(pvmActivityImpl)) continue;
                highFlows.add(pvmTransition.getId());
            }
        }
        return highFlows;
    }

    @Override
    public String queryVariable(String processInstId) {
        HashMap mapStr = new HashMap();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List hisVariable = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstId).list();
            if (hisVariable.size() > 0) {
                for (int i = 0; i < hisVariable.size(); ++i) {
                    map.put(((HistoricVariableInstance)hisVariable.get(i)).getVariableName(), ((HistoricVariableInstance)hisVariable.get(i)).getValue());
                }
            }
            mapStr.put("data", map);
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), JSON.toJSONString(map));
        }
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    @Override
    public String editVariable(String taskId, HashMap map) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        try {
            if (map != null) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    String key = entry.getKey().toString();
                    String value = entry.getValue().toString();
                    this.taskService.setVariable(taskId, key, (Object)value);
                }
            }
            mapStr.put("flag", "true");
            return ServiceResult.getResult("1", "success", JSON.toJSONString(mapStr));
        }
        catch (Exception e) {
            mapStr.put("flag", "false");
            LOGGER.error(e.getMessage());
            return ServiceResult.getResult("0", e.getMessage(), JSON.toJSONString((Object)map));
        }
    }

    static {
        TASK_SOURCE_FLAG.put("complete", "\u529e\u7406");
        TASK_SOURCE_FLAG.put("skip", "\u8df3\u8fc7");
        TASK_SOURCE_FLAG.put("revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("reject", "\u9a73\u56de");
    }
}

