/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.processcount.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.processcount.dao.ProcessCountMapper;
import com.jxdinfo.hussar.bpm.processcount.model.ProcessCount;
import com.jxdinfo.hussar.bpm.processcount.service.ProcessCountService;
import com.jxdinfo.hussar.bpm.processimage.utils.HMProcessDiagramGenerator;
import com.jxdinfo.hussar.bpm.rest.dao.TaskWebMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessCountServiceImpl
implements ProcessCountService {
    @Resource
    private TaskWebMapper taskWebMapper;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessCountMapper processCountMapper;
    private final String USERTASK = "userTask";

    @Override
    public List<Map> getAllTackCout(String userId) {
        return this.taskWebMapper.getUserTask(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadProcessImage(String definitionKey, HttpServletResponse response) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(definitionKey).latestVersion().singleResult();
        HMProcessDiagramGenerator hmProcessDiagramGenerator = new HMProcessDiagramGenerator();
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinition.getId());
        OutputStream os = null;
        try {
            InputStream is = hmProcessDiagramGenerator.generateDiagram(bm, "png", new ArrayList(), new ArrayList(), "\u96c5\u9ed1", "\u96c5\u9ed1", "\u96c5\u9ed1", null, 1.0, new ArrayList<String>(), new HashMap());
            int size = is.available();
            byte[] data = new byte[size];
            is.read(data);
            response.setContentType("image/png");
            os = response.getOutputStream();
            os.write(data);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public JSONArray loadNodeCount(String definitionKey) {
        JSONArray jsonArray = new JSONArray();
        HashMap map = new HashMap();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(definitionKey).latestVersion().singleResult();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinition.getId());
        List<Map> list = this.processCountMapper.getProcessNodeCount("", definitionKey);
        if (list != null && list.size() > 0) {
            for (Map m : list) {
                map.put(m.get("TASKDEFKEY").toString(), m.get("COUNTNUM"));
            }
        }
        List activitiList = processDefinitionEntity.getActivities();
        for (ActivityImpl activity : activitiList) {
            JSONObject object = new JSONObject();
            if (!"userTask".equals(activity.getProperty("type"))) continue;
            object.put("width", (Object)activity.getWidth());
            object.put("height", (Object)activity.getHeight());
            object.put("x", (Object)activity.getX());
            object.put("y", (Object)activity.getY());
            object.put("actId", (Object)activity.getId());
            object.put("num", (Object)(map.get(activity.getId()) == null ? "0" : map.get(activity.getId())));
            jsonArray.add((Object)object);
        }
        return jsonArray;
    }

    @Override
    public Map<String, Object> nodeTaskList(String userId, String definitionKey) {
        List<ProcessCount> list = this.processCountMapper.nodeTaskList(userId, definitionKey);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("count", list.size());
        map.put("code", 0);
        map.put("msg", "success");
        map.put("data", list);
        return map;
    }
}

