/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.bpm.impmodle.model.ImpAttachment;
import com.jxdinfo.hussar.bpm.impmodle.model.ImpModle;
import com.jxdinfo.hussar.bpm.impmodle.service.ImpModleService;
import com.jxdinfo.hussar.bpm.rest.service.ProcessModelService;
import com.jxdinfo.hussar.common.properties.HussarBpmProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"model"})
public class ModelController
extends BaseController {
    @Resource
    private ProcessModelService processModelService;
    @Resource
    private ImpModleService impModleService;
    private static final String status = "1";
    @Autowired
    private HussarBpmProperties hussarProperties;

    @RequestMapping(value={"/goView"})
    public ModelAndView goView() {
        return new ModelAndView("/bpm/model/modelquery/modelQuery.html");
    }

    @RequestMapping(value={"/modelQuery"})
    public Map<String, Object> queryModelList(@RequestParam(required=false) String name, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer limit) {
        try {
            return this.processModelService.queryModelList(name, page, limit);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelDelete"})
    public String deleteModel(@RequestParam(value="modelId") String modelId) {
        try {
            String[] id = modelId.split(",");
            String result = "";
            for (int i = 0; i < id.length; ++i) {
                result = this.processModelService.deleteModel(id[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelCreate"})
    public void createModel(HttpServletRequest request, HttpServletResponse response) {
        try {
            String str = this.processModelService.createModel();
            com.alibaba.fastjson.JSONObject jsonobject = JSON.parseObject((String)str);
            String result = jsonobject.get((Object)"result").toString();
            com.alibaba.fastjson.JSONObject job = JSON.parseObject((String)result);
            String modelId = job.get((Object)"modelId").toString();
            response.sendRedirect(request.getContextPath() + "/static/modeler.html?modelId=" + modelId);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelEdit"})
    public void modelEdit(@RequestParam(value="modelId") String modelId, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.sendRedirect(request.getContextPath() + "/static/modeler.html?modelId=" + modelId);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/modelDeploy"})
    public String deployModel(@RequestParam(value="modelId") String modelId) {
        try {
            return this.processModelService.deployModel(modelId);
        }
        catch (Exception e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/modelImport"})
    public String importModel(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        String userId = request.getSession().getAttribute("userId") == null ? "" : request.getSession().getAttribute("userId").toString();
        InputStream in = null;
        String result = "";
        FileOutputStream fos = null;
        try {
            String fileName = System.currentTimeMillis() + ".xml";
            String attachRealName = file.getOriginalFilename();
            in = file.getInputStream();
            File file1 = new File(this.hussarProperties.getFileUploadPath());
            if (!file1.exists()) {
                file1.mkdirs();
            }
            fos = new FileOutputStream(this.hussarProperties.getFileUploadPath() + File.separator + fileName);
            byte[] b = new byte[1024];
            while (in.read(b) != -1) {
                fos.write(b);
            }
            in.close();
            fos.close();
            Date day = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String impTime = df.format(day);
            ImpAttachment impAttachment = new ImpAttachment();
            String attachId = UUID.randomUUID().toString();
            impAttachment.setAttachId(attachId);
            impAttachment.setAttachName(fileName);
            impAttachment.setAttachRealName(attachRealName);
            impAttachment.setAttachPath(this.hussarProperties.getFileUploadPath() + File.separator + fileName);
            impAttachment.setAttachType("xml");
            impAttachment.setImpAttachTime(impTime);
            impAttachment.setImpAttachUser(userId);
            this.impModleService.saveAttachmentInfo(impAttachment);
            result = this.processModelService.importModel(file);
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            if (ToolUtil.equals((Object)status, (Object)jsonObject.get("code"))) {
                String data = jsonObject.get("result") == null ? "" : jsonObject.get("result").toString();
                JSONObject json = JSONObject.fromObject((Object)data);
                String impModleId = json.get("modelKey") == null ? "" : json.get("modelKey").toString();
                String impModleName = json.get("modelName") == null ? "" : json.get("modelName").toString();
                ImpModle impModle = new ImpModle();
                impModle.setAttachId(attachId);
                impModle.setImpId(UUID.randomUUID().toString());
                impModle.setImpModleId(impModleId);
                impModle.setImpModleName(impModleName);
                impModle.setImpUser(userId);
                impModle.setImpTime(impTime);
                this.impModleService.saveImpInfo(impModle);
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/export"})
    public void export(@RequestParam(value="modelId") String modelId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        String[] ids = modelId.split(",");
        if (ids.length > 1) {
            ZipOutputStream zipOutputStream = null;
            ByteArrayInputStream in = null;
            try {
                response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
                response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
                zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i];
                    String export = this.processModelService.exportModel(id);
                    com.alibaba.fastjson.JSONObject map = com.alibaba.fastjson.JSONObject.parseObject((String)export);
                    String result = map.get("result").toString();
                    com.alibaba.fastjson.JSONObject map1 = com.alibaba.fastjson.JSONObject.parseObject((String)result);
                    String filename = map1.get("filename").toString();
                    byte[] bpmnBytes = map1.get("bpmnBytes").toString().getBytes("UTF8");
                    in = new ByteArrayInputStream(bpmnBytes);
                    ZipEntry zipEntry = new ZipEntry(filename);
                    zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
                    IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
                    in.close();
                }
                zipOutputStream.flush();
                zipOutputStream.closeEntry();
                zipOutputStream.close();
            }
            catch (Exception e) {
                throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
            }
            finally {
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        ByteArrayInputStream in = null;
        OutputStream out1 = null;
        try {
            String export = this.processModelService.exportModel(modelId);
            com.alibaba.fastjson.JSONObject map = com.alibaba.fastjson.JSONObject.parseObject((String)export);
            String result = map.get("result").toString();
            com.alibaba.fastjson.JSONObject map1 = com.alibaba.fastjson.JSONObject.parseObject((String)result);
            String filename = map1.get("filename").toString();
            byte[] bpmnBytes = map1.get("bpmnBytes").toString().getBytes("UTF8");
            in = new ByteArrayInputStream(bpmnBytes);
            byte[] b = new byte[1024];
            int len = -1;
            out1 = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
            response.setContentType("application/octet-stream");
            while ((len = in.read(b, 0, 1024)) != -1) {
                out1.write(b, 0, len);
            }
            out1.flush();
        }
        catch (Exception e) {
            PrintWriter out = null;
            try {
                out = response.getWriter();
            }
            catch (IOException ee) {
                ee.printStackTrace();
            }
            out.write("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out1 != null) {
                try {
                    out1.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/batchImport"})
    public String batchImport(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        String userId = request.getSession().getAttribute("userId").toString();
        String result = "";
        InputStream in = null;
        FileOutputStream fos = null;
        String fileName = System.currentTimeMillis() + ".zip";
        String attachRealName = file.getOriginalFilename();
        try {
            in = file.getInputStream();
            fos = new FileOutputStream(this.hussarProperties.getFileUploadPath() + File.separator + fileName);
            byte[] b = new byte[1024];
            while (in.read(b) != -1) {
                fos.write(b);
            }
            in.close();
            fos.close();
            List<String> fileList = this.unZipFile(this.hussarProperties.getFileUploadPath() + File.separator + fileName, this.hussarProperties.getFileUploadPath(), request);
            Date day = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String impTime = df.format(day);
            ImpAttachment impAttachment = new ImpAttachment();
            String attachId = UUID.randomUUID().toString();
            impAttachment.setAttachId(attachId);
            impAttachment.setAttachName(fileName);
            impAttachment.setAttachRealName(attachRealName);
            impAttachment.setAttachPath(this.hussarProperties.getFileUploadPath() + File.separator + fileName);
            impAttachment.setAttachType("zip");
            impAttachment.setImpAttachTime(impTime);
            impAttachment.setImpAttachUser(userId);
            this.impModleService.saveAttachmentInfo(impAttachment);
            for (int i = 0; i < fileList.size(); ++i) {
                FileInputStream fis = new FileInputStream(fileList.get(i));
                result = this.processModelService.batchImportModel(fis);
                JSONObject jsonObject = JSONObject.fromObject((Object)result);
                if (!status.equals(jsonObject.get("code"))) continue;
                String data = jsonObject.get("result") == null ? "" : jsonObject.get("result").toString();
                JSONObject json = JSONObject.fromObject((Object)data);
                String impModleId = json.get("modelKey") == null ? "" : json.get("modelKey").toString();
                String impModleName = json.get("modelName") == null ? "" : json.get("modelName").toString();
                ImpModle impModle = new ImpModle();
                impModle.setImpId(UUID.randomUUID().toString());
                impModle.setAttachId(attachId);
                impModle.setImpModleId(impModleId);
                impModle.setImpModleName(impModleName);
                impModle.setImpUser(userId);
                impModle.setImpTime(impTime);
                this.impModleService.saveImpInfo(impModle);
            }
        }
        catch (Exception e) {
            String string = result;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> unZipFile(String zipFile, String filePath, HttpServletRequest request) {
        String clientChartSet = request.getCharacterEncoding();
        ArrayList<String> resultList = new ArrayList<String>();
        InputStream in = null;
        OutputStream out = null;
        try {
            File pathFile = new File(filePath);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            ZipFile zip = new ZipFile(zipFile, "UTF-8");
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                in = zip.getInputStream(entry);
                String outPath = (filePath + new String(zipEntryName.getBytes(clientChartSet))).replaceAll("\\*", File.separator);
                int lastIndex = 0;
                lastIndex = outPath.lastIndexOf(File.separator) != -1 ? outPath.lastIndexOf(File.separator) : outPath.lastIndexOf("/");
                File file = new File(outPath.substring(0, lastIndex));
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                resultList.add(outPath);
                out = new FileOutputStream(outPath);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    out.write(buf1, 0, len);
                }
                in.close();
                out.close();
            }
            zip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }
}

