/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.listener;

import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.utils.BpmConstant;
import com.jxdinfo.hussar.bpm.processentrust.service.ITEntrustService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HussarBpmListener
implements ActivitiEventListener {
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ITEntrustService itEntrustService;

    public void onEvent(ActivitiEvent activitiEvent) {
        ActivitiEntityEventImpl activitiEntityEvent = (ActivitiEntityEventImpl)activitiEvent;
        TaskEntity task = (TaskEntity)activitiEntityEvent.getEntity();
        String processDefinitionId = task.getProcessDefinitionId();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)BpmConstant.repositoryService).getDeployedProcessDefinition(processDefinitionId);
        BpmnModel bm = BpmConstant.repositoryService.getBpmnModel(processDefinitionId);
        if (bm != null) {
            List<String> list = this.getCandidateUser(bm, task);
            Map<String, String> map = this.itEntrustService.queryByUsers(list, processDefinition.getProcessDefinition().getKey());
            ArrayList<String> finalList = new ArrayList<String>();
            if (list != null && list.size() > 0) {
                for (String id : list) {
                    if (ToolUtil.isNotEmpty((Object)map.get(id))) {
                        finalList.add(map.get(id));
                        continue;
                    }
                    finalList.add(id);
                }
            }
            task.addCandidateUsers(finalList);
        }
    }

    private List<String> getCandidateUser(BpmnModel bm, TaskEntity task) {
        boolean currentdept;
        List hisActivitList;
        boolean skipUserTask;
        if (task == null) {
            return null;
        }
        String userId = "";
        List<String> deptsList = null;
        List<String> rolesList = null;
        ArrayList<String> humanList = new ArrayList();
        List<String> userList = new ArrayList<String>();
        ExecutionEntity execution = task.getExecution();
        Expression expression = task.getTaskDefinition().getSkipExpression();
        String nodeId = task.getTaskDefinitionKey();
        String processInstanceId = task.getProcessInstanceId();
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(nodeId).getExtensionElements();
        boolean bl = skipUserTask = SkipExpressionUtil.isSkipExpressionEnabled((ActivityExecution)execution, (Expression)expression) && SkipExpressionUtil.shouldSkipFlowElement((ActivityExecution)execution, (Expression)expression);
        if (skipUserTask) {
            return null;
        }
        String assignmentnode = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("assignmentnode")).get(0)).getAttributes().get("assignmentnode")).get(0)).getValue();
        if (StringUtils.isNotEmpty((String)assignmentnode) && (hisActivitList = ((HistoricActivityInstanceQuery)BpmConstant.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityId(assignmentnode).orderByHistoricActivityInstanceStartTime().desc()).list()) != null && hisActivitList.size() > 0 && StringUtils.isNotEmpty((String)((HistoricActivityInstance)hisActivitList.get(0)).getAssignee())) {
            userList.add(((HistoricActivityInstance)hisActivitList.get(0)).getAssignee());
            return userList;
        }
        Map extensionAttribute = ((Process)bm.getProcesses().get(0)).getFlowElement(nodeId).getAttributes();
        List deptAttribute = (List)extensionAttribute.get("candidateDepts");
        List roleAttribute = (List)extensionAttribute.get("candidateRoles");
        List userAttribute = (List)extensionAttribute.get("candidateHumans");
        if (deptAttribute != null && deptAttribute.size() > 0) {
            String candidateDepts = ((ExtensionAttribute)deptAttribute.get(0)).getValue();
            deptsList = Arrays.asList(candidateDepts.split(","));
        }
        if (roleAttribute != null && roleAttribute.size() > 0) {
            String candidateRoles = ((ExtensionAttribute)roleAttribute.get(0)).getValue();
            rolesList = Arrays.asList(candidateRoles.split(","));
        }
        if (userAttribute != null && userAttribute.size() > 0) {
            String candidateUsers = ((ExtensionAttribute)userAttribute.get(0)).getValue();
            humanList = Arrays.asList(candidateUsers.split(","));
        }
        if (currentdept = Boolean.parseBoolean(((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("currentdept")).get(0)).getAttributes().get("currentdept")).get(0)).getValue())) {
            String dept = "";
            Map variables = task.getVariables();
            if (variables != null) {
                String string = dept = variables.get("flow_start_dept") == null ? "" : variables.get("flow_start_dept").toString();
            }
            if (ToolUtil.isNotEmpty((Object)dept)) {
                deptsList = new ArrayList<String>();
                deptsList.add(dept);
            } else {
                List identityLink = BpmConstant.processEngine.getHistoryService().getHistoricIdentityLinksForProcessInstance(processInstanceId);
                for (HistoricIdentityLink il : identityLink) {
                    if (!"starter".equals(il.getType())) continue;
                    userId = il.getUserId() == null ? "" : il.getUserId();
                    break;
                }
                deptsList = this.iAssigneeChooseService.getFlowStarterDept(userId);
            }
        }
        userList = this.iAssigneeChooseService.getUserList(deptsList, rolesList, humanList, currentdept);
        return userList;
    }

    public boolean isFailOnException() {
        return false;
    }
}

