/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.extend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.UserTaskJsonConverter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ExtendUserTaskJsonConverter
extends UserTaskJsonConverter {
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        List candidateUsers;
        JsonNode assignmentDefNode;
        UserTask userTask = (UserTask)super.convertJsonToElement(elementNode, modelNode, shapeMap);
        ExtensionElement extensionElementNode = new ExtensionElement();
        ExtensionAttribute extensionAttributeNode = new ExtensionAttribute();
        String assignmentnode = this.getPropertyValueAsString("assignmentnode", elementNode);
        extensionElementNode.setName("assignmentnode");
        extensionElementNode.setNamespacePrefix("extend");
        extensionElementNode.setNamespace("http://activiti.org/bpmn");
        extensionAttributeNode.setName("assignmentnode");
        extensionAttributeNode.setValue(assignmentnode);
        extensionElementNode.addAttribute(extensionAttributeNode);
        userTask.addExtensionElement(extensionElementNode);
        ExtensionElement deptextensionElement = new ExtensionElement();
        ExtensionAttribute deptextensionAttribute = new ExtensionAttribute();
        boolean currentdept = this.getPropertyValueAsBoolean("currentdept", elementNode);
        deptextensionElement.setName("currentdept");
        deptextensionElement.setNamespacePrefix("extend");
        deptextensionElement.setNamespace("http://activiti.org/bpmn");
        deptextensionAttribute.setName("currentdept");
        deptextensionAttribute.setValue(Boolean.toString(currentdept));
        deptextensionElement.addAttribute(deptextensionAttribute);
        userTask.addExtensionElement(deptextensionElement);
        boolean skipNode = this.getPropertyValueAsBoolean("skiprepetition", elementNode);
        ExtensionElement skipextensionElement = new ExtensionElement();
        ExtensionAttribute skipextensionAttribute = new ExtensionAttribute();
        skipextensionElement.setName("skiprepetition");
        skipextensionElement.setNamespacePrefix("extend");
        skipextensionElement.setNamespace("http://activiti.org/bpmn");
        skipextensionAttribute.setName("skiprepetition");
        skipextensionAttribute.setValue(Boolean.toString(skipNode));
        skipextensionElement.addAttribute(skipextensionAttribute);
        userTask.addExtensionElement(skipextensionElement);
        String overrideid = this.getPropertyValueAsString("overrideid", elementNode);
        if (StringUtils.isEmpty((String)overrideid)) {
            overrideid = elementNode.get("resourceId").asText();
        }
        overrideid = overrideid.replaceAll("-", "");
        if (skipNode) {
            userTask.setSkipExpression("${" + overrideid + "}");
        } else {
            userTask.setSkipExpression("");
        }
        JsonNode assignmentNode = this.getProperty("usertaskassignment", elementNode);
        if (assignmentNode != null && !assignmentNode.isNull() && (assignmentDefNode = assignmentNode.get("assignment")) != null && !assignmentDefNode.isNull()) {
            List roleList;
            List deptList = this.getValueAsList("candidateDepts", assignmentDefNode);
            if (deptList != null && deptList.size() > 0) {
                ExtensionAttribute extensionAttributeDept = new ExtensionAttribute();
                extensionAttributeDept.setName("candidateDepts");
                extensionAttributeDept.setNamespacePrefix("extend");
                extensionAttributeDept.setNamespace("http://activiti.org/bpmn");
                extensionAttributeDept.setValue(StringUtils.join((Object[])deptList.toArray(), (String)","));
                userTask.addAttribute(extensionAttributeDept);
            }
            if ((roleList = this.getValueAsList("candidateRoles", assignmentDefNode)) != null && roleList.size() > 0) {
                ExtensionAttribute extensionAttributeRole = new ExtensionAttribute();
                extensionAttributeRole.setName("candidateRoles");
                extensionAttributeRole.setNamespacePrefix("extend");
                extensionAttributeRole.setNamespace("http://activiti.org/bpmn");
                extensionAttributeRole.setValue(StringUtils.join((Object[])roleList.toArray(), (String)","));
                userTask.addAttribute(extensionAttributeRole);
            }
        }
        if ((candidateUsers = userTask.getCandidateUsers()) != null && candidateUsers.size() > 0) {
            userTask.setCandidateUsers(null);
            ExtensionAttribute extensionAttributeUser = new ExtensionAttribute();
            extensionAttributeUser.setName("candidateHumans");
            extensionAttributeUser.setNamespacePrefix("extend");
            extensionAttributeUser.setNamespace("http://activiti.org/bpmn");
            extensionAttributeUser.setValue(StringUtils.join((Object[])candidateUsers.toArray(), (String)","));
            userTask.addAttribute(extensionAttributeUser);
        }
        return userTask;
    }

    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        UserTask userTask = (UserTask)baseElement;
        String assignee = userTask.getAssignee();
        String owner = userTask.getOwner();
        Map stringListMap = userTask.getAttributes();
        Map elementsListMap = userTask.getExtensionElements();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)assignee) || org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)owner) || CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers()) || CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups()) || stringListMap != null) {
            ObjectNode candidateNode;
            ArrayNode candidateArrayNode;
            ObjectNode assignmentNode = this.objectMapper.createObjectNode();
            ObjectNode assignmentValuesNode = this.objectMapper.createObjectNode();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)assignee)) {
                assignmentValuesNode.put("assignee", assignee);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)owner)) {
                assignmentValuesNode.put("owner", owner);
            }
            if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers())) {
                candidateArrayNode = this.objectMapper.createArrayNode();
                for (String candidateUser : userTask.getCandidateUsers()) {
                    candidateNode = this.objectMapper.createObjectNode();
                    candidateNode.put("value", candidateUser);
                    candidateNode.put("type", "userTree");
                    candidateArrayNode.add((JsonNode)candidateNode);
                }
                assignmentValuesNode.put("candidateUsers", (JsonNode)candidateArrayNode);
            }
            if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups())) {
                candidateArrayNode = this.objectMapper.createArrayNode();
                for (String candidateGroup : userTask.getCandidateGroups()) {
                    candidateNode = this.objectMapper.createObjectNode();
                    candidateNode.put("value", candidateGroup);
                    candidateArrayNode.add((JsonNode)candidateNode);
                }
                assignmentValuesNode.put("candidateGroups", (JsonNode)candidateArrayNode);
            }
            if (stringListMap != null) {
                List userList;
                String[] ids;
                List deptList;
                List roleList = (List)stringListMap.get("candidateRoles");
                if (roleList != null && roleList.size() > 0) {
                    String[] ids2;
                    ArrayNode candidateArrayNode2 = this.objectMapper.createArrayNode();
                    String roleId = ((ExtensionAttribute)roleList.get(0)).getValue();
                    for (String id : ids2 = roleId.split(",")) {
                        ObjectNode candidateNode2 = this.objectMapper.createObjectNode();
                        candidateNode2.put("value", id);
                        candidateNode2.put("type", "roleTree");
                        candidateArrayNode2.add((JsonNode)candidateNode2);
                    }
                    assignmentValuesNode.put("candidateRoles", (JsonNode)candidateArrayNode2);
                }
                if ((deptList = (List)stringListMap.get("candidateDepts")) != null && deptList.size() > 0) {
                    ArrayNode candidateArrayNode3 = this.objectMapper.createArrayNode();
                    String deptId = ((ExtensionAttribute)deptList.get(0)).getValue();
                    for (String id : ids = deptId.split(",")) {
                        ObjectNode candidateNode3 = this.objectMapper.createObjectNode();
                        candidateNode3.put("value", id);
                        candidateNode3.put("type", "deptTree");
                        candidateArrayNode3.add((JsonNode)candidateNode3);
                    }
                    assignmentValuesNode.put("candidateDepts", (JsonNode)candidateArrayNode3);
                }
                if ((userList = (List)stringListMap.get("candidateHumans")) != null && userList.size() > 0) {
                    String userId = ((ExtensionAttribute)userList.get(0)).getValue();
                    ids = userId.split(",");
                    userTask.setCandidateUsers(Arrays.asList(ids));
                }
            }
            assignmentNode.put("assignment", (JsonNode)assignmentValuesNode);
            propertiesNode.put("usertaskassignment", (JsonNode)assignmentNode);
        }
        if (elementsListMap != null) {
            List skipElement;
            List currentdeptElement;
            List assignmentnodeElement = (List)elementsListMap.get("assignmentnode");
            if (assignmentnodeElement != null && assignmentnodeElement.size() > 0) {
                List assignmentnodeList;
                String assignmentNode = "";
                Map assignmentnodeMap = ((ExtensionElement)assignmentnodeElement.get(0)).getAttributes();
                if (assignmentnodeMap != null && (assignmentnodeList = (List)assignmentnodeMap.get("assignmentnode")) != null && assignmentnodeList.size() > 0) {
                    assignmentNode = ((ExtensionAttribute)assignmentnodeList.get(0)).getValue();
                }
                propertiesNode.put("assignmentnode", assignmentNode);
            }
            if ((currentdeptElement = (List)elementsListMap.get("currentdept")) != null && currentdeptElement.size() > 0) {
                List currentdeptList;
                Boolean currentdeptNode = false;
                Map currentdeptMap = null;
                currentdeptMap = ((ExtensionElement)currentdeptElement.get(0)).getAttributes();
                if (currentdeptMap != null && (currentdeptList = (List)currentdeptMap.get("currentdept")) != null && currentdeptList.size() > 0) {
                    currentdeptNode = Boolean.parseBoolean(((ExtensionAttribute)currentdeptList.get(0)).getValue());
                }
                propertiesNode.put("currentdept", currentdeptNode);
            }
            if ((skipElement = (List)elementsListMap.get("skiprepetition")) != null && skipElement.size() > 0) {
                List skipList;
                Boolean skipNode = false;
                Map skipMap = null;
                skipMap = ((ExtensionElement)skipElement.get(0)).getAttributes();
                if (skipMap != null && (skipList = (List)skipMap.get("skiprepetition")) != null && skipList.size() > 0) {
                    skipNode = Boolean.parseBoolean(((ExtensionAttribute)skipList.get(0)).getValue());
                }
                propertiesNode.put("skiprepetition", skipNode);
            }
        }
        if (userTask.getPriority() != null) {
            this.setPropertyValue("prioritydefinition", userTask.getPriority().toString(), propertiesNode);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userTask.getFormKey())) {
            this.setPropertyValue("formkeydefinition", userTask.getFormKey(), propertiesNode);
        }
        this.setPropertyValue("duedatedefinition", userTask.getDueDate(), propertiesNode);
        this.setPropertyValue("categorydefinition", userTask.getCategory(), propertiesNode);
        this.addFormProperties(userTask.getFormProperties(), propertiesNode);
    }

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ExtendUserTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        ExtendUserTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("UserTask", ExtendUserTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(UserTask.class, ExtendUserTaskJsonConverter.class);
    }
}

