/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.bpm.engine.model.Result;
import com.jxdinfo.hussar.bpm.engine.service.DefinitionEngineService;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.process.model.ProcessDefinitionModel;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.image.impl.DefaultProcessDiagramCanvas;
import org.activiti.image.impl.DefaultProcessDiagramGenerator;
import org.activiti.spring.ProcessEngineFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sun.misc.BASE64Encoder;

@Service
@Transactional(rollbackFor={Exception.class})
public class DefinitionEngineServiceImpl
implements DefinitionEngineService {
    private static Logger LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
    @Autowired
    private ProcessEngineFactoryBean processEngine;
    @Autowired
    private RepositoryService repositoryService;

    @Override
    public Result queryProcessDefListOfHighVersion(String name) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        try {
            List deployments = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + name + "%").latestVersion().orderByProcessDefinitionName().desc()).list();
            ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
            for (ProcessDefinition deployment : deployments) {
                ProcessDefinitionModel item = new ProcessDefinitionModel();
                item.setId(deployment.getId());
                item.setProcessName(deployment.getName());
                item.setVersion(Integer.toString(deployment.getVersion()));
                item.setIsSuspended(Boolean.toString(deployment.isSuspended()));
                item.setDescription(deployment.getDescription());
                item.setCategory(deployment.getCategory());
                item.setDeploymentId(deployment.getDeploymentId());
                if (deployment.getResourceName() != null) {
                    String[] sourceArr = deployment.getResourceName().split("/");
                    item.setResourceName(sourceArr[sourceArr.length - 1]);
                } else {
                    item.setResourceName("");
                }
                if (deployment.getDiagramResourceName() != null) {
                    String[] diagramArr = deployment.getDiagramResourceName().split("/");
                    item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
                } else {
                    item.setDiagramResourceName("");
                }
                Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deployment.getDeploymentId()).singleResult();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String timeStr = sdf.format(deploymentTime.getDeploymentTime());
                item.setDeploymentTime(timeStr);
                result.add(item);
            }
            object.put("data", result);
            object.put("count", (Object)result.size());
            json.add((Object)object);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryProcessDefList(String name) {
        JSONArray json = new JSONArray();
        try {
            List deployments = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + name + "%").orderByProcessDefinitionName().desc()).list();
            ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
            for (ProcessDefinition deployment : deployments) {
                ProcessDefinitionModel item = new ProcessDefinitionModel();
                item.setId(deployment.getId());
                item.setProcessName(deployment.getName());
                item.setVersion(Integer.toString(deployment.getVersion()));
                item.setIsSuspended(Boolean.toString(deployment.isSuspended()));
                item.setDescription(deployment.getDescription());
                item.setCategory(deployment.getCategory());
                item.setDeploymentId(deployment.getDeploymentId());
                if (deployment.getResourceName() != null) {
                    String[] sourceArr = deployment.getResourceName().split("/");
                    item.setResourceName(sourceArr[sourceArr.length - 1]);
                } else {
                    item.setResourceName("");
                }
                if (deployment.getDiagramResourceName() != null) {
                    String[] diagramArr = deployment.getDiagramResourceName().split("/");
                    item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
                } else {
                    item.setDiagramResourceName("");
                }
                Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deployment.getDeploymentId()).singleResult();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String timeStr = sdf.format(deploymentTime.getDeploymentTime());
                item.setDeploymentTime(timeStr);
                result.add(item);
            }
            json.add(result);
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result updateProcessDefinitionState(String state, String processDefinitionId) {
        try {
            if ("active".equals(state)) {
                this.repositoryService.activateProcessDefinitionById(processDefinitionId);
            }
            if ("suspend".equals(state)) {
                this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
            }
            return InstallResult.getResult("1", "success", null);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result deleteProcessDefinition(String processDefinitionId) {
        try {
            this.repositoryService.deleteDeployment(processDefinitionId);
            return InstallResult.getResult("1", "success", null);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result loadFlowResource(String processDefinitionId, String processDefinitionName, String resourceType) {
        JSONArray json = new JSONArray();
        try {
            if ("xml".equals(resourceType)) {
                InputStream in = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(processDefinitionId, processDefinitionName);
                BASE64Encoder encoder = new BASE64Encoder();
                byte[] data = null;
                data = new byte[in.available()];
                String xml = encoder.encode(data);
                json.add((Object)xml);
                return InstallResult.getResult("1", "success", json);
            }
            if ("image".equals(resourceType)) {
                DefaultProcessDiagramGenerator defaultProcessDiagramGenerator = new DefaultProcessDiagramGenerator();
                BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
                InputStream in = defaultProcessDiagramGenerator.generateDiagram(bm, "png", "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null);
                BASE64Encoder encoder = new BASE64Encoder();
                byte[] data = null;
                data = new byte[in.available()];
                String image = encoder.encode(data);
                json.add((Object)image);
                return InstallResult.getResult("1", "success", json);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return InstallResult.getResult("0", "error", null);
    }

    @Override
    public Result queryFlowConfigInfo(String processDefinitionId) {
        try {
            JSONArray json = new JSONArray();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
            List activitiList = processDefinition.getActivities();
            InputStream xmlIs = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getResourceName());
            BpmnModel bm = new BpmnXMLConverter().convertToBpmnModel((InputStreamProvider)new InputStreamSource(xmlIs), false, true);
            Class<?> clazz = Class.forName("org.activiti.image.impl.DefaultProcessDiagramGenerator");
            Method method = clazz.getDeclaredMethod("initProcessDiagramCanvas", BpmnModel.class, String.class, String.class, String.class, String.class, ClassLoader.class);
            method.setAccessible(true);
            DefaultProcessDiagramCanvas pdc = (DefaultProcessDiagramCanvas)method.invoke(clazz.newInstance(), bm, "png", "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null);
            clazz = Class.forName("org.activiti.image.impl.DefaultProcessDiagramCanvas");
            Field minXField = clazz.getDeclaredField("minX");
            Field minYField = clazz.getDeclaredField("minY");
            minXField.setAccessible(true);
            minYField.setAccessible(true);
            int minX = minXField.getInt(pdc);
            int minY = minYField.getInt(pdc);
            minX = minX > 0 ? minX - 5 : 0;
            minY = minY > 0 ? minY - 5 : 0;
            for (ActivityImpl activity : activitiList) {
                JSONObject activityInfo = new JSONObject();
                activityInfo.put("width", (Object)activity.getWidth());
                activityInfo.put("height", (Object)activity.getHeight());
                activityInfo.put("x", (Object)(activity.getX() + 10));
                activityInfo.put("y", (Object)(activity.getY() + 10));
                activityInfo.put("actId", (Object)activity.getId());
                activityInfo.put("name", activity.getProperty("name"));
                if (activity.getProperty("name") == null || "".equals(activity.getProperty("name").toString())) {
                    activityInfo.put("name", (Object)"");
                } else {
                    activityInfo.put("name", activity.getProperty("name"));
                }
                activityInfo.put("type", activity.getProperty("type"));
                ActivityBehavior activityBehavior = activity.getActivityBehavior();
                if (activityBehavior instanceof UserTaskActivityBehavior) {
                    UserTaskActivityBehavior userTaskActivityBehavior = (UserTaskActivityBehavior)activityBehavior;
                    TaskDefinition taskDefinition = userTaskActivityBehavior.getTaskDefinition();
                    if (taskDefinition.getAssigneeExpression() == null || "".equals(taskDefinition.getAssigneeExpression().toString())) {
                        activityInfo.put("assignee", (Object)"\u672a\u8bbe\u7f6e");
                    } else {
                        activityInfo.put("assignee", (Object)taskDefinition.getAssigneeExpression().toString());
                    }
                }
                json.add((Object)activityInfo);
            }
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public Result queryProcess() {
        JSONArray json = new JSONArray();
        List models = ((ModelQuery)this.repositoryService.createModelQuery().deployed().orderByLastUpdateTime().desc()).list();
        if (models != null) {
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            for (Model model : models) {
                JSONObject object = new JSONObject();
                byte[] arg0 = this.repositoryService.getModelEditorSource(model.getId());
                String temp = null;
                try {
                    temp = new String(arg0, "utf-8").replace("undefined", "");
                    JsonNode editorNode = new ObjectMapper().readTree(temp.getBytes("utf-8"));
                    BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
                    if (bpmnModel.getProcesses().size() <= 0) continue;
                    object.put("id", (Object)((Process)bpmnModel.getProcesses().get(0)).getId());
                    object.put("name", (Object)((Process)bpmnModel.getProcesses().get(0)).getName());
                    json.add((Object)object);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public Result queryProcessLink(String processDefinitionKey) {
        JSONArray json = new JSONArray();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        if (processDefinition == null) {
            return InstallResult.getResult("0", "\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49", null);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult("1", "success", json);
        }
        return InstallResult.getResult("0", "\u6d41\u7a0b\u6a21\u578b\u4e3a\u7a7a", null);
    }

    @Override
    public Result queryStartFormUrl(String processDefinitionKey) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            String formUrl = ((StartEvent)flowElement).getFormKey();
            jsonObject.put("formUrl", (Object)formUrl);
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }
}

