layui.use(['jquery','layer','Hussar','jstree','HussarAjax','table','jqForm'], function(){
	var Hussar = layui.Hussar;
	var $ = layui.jquery;
	var layer=layui.layer;
	var $ax=layui.HussarAjax;
	var table = layui.table;
	var jqForm=layui.jqForm;
            table.render({
                elem: '#attachmentTable',
                url:Hussar.ctxPath+'/impModle/queryAttachment',
                cols: [[
                    {type:'checkbox'},
                    {type:'numbers', title: '序号'},
                    {field: 'attachRealName', title: '文件名称', align:'center',event: 'openImpInfo',style:'cursor: pointer;color:#00a4ff'},
                    {field: 'attachType', title: '文件类型', align:'center',},
                    {field: 'impAttachTime', title: '文件导入时间', align:'center'},
                    {field: 'impAttachUser', title: '文件导入用户', align:'center'},
                    {field: 'attachId', title: '文件下载', align:'center',event: 'download', style:'cursor: pointer;color:#00a4ff',templet:Format}
                ]],
                page: true,
                height:$("body").height() - $(".toolbar").outerHeight(true) -70,
                loading:true,
                text: {
                    none: '暂无相关数据' //默认：无数据。注：该属性为 layui 2.2.5 开始新增
                }
                ,even: true
            });
            table.on('tool(clickEvent)', function(obj){
                var data = obj.data;
                var attachId = data.attachId;
                var url = Hussar.ctxPath+'/impModle/impModleView?attachId='+attachId;
                if(obj.event === 'openImpInfo'){
                    layui.use('layer', function(){
                        var layer = layui.layer;
                        layer.open({
                            type: 1,
                            title:"导入详情",
                            content: $('#picWindow'), //这里content是一个DOM，注意：最好该元素要存放在body最外层，否则可能被其它的相对元素所影响
                            area: ["1000px", "400px"],
                            success: function(){
                                $('#impIframe').attr("src",url);
                            },
                            end: function () {
                                $('#picWindow').hide();
                            }
                        });
                    });
                }else if(obj.event === 'download'){
                    var url = Hussar.ctxPath + "/impModle/downloadFile";
                    var form = $("<form></form>").attr("action", url).attr("method", "post");
                    form.append($("<input></input>").attr("type", "hidden").attr("name", "attachId").attr("value", attachId));
                    form.appendTo('body').submit().remove();
                    //window.location.href=Hussar.ctxPath+"/impModle/downloadFile?attachId="+encodeURIComponent(attachId);
                }
            });
            /*查询*/
            $("#search").click(function () {
                reloadTable();
            });
            function reloadTable() {
                var table = layui.table;
                table.reload("attachmentTable", {
                    page : {
                        curr : 1
                        // 重新从第 1 页开始
                    },
                    where: {
                        attachName: $('#attachName').val(),
                    }
                });
            }
            /*重置*/
            $("#reset").click(function () {
                //模型名称
                $('#attachName').val('');
                reloadTable();
            });

            /*导入*/
            $("#import").click(function(){
                $("#importFlag").val("import");
                importForm();
                $('#importSave').removeAttr('disabled');
            });
            /*导入保存*/
            $("#importSave").click(function () {
                $("#importSave").attr("disabled","true");
                importSave();
            });
            /*批量导入*/
            $("#batchImport").click(function(){
                $("#importFlag").val("batchImport");
                importForm();
            });
            /*导入*/
            function importForm() {
                var that = this;
                layerView = layer.open({
        			type : 1,
        			area : ['440px', '160px'],
        			title : "导入模型",
        			//shift : 6,
        			shadeClose : false,
        			maxmin : false,
        			content : $("#importEvent"),
        			shadeClose:false,
        			success : function() {
        				$('#importForm')[0].reset();
        			}
        		});
            }
            /*导入保存*/
            function importSave() {
                $("#importSave").attr("disabled","true");
                var that = this;
                var name = $("#importFileInput").val();
                if(name==""){
                    Hussar.info("流程模型文件不能为空");
                    return;
                }
                var str  = name .substring(name .lastIndexOf(".") + 1, name .length);
                var url;
                if ($("#importFlag").val() == "batchImport") {
                    if (str != "zip" || str =="" || str ==null){
                        Hussar.info("请选择ZIP文件");
                        $('#importSave').removeAttr('disabled');
                        return;
                    }
                    url = Hussar.ctxPath+"/model/batchImport";
                }
                if($("#importFlag").val() == "import"){
                    if (str != "xml" || str =="" || str ==null){
                        Hussar.info("请选择XML文件");
                        $('#importSave').removeAttr('disabled');
                        return;
                    }
                    url = Hussar.ctxPath+"/model/modelImport";
                }
                $("#importForm").ajaxSubmit({
                    url:url,
                    type:"post",
                    success:function (data) {
                        var jsObject = JSON.parse(data);
                        var result= jsObject.result;
                        var flags = JSON.parse(result);
                        var re = flags.flag;
                        if(re=="true"){
                            layer.closeAll();
                            layer.close(layer.index);
                            reloadTable();
                            Hussar.success("导入成功");
                            $('#importSave').removeAttr('disabled');
                        }
                        if(re=="false"){
                            Hussar.error("导入失败");
                            $('#importSave').removeAttr('disabled');
                        }
                    }
                })
            }
            function Format(params) {
                if(params != ""){
                    return "下载";
                }else {
                    return "";
                }
            }
            function FormatTime(params) {
                var p = new Date(parseInt(params)).format("yyyy-MM-dd hh:mm:ss")
                return p;
            }
            /*删除*/
            $('#delete').click(function(){
                var ids = [];
                var table = layui.table;
                var checkStatus = table.checkStatus("attachmentTable");
                var data = checkStatus.data;
                for(var i=0;i<data.length;i++){    //循环筛选出id
                    ids.push(data[i].attachId);
                }

                if(data.length == 0){
                    Hussar.info("请选择要删除的记录");
                }else{
                    var eId = ids.join(',');
                    var operation =function(){
                        var ajax = new $ax(Hussar.ctxPath+"/impModle/deleteAttach",
                            function(data) {
                                var jsObject = JSON.parse(data);
                                var result= jsObject.result;
                                var flags = JSON.parse(result);
                                var re = flags.flag;
                                if(re=="true"){
                                    Hussar.success("删除成功");
                                    reloadTable();
                                }
                                if(re=="false"){
                                    Hussar.error("删除失败");
                                }
                            }, function(data) {
                                Hussar.error("删除失败！");
                            });
                        ajax.set("attachId", eId);
                        ajax.start();
                    };
                    Hussar.confirm("确定要删除吗 ?", operation);
                }
            });
            Date.prototype.format = function(fmt) {
                var o = {
                    "M+" : this.getMonth()+1,                 //月份
                    "d+" : this.getDate(),                    //日
                    "h+" : this.getHours(),                   //小时
                    "m+" : this.getMinutes(),                 //分
                    "s+" : this.getSeconds(),                 //秒
                    "q+" : Math.floor((this.getMonth()+3)/3), //季度
                    "S"  : this.getMilliseconds()             //毫秒
                };
                if(/(y+)/.test(fmt)) {
                    fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
                }
                for(var k in o) {
                    if(new RegExp("("+ k +")").test(fmt)){
                        fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
                    }
                }
                return fmt;
            }
        });
